/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.gitlab.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import feign.form.FormData;
import java.util.List;
import java.util.Map;
import org.jreleaser.sdk.gitlab.api.FileUpload;
import org.jreleaser.sdk.gitlab.api.Link;
import org.jreleaser.sdk.gitlab.api.LinkRequest;
import org.jreleaser.sdk.gitlab.api.Milestone;
import org.jreleaser.sdk.gitlab.api.Project;
import org.jreleaser.sdk.gitlab.api.Release;
import org.jreleaser.sdk.gitlab.api.User;

public interface GitlabAPI {
    @RequestLine(value="GET /user")
    public User getCurrentUser();

    @RequestLine(value="GET /projects/{projectId}")
    @Headers(value={"Content-Type: application/json"})
    public Project getProject(@Param(value="projectId") String var1);

    @RequestLine(value="GET /users/{userId}/projects")
    public List<Project> getProject(@Param(value="userId") Integer var1, @QueryMap Map<String, Object> var2);

    @RequestLine(value="POST /projects")
    @Headers(value={"Content-Type: multipart/form-data"})
    public Project createProject(@Param(value="name") String var1, @Param(value="visibility") String var2);

    @RequestLine(value="GET /projects/{projectId}/releases/{tagName}")
    public Release getRelease(@Param(value="projectId") Integer var1, @Param(value="tagName") String var2);

    @RequestLine(value="DELETE /projects/{projectId}/repository/tags/{tagName}")
    public void deleteTag(@Param(value="projectId") Integer var1, @Param(value="tagName") String var2);

    @RequestLine(value="DELETE /projects/{projectId}/releases/{tagName}")
    public void deleteRelease(@Param(value="projectId") Integer var1, @Param(value="tagName") String var2);

    @RequestLine(value="POST /projects/{projectId}/releases")
    @Headers(value={"Content-Type: application/json"})
    public void createRelease(Release var1, @Param(value="projectId") Integer var2);

    @RequestLine(value="PUT /projects/{projectId}/releases/{tagName}")
    @Headers(value={"Content-Type: application/json"})
    public void updateRelease(Release var1, @Param(value="projectId") Integer var2);

    @RequestLine(value="POST /projects/{projectId}/uploads")
    @Headers(value={"Content-Type: multipart/form-data"})
    public FileUpload uploadFile(@Param(value="projectId") Integer var1, @Param(value="file") FormData var2);

    @RequestLine(value="POST /projects/{projectId}/releases/{tagName}/assets/links")
    @Headers(value={"Content-Type: multipart/form-data"})
    public Link linkAsset(LinkRequest var1, @Param(value="projectId") Integer var2, @Param(value="tagName") String var3);

    @RequestLine(value="GET /projects/{projectId}/milestones")
    public List<Milestone> findMilestoneByTitle(@Param(value="projectId") Integer var1, @QueryMap Map<String, Object> var2);

    @RequestLine(value="PUT /projects/{projectId}/milestones/{milestoneId}")
    @Headers(value={"Content-Type: application/json"})
    public void updateMilestone(Map<String, Object> var1, @Param(value="projectId") Integer var2, @Param(value="milestoneId") Integer var3);

    @RequestLine(value="GET /search")
    @Headers(value={"Content-Type: application/json"})
    public List<User> searchUser(@QueryMap Map<String, String> var1);
}

