/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Project;
import org.jreleaser.model.Snap;
import org.jreleaser.model.packager.spi.PackagerProcessingException;
import org.jreleaser.packagers.AbstractRepositoryPackagerProcessor;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.command.Command;

public class SnapPackagerProcessor
extends AbstractRepositoryPackagerProcessor<Snap> {
    public SnapPackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props, Path packageDirectory) throws PackagerProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(distribution, props);
        if (((Snap)this.packager).isRemoteBuild()) {
            return;
        }
        if (PlatformUtils.isWindows()) {
            this.context.getLogger().debug(RB.$((String)"ERROR_packager_excludes_platform", (Object[])new Object[]{"Windows"}));
            return;
        }
        this.createSnap(distribution, props);
    }

    @Override
    protected void doPublishDistribution(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        if (((Snap)this.packager).isRemoteBuild()) {
            super.doPublishDistribution(distribution, props);
            return;
        }
        if (this.context.isDryrun()) {
            this.context.getLogger().error(RB.$((String)"dryrun.set", (Object[])new Object[0]));
            return;
        }
        if (PlatformUtils.isWindows()) {
            this.context.getLogger().debug(RB.$((String)"ERROR_packager_excludes_platform", (Object[])new Object[]{"Windows"}));
            return;
        }
        this.login(distribution, props);
        this.push(distribution, props);
    }

    @Override
    protected void fillPackagerProperties(Map<String, Object> props, Distribution distribution) throws PackagerProcessingException {
        GitService gitService = this.context.getModel().getRelease().getGitService();
        String desc = this.context.getModel().getProject().getLongDescription();
        desc = Arrays.stream(desc.split(System.lineSeparator())).map(line -> "  " + line).collect(Collectors.joining(System.lineSeparator()));
        props.put("projectLongDescription", MustacheUtils.passThrough((String)("|" + System.lineSeparator() + desc)));
        props.put("snapRepoUrl", gitService.getResolvedRepoUrl(this.context.getModel(), ((Snap)this.packager).getSnap().getOwner(), ((Snap)this.packager).getSnap().getResolvedName()));
        props.put("snapRepoCloneUrl", gitService.getResolvedRepoCloneUrl(this.context.getModel(), ((Snap)this.packager).getSnap().getOwner(), ((Snap)this.packager).getSnap().getResolvedName()));
        props.put("snapPackageName", ((Snap)this.packager).getPackageName());
        props.put("snapBase", ((Snap)this.packager).getBase());
        props.put("snapGrade", ((Snap)this.packager).getGrade());
        props.put("snapConfinement", ((Snap)this.packager).getConfinement());
        props.put("snapHasPlugs", !((Snap)this.packager).getPlugs().isEmpty());
        props.put("snapPlugs", ((Snap)this.packager).getPlugs());
        props.put("snapHasSlots", !((Snap)this.packager).getSlots().isEmpty());
        props.put("snapSlots", ((Snap)this.packager).getSlots());
        props.put("snapHasLocalPlugs", !((Snap)this.packager).getLocalPlugs().isEmpty());
        props.put("snapLocalPlugs", ((Snap)this.packager).getLocalPlugs());
        props.put("snapHasLocalSlots", !((Snap)this.packager).getLocalSlots().isEmpty());
        props.put("snapLocalSlots", ((Snap)this.packager).getLocalSlots());
        props.put("hasArchitectures", !((Snap)this.packager).getArchitectures().isEmpty());
        props.put("snapArchitectures", ((Snap)this.packager).getArchitectures());
    }

    @Override
    protected void writeFile(Project project, Distribution distribution, String content, Map<String, Object> props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        fileName = TemplateUtils.trimTplExtension((String)fileName);
        Path outputFile = outputDirectory.resolve(fileName);
        this.writeFile(content, outputFile);
    }

    private void login(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        Command cmd = new Command("snapcraft").arg("login").arg("--with").arg(this.context.getBasedir().resolve(distribution.getSnap().getExportedLogin()).toAbsolutePath().toString());
        this.executeCommand(cmd);
    }

    private void push(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        Path packageDirectory = (Path)props.get("distributionPackageDirectory");
        String version = (String)props.get("projectEffectiveVersion");
        String snapName = ((Snap)this.packager).getPackageName() + "-" + version + ".snap";
        Command cmd = new Command("snapcraft").arg("push").arg(snapName);
        this.executeCommand(packageDirectory, cmd);
    }

    private void createSnap(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        Path packageDirectory = (Path)props.get("distributionPackageDirectory");
        String version = (String)props.get("projectEffectiveVersion");
        String snapName = ((Snap)this.packager).getPackageName() + "-" + version + ".snap";
        Command cmd = new Command("snapcraft").arg("snap").arg("--output").arg(snapName);
        this.executeCommand(packageDirectory, cmd);
    }
}

