/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.assemble;

import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.assemble.AssemblerProcessors;
import org.jreleaser.model.Assembler;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.assembler.spi.AssemblerProcessingException;
import org.jreleaser.model.assembler.spi.AssemblerProcessor;

public class DistributionAssembler {
    private final JReleaserContext context;
    private final Assembler assembler;
    private final Path outputDirectory;

    private DistributionAssembler(JReleaserContext context, Assembler assembler) {
        this.context = context;
        this.assembler = assembler;
        this.outputDirectory = context.getOutputDirectory();
    }

    public Assembler getAssembler() {
        return this.assembler;
    }

    public void assemble() throws AssemblerProcessingException {
        if (!this.assembler.isEnabled()) {
            this.context.getLogger().debug(RB.$((String)"assemblers.distribution.skip", (Object[])new Object[0]), new Object[]{this.assembler.getName()});
            return;
        }
        AssemblerProcessor<Assembler> assemblerProcessor = AssemblerProcessors.findProcessor(this.context, this.assembler);
        this.context.getLogger().info(RB.$((String)"assemblers.distribution.assemble", (Object[])new Object[0]), new Object[]{this.assembler.getName()});
        assemblerProcessor.assemble(this.initProps());
    }

    private Map<String, Object> initProps() {
        Map props = this.context.props();
        props.put("baseOutputDirectory", this.outputDirectory.getParent());
        props.put("outputDirectory", this.outputDirectory);
        props.put("assembleDirectory", this.context.getAssembleDirectory());
        props.put("distributionAssembleDirectory", this.context.getAssembleDirectory().resolve(this.assembler.getName()).resolve(this.assembler.getType()));
        return props;
    }

    public static DistributionAssemblerBuilder builder() {
        return new DistributionAssemblerBuilder();
    }

    public static class DistributionAssemblerBuilder {
        private JReleaserContext context;
        private Assembler assembler;

        public DistributionAssemblerBuilder context(JReleaserContext context) {
            this.context = Objects.requireNonNull(context, "'context' must not be null");
            return this;
        }

        public DistributionAssemblerBuilder assembler(Assembler assembler) {
            this.assembler = Objects.requireNonNull(assembler, "'assembler' must not be null");
            return this;
        }

        public DistributionAssembler build() {
            Objects.requireNonNull(this.context, "'context' must not be null");
            Objects.requireNonNull(this.assembler, "'assembler' must not be null");
            return new DistributionAssembler(this.context, this.assembler);
        }
    }
}

