/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.util;

import java.net.MalformedURLException;
import java.net.URL;

public final class ResourceUtils {
    private ResourceUtils() {
    }

    public static URL resolveLocation(Class<?> klass) {
        String suffix;
        if (klass == null) {
            return null;
        }
        try {
            URL codeSourceLocation = klass.getProtectionDomain().getCodeSource().getLocation();
            if (codeSourceLocation != null) {
                return codeSourceLocation;
            }
        }
        catch (NullPointerException | SecurityException codeSourceLocation) {
            // empty catch block
        }
        URL classResource = klass.getResource(klass.getSimpleName() + ".class");
        if (classResource == null) {
            return null;
        }
        String url = classResource.toString();
        if (!url.endsWith(suffix = klass.getCanonicalName().replace('.', '/') + ".class")) {
            return null;
        }
        String path = url.substring(0, url.length() - suffix.length());
        if (path.startsWith("jar:")) {
            path = path.substring(4, path.length() - 2);
        }
        try {
            return new URL(path);
        }
        catch (MalformedURLException ignored) {
            return null;
        }
    }
}

