/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.gitter;

import java.util.LinkedHashMap;
import org.jreleaser.model.Gitter;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.announcer.spi.AnnounceException;
import org.jreleaser.model.announcer.spi.Announcer;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.gitter.Message;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;

public class GitterAnnouncer
implements Announcer {
    private final JReleaserContext context;

    GitterAnnouncer(JReleaserContext context) {
        this.context = context;
    }

    public String getName() {
        return "gitter";
    }

    public boolean isEnabled() {
        return this.context.getModel().getAnnounce().getGitter().isEnabled();
    }

    public void announce() throws AnnounceException {
        Gitter gitter = this.context.getModel().getAnnounce().getGitter();
        String message = "";
        if (StringUtils.isNotBlank((String)gitter.getMessage())) {
            message = gitter.getResolvedMessage(this.context);
        } else {
            LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
            props.put("changelog", MustacheUtils.passThrough((String)this.context.getChangelog()));
            this.context.getModel().getRelease().getGitService().fillProps(props, this.context.getModel());
            message = gitter.getResolvedMessageTemplate(this.context, props);
        }
        this.context.getLogger().info("message: {}", new Object[]{message});
        if (!this.context.isDryrun()) {
            ClientUtils.webhook((JReleaserLogger)this.context.getLogger(), (String)gitter.getResolvedWebhook(), (int)gitter.getConnectTimeout(), (int)gitter.getReadTimeout(), (Object)Message.of(message));
        }
    }
}

