/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.slack;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Slack;
import org.jreleaser.model.announcer.spi.AnnounceException;
import org.jreleaser.model.announcer.spi.Announcer;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.slack.SlackException;
import org.jreleaser.sdk.slack.SlackSdk;
import org.jreleaser.sdk.slack.api.Message;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;

public class SlackAnnouncer
implements Announcer {
    private final JReleaserContext context;

    SlackAnnouncer(JReleaserContext context) {
        this.context = context;
    }

    public String getName() {
        return "slack";
    }

    public boolean isEnabled() {
        return this.context.getModel().getAnnounce().getSlack().isEnabled();
    }

    public void announce() throws AnnounceException {
        Slack slack = this.context.getModel().getAnnounce().getSlack();
        String message = "";
        if (StringUtils.isNotBlank((String)slack.getMessage())) {
            message = slack.getResolvedMessage(this.context);
        } else {
            LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
            props.put("changelog", MustacheUtils.passThrough((String)this.context.getChangelog()));
            this.context.getModel().getRelease().getGitService().fillProps(props, this.context.getModel());
            message = slack.getResolvedMessageTemplate(this.context, props);
        }
        this.context.getLogger().debug("message: {}", new Object[]{message});
        ArrayList<String> errors = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)slack.getResolvedToken())) {
            this.context.getLogger().info("channel: {}", new Object[]{slack.getChannel()});
            try {
                SlackSdk sdk = SlackSdk.builder(this.context.getLogger()).connectTimeout(slack.getConnectTimeout()).readTimeout(slack.getReadTimeout()).token(this.context.isDryrun() ? "**UNDEFINED**" : slack.getResolvedToken()).dryrun(this.context.isDryrun()).build();
                sdk.message(slack.getChannel(), message);
            }
            catch (SlackException e) {
                this.context.getLogger().trace((Throwable)e);
                errors.add(e.toString());
            }
        }
        if (StringUtils.isNotBlank((String)slack.getResolvedWebhook()) && !this.context.isDryrun()) {
            try {
                ClientUtils.webhook((JReleaserLogger)this.context.getLogger(), (String)slack.getResolvedWebhook(), (int)slack.getConnectTimeout(), (int)slack.getReadTimeout(), (Object)Message.of(message));
            }
            catch (AnnounceException e) {
                this.context.getLogger().trace((Throwable)e);
                errors.add(e.toString());
            }
        }
        if (!errors.isEmpty()) {
            throw new AnnounceException(String.join((CharSequence)System.lineSeparator(), errors));
        }
    }
}

