/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.AbstractUploader;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.HttpUploader;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.util.Templates;

abstract class AbstractHttpUploader
extends AbstractUploader
implements HttpUploader {
    private String uploadUrl;
    private String downloadUrl;

    protected AbstractHttpUploader(String type) {
        super(type);
    }

    void setAll(AbstractHttpUploader uploader) {
        super.setAll(uploader);
        this.uploadUrl = uploader.uploadUrl;
        this.downloadUrl = uploader.downloadUrl;
    }

    @Override
    public String getResolvedDownloadUrl(JReleaserContext context, Artifact artifact) {
        return this.getResolvedDownloadUrl(context.props(), artifact);
    }

    @Override
    public String getResolvedDownloadUrl(Map<String, Object> props, Artifact artifact) {
        LinkedHashMap<String, Object> p = new LinkedHashMap<String, Object>(this.artifactProps(props, artifact));
        p.putAll(this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)this.downloadUrl, p);
    }

    @Override
    public String getResolvedUploadUrl(JReleaserContext context, Artifact artifact) {
        LinkedHashMap<String, Object> p = new LinkedHashMap<String, Object>(this.artifactProps(context, artifact));
        p.putAll(this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)this.uploadUrl, p);
    }

    @Override
    public String getUploadUrl() {
        return this.uploadUrl;
    }

    @Override
    public void setUploadUrl(String uploadUrl) {
        this.uploadUrl = uploadUrl;
    }

    @Override
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    @Override
    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    @Override
    protected void asMap(Map<String, Object> props, boolean full) {
        props.put("uploadUrl", this.uploadUrl);
        props.put("downloadUrl", this.downloadUrl);
    }
}

