/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.AbstractAssembler;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Templates;

public class Archive
extends AbstractAssembler {
    public static final String TYPE = "archive";
    private final Set<Format> formats = new LinkedHashSet<Format>();
    private String archiveName;
    private Boolean attachPlatform;
    private Distribution.DistributionType distributionType;

    public Archive() {
        super(TYPE);
    }

    @Override
    public Distribution.DistributionType getDistributionType() {
        return this.distributionType;
    }

    public void setDistributionType(Distribution.DistributionType distributionType) {
        this.distributionType = distributionType;
    }

    public void setDistributionType(String distributionType) {
        this.distributionType = Distribution.DistributionType.of(distributionType);
    }

    void setAll(Archive archive) {
        super.setAll(archive);
        this.archiveName = archive.archiveName;
        this.distributionType = archive.distributionType;
        this.attachPlatform = archive.attachPlatform;
        this.setFormats(archive.formats);
    }

    public String getResolvedArchiveName(JReleaserContext context) {
        Map<String, Object> props = context.props();
        props.putAll(this.props());
        String result = Templates.resolveTemplate((String)this.archiveName, props);
        if (this.isAttachPlatform()) {
            result = result + "-" + this.getPlatform().applyReplacements(PlatformUtils.getCurrentFull());
        }
        return result;
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    public void setArchiveName(String archiveName) {
        this.archiveName = archiveName;
    }

    public boolean isAttachPlatformSet() {
        return this.attachPlatform;
    }

    public boolean isAttachPlatform() {
        return this.attachPlatform != null && this.attachPlatform != false;
    }

    public void setAttachPlatform(Boolean attachPlatform) {
        this.attachPlatform = attachPlatform;
    }

    public Set<Format> getFormats() {
        return this.formats;
    }

    public void setFormats(Set<Format> formats) {
        this.formats.clear();
        this.formats.addAll(formats);
    }

    public void addFormat(Format format) {
        this.formats.add(format);
    }

    public void addFormat(String str) {
        this.formats.add(Format.of(str));
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("archiveName", this.archiveName);
        props.put("distributionType", (Object)this.distributionType);
        props.put("attachPlatform", this.isAttachPlatform());
        props.put("formats", this.formats);
    }

    public static enum Format {
        ZIP("zip"),
        TAR("tar"),
        TAR_BZ2("tar.bz2"),
        TAR_GZ("tar.gz"),
        TAR_XZ("tar.xz"),
        TBZ2("tbz2"),
        TGZ("tgz"),
        TXZ("txz");

        private final String extension;

        private Format(String extension) {
            this.extension = extension;
        }

        public String extension() {
            return this.extension;
        }

        public String toString() {
            return this.extension();
        }

        public static Format of(String str) {
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            return Format.valueOf(str.toUpperCase().trim().replace(".", "_"));
        }
    }
}

