/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.AbstractRepositoryPackager;
import org.jreleaser.model.AbstractRepositoryTap;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.RepositoryTap;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Env;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class Chocolatey
extends AbstractRepositoryPackager {
    public static final String CHOCOLATEY_API_KEY = "CHOCOLATEY_API_KEY";
    public static final String TYPE = "chocolatey";
    public static final String SKIP_CHOCOLATEY = "skipChocolatey";
    public static final String DEFAULT_CHOCOLATEY_PUSH_URL = "https://push.chocolatey.org/";
    private static final Map<Distribution.DistributionType, Set<String>> SUPPORTED = new LinkedHashMap<Distribution.DistributionType, Set<String>>();
    private final ChocolateyBucket bucket = new ChocolateyBucket();
    private String packageName;
    private String username;
    private String apiKey;
    private String title;
    private String iconUrl;
    private String source;
    private Boolean remoteBuild;

    public Chocolatey() {
        super(TYPE);
    }

    void setAll(Chocolatey choco) {
        super.setAll(choco);
        this.packageName = choco.packageName;
        this.username = choco.username;
        this.apiKey = choco.apiKey;
        this.title = choco.title;
        this.iconUrl = choco.iconUrl;
        this.source = choco.source;
        this.remoteBuild = choco.remoteBuild;
        this.setBucket(choco.bucket);
    }

    public String getResolvedApiKey() {
        return Env.resolve((String)CHOCOLATEY_API_KEY, (String)this.apiKey);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public boolean isRemoteBuild() {
        return this.remoteBuild != null && this.remoteBuild != false;
    }

    public void setRemoteBuild(Boolean remoteBuild) {
        this.remoteBuild = remoteBuild;
    }

    public boolean isRemoteBuildSet() {
        return this.remoteBuild != null;
    }

    public ChocolateyBucket getBucket() {
        return this.bucket;
    }

    public void setBucket(ChocolateyBucket bucket) {
        this.bucket.setAll(bucket);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("packageName", this.packageName);
        props.put("username", this.username);
        props.put("apiKey", StringUtils.isNotBlank((String)this.getResolvedApiKey()) ? "************" : "**unset**");
        props.put("remoteBuild", this.isRemoteBuild());
        props.put("title", this.title);
        props.put("iconUrl", this.iconUrl);
        props.put("source", this.source);
        props.put("bucket", this.bucket.asMap(full));
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.bucket;
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return StringUtils.isBlank((String)platform) || PlatformUtils.isWindows((String)platform) && PlatformUtils.isIntel((String)platform);
    }

    @Override
    public boolean supportsDistribution(Distribution distribution) {
        return SUPPORTED.containsKey((Object)distribution.getType());
    }

    @Override
    public Set<String> getSupportedExtensions(Distribution distribution) {
        return SUPPORTED.getOrDefault((Object)distribution.getType(), Collections.emptySet());
    }

    @Override
    protected boolean isNotSkipped(Artifact artifact) {
        return StringUtils.isFalse((Object)artifact.getExtraProperties().get(SKIP_CHOCOLATEY));
    }

    static {
        Set extensions = CollectionUtils.newSet((Object[])new String[]{FileType.ZIP.extension()});
        SUPPORTED.put(Distribution.DistributionType.BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JAVA_BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JLINK, extensions);
        SUPPORTED.put(Distribution.DistributionType.NATIVE_IMAGE, extensions);
        SUPPORTED.put(Distribution.DistributionType.NATIVE_PACKAGE, CollectionUtils.newSet((Object[])new String[]{FileType.EXE.extension(), FileType.MSI.extension()}));
    }

    public static class ChocolateyBucket
    extends AbstractRepositoryTap {
        public ChocolateyBucket() {
            super(Chocolatey.TYPE, "chocolatey-bucket");
        }
    }
}

