/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.List;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Chocolatey;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.validation.DistributionsValidator;
import org.jreleaser.model.validation.ExtraPropertiesValidator;
import org.jreleaser.model.validation.TemplateValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class ChocolateyValidator
extends Validator {
    public static void validateChocolatey(JReleaserContext context, Distribution distribution, Chocolatey packager, Errors errors) {
        JReleaserModel model = context.getModel();
        Chocolatey parentPackager = model.getPackagers().getChocolatey();
        if (!packager.isActiveSet() && parentPackager.isActiveSet()) {
            packager.setActive(parentPackager.getActive());
        }
        if (!packager.resolveEnabled(context.getModel().getProject(), distribution)) {
            return;
        }
        GitService service = model.getRelease().getGitService();
        if (!service.isReleaseSupported()) {
            packager.disable();
            return;
        }
        context.getLogger().debug("distribution.{}.chocolatey", new Object[]{distribution.getName()});
        List<Artifact> candidateArtifacts = packager.resolveCandidateArtifacts(context, distribution);
        if (candidateArtifacts.size() == 0) {
            packager.setActive(Active.NEVER);
            packager.disable();
            return;
        }
        if (candidateArtifacts.size() > 1) {
            errors.configuration(RB.$((String)"validation_packager_multiple_artifacts", (Object[])new Object[]{"distribution." + distribution.getName() + ".chocolatey"}));
            packager.disable();
            return;
        }
        ChocolateyValidator.validateCommitAuthor(packager, parentPackager);
        Chocolatey.ChocolateyBucket bucket = packager.getBucket();
        bucket.resolveEnabled(model.getProject());
        ChocolateyValidator.validateTap(context, distribution, bucket, parentPackager.getBucket(), "chocolatey.bucket");
        TemplateValidator.validateTemplate(context, distribution, packager, parentPackager, errors);
        ExtraPropertiesValidator.mergeExtraProperties(packager, parentPackager);
        ChocolateyValidator.validateContinueOnError(packager, parentPackager);
        if (StringUtils.isBlank((String)packager.getDownloadUrl())) {
            packager.setDownloadUrl(parentPackager.getDownloadUrl());
        }
        if (StringUtils.isBlank((String)packager.getPackageName())) {
            packager.setPackageName(parentPackager.getPackageName());
            if (StringUtils.isBlank((String)packager.getPackageName())) {
                packager.setPackageName(distribution.getName());
            }
        }
        if (StringUtils.isBlank((String)packager.getUsername())) {
            packager.setUsername(service.getOwner());
        }
        if (!packager.isRemoteBuildSet() && parentPackager.isRemoteBuildSet()) {
            packager.setRemoteBuild(parentPackager.isRemoteBuild());
        }
        if (StringUtils.isBlank((String)packager.getTitle())) {
            packager.setTitle(parentPackager.getTitle());
        }
        if (StringUtils.isBlank((String)packager.getTitle())) {
            packager.setTitle(model.getProject().getName());
        }
        if (StringUtils.isBlank((String)packager.getIconUrl())) {
            packager.setIconUrl(parentPackager.getIconUrl());
        }
        if (StringUtils.isBlank((String)packager.getSource())) {
            packager.setSource(parentPackager.getSource());
        }
        if (StringUtils.isBlank((String)packager.getSource())) {
            packager.setSource("https://push.chocolatey.org/");
        }
        if (!packager.isRemoteBuild()) {
            packager.setApiKey(ChocolateyValidator.checkProperty(context, "CHOCOLATEY_API_KEY", "chocolatey.apiKey", packager.getApiKey(), errors, context.isDryrun()));
        }
        DistributionsValidator.validateArtifactPlatforms(context, distribution, packager, candidateArtifacts, errors);
    }
}

