/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import org.jreleaser.cli.AbstractPlatformAwareModelCommand;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.workflow.Workflows;
import picocli.CommandLine;

@CommandLine.Command(name="announce")
public class Announce
extends AbstractPlatformAwareModelCommand {
    @CommandLine.Option(names={"--dry-run"})
    boolean dryrun;
    @CommandLine.ArgGroup
    Composite composite;

    @Override
    protected void doExecute(JReleaserContext context) {
        if (null != this.composite) {
            context.setIncludedAnnouncers(this.collectEntries(this.composite.includedAnnouncers(), true));
            context.setExcludedAnnouncers(this.collectEntries(this.composite.excludedAnnouncers(), true));
        }
        Workflows.announce((JReleaserContext)context).execute();
    }

    @Override
    protected boolean dryrun() {
        return this.dryrun;
    }

    static class Exclude {
        @CommandLine.Option(names={"-xa", "--exclude-announcer"}, paramLabel="<announcer>")
        String[] excludedAnnouncers;

        Exclude() {
        }
    }

    static class Include {
        @CommandLine.Option(names={"-a", "--announcer"}, paramLabel="<announcer>")
        String[] includedAnnouncers;

        Include() {
        }
    }

    static class Composite {
        @CommandLine.ArgGroup(exclusive=false, order=1, headingKey="include.filter.header")
        Include include;
        @CommandLine.ArgGroup(exclusive=false, order=2, headingKey="exclude.filter.header")
        Exclude exclude;

        Composite() {
        }

        String[] includedAnnouncers() {
            return this.include != null ? this.include.includedAnnouncers : null;
        }

        String[] excludedAnnouncers() {
            return this.exclude != null ? this.exclude.excludedAnnouncers : null;
        }
    }
}

