/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.GitService;
import org.jreleaser.model.Project;
import org.jreleaser.model.RepositoryTap;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Templates;

public abstract class AbstractRepositoryTap
implements RepositoryTap {
    protected Active active;
    @JsonIgnore
    protected boolean enabled;
    @JsonIgnore
    protected String basename;
    @JsonIgnore
    protected String tapName;
    protected String owner;
    protected String name;
    protected String tagName;
    protected String branch;
    protected String username;
    protected String token;
    protected String commitMessage;

    AbstractRepositoryTap(String basename, String tapName) {
        this.basename = basename;
        this.tapName = tapName;
    }

    @Override
    public String getBasename() {
        return this.basename;
    }

    public void setTapName(String tapName) {
        this.tapName = tapName;
    }

    void setAll(AbstractRepositoryTap tap) {
        this.active = tap.active;
        this.enabled = tap.enabled;
        this.owner = tap.owner;
        this.name = tap.name;
        this.tagName = tap.tagName;
        this.branch = tap.branch;
        this.username = tap.username;
        this.token = tap.token;
        this.commitMessage = tap.commitMessage;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.active = Active.RELEASE;
        }
        this.enabled = this.active.check(project);
        return this.enabled;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.active = Active.of(str);
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    @Override
    public String getCanonicalRepoName() {
        return this.owner + "/" + this.getResolvedName();
    }

    @Override
    public String getResolvedName() {
        if (StringUtils.isNotBlank((String)this.name)) {
            return this.name;
        }
        return this.tapName;
    }

    @Override
    public String getResolvedCommitMessage(Map<String, Object> props) {
        return Templates.resolveTemplate((String)this.commitMessage, props);
    }

    @Override
    public String getResolvedTagName(Map<String, Object> props) {
        return Templates.resolveTemplate((String)this.tagName, props);
    }

    @Override
    public String getResolvedUsername(GitService service) {
        return Env.resolve((String)(Env.toVar((String)(this.basename + "_" + service.getServiceName())) + "_USERNAME"), (String)this.username);
    }

    @Override
    public String getResolvedToken(GitService service) {
        return Env.resolve((String)(Env.toVar((String)(this.basename + "_" + service.getServiceName())) + "_TOKEN"), (String)this.token);
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getTagName() {
        return this.tagName;
    }

    @Override
    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    @Override
    public String getBranch() {
        return this.branch;
    }

    @Override
    public void setBranch(String branch) {
        this.branch = branch;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public void setToken(String token) {
        this.token = token;
    }

    @Override
    public String getCommitMessage() {
        return this.commitMessage;
    }

    @Override
    public void setCommitMessage(String commitMessage) {
        this.commitMessage = commitMessage;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("active", (Object)this.active);
        map.put("owner", this.owner);
        map.put("name", this.getResolvedName());
        map.put("tagName", this.tagName);
        map.put("branch", this.branch);
        map.put("username", this.username);
        map.put("token", StringUtils.isNotBlank((String)this.token) ? "************" : "**unset**");
        map.put("commitMessage", this.commitMessage);
        return map;
    }
}

