/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.module.jackson;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.members.HierarchicType;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.github.victools.jsonschema.generator.CustomDefinitionProviderV2;
import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.MemberScope;
import com.github.victools.jsonschema.generator.MethodScope;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigPart;
import com.github.victools.jsonschema.generator.SchemaGeneratorGeneralConfigPart;
import com.github.victools.jsonschema.generator.SubtypeResolver;
import com.github.victools.jsonschema.generator.TypeScope;
import com.github.victools.jsonschema.module.jackson.CustomEnumDefinitionProvider;
import com.github.victools.jsonschema.module.jackson.JacksonOption;
import com.github.victools.jsonschema.module.jackson.JsonPropertySorter;
import com.github.victools.jsonschema.module.jackson.JsonSubTypesResolver;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class JacksonModule
implements Module {
    private final Set<JacksonOption> options;
    private ObjectMapper objectMapper;
    private final Map<Class<?>, BeanDescription> beanDescriptions = new HashMap();
    private final Map<Class<?>, PropertyNamingStrategy> namingStrategies = new HashMap();

    public JacksonModule() {
        this.options = Collections.emptySet();
    }

    public JacksonModule(JacksonOption ... options) {
        this.options = options == null ? Collections.emptySet() : new HashSet<JacksonOption>(Arrays.asList(options));
    }

    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        boolean includeTypeInfoTransform;
        this.objectMapper = builder.getObjectMapper();
        SchemaGeneratorConfigPart fieldConfigPart = builder.forFields();
        SchemaGeneratorConfigPart methodConfigPart = builder.forMethods();
        this.applyToConfigBuilderPart(fieldConfigPart);
        this.applyToConfigBuilderPart(methodConfigPart);
        fieldConfigPart.withIgnoreCheck(this::shouldIgnoreField);
        methodConfigPart.withIgnoreCheck(this::shouldIgnoreMethod);
        if (!this.options.contains((Object)JacksonOption.IGNORE_PROPERTY_NAMING_STRATEGY)) {
            fieldConfigPart.withPropertyNameOverrideResolver(this::getPropertyNameOverrideBasedOnJsonNamingAnnotation);
        }
        SchemaGeneratorGeneralConfigPart generalConfigPart = builder.forTypesInGeneral();
        generalConfigPart.withDescriptionResolver(this::resolveDescriptionForType);
        boolean considerEnumJsonValue = this.options.contains((Object)JacksonOption.FLATTENED_ENUMS_FROM_JSONVALUE);
        boolean considerEnumJsonProperty = this.options.contains((Object)JacksonOption.FLATTENED_ENUMS_FROM_JSONPROPERTY);
        if (considerEnumJsonValue || considerEnumJsonProperty) {
            generalConfigPart.withCustomDefinitionProvider((CustomDefinitionProviderV2)new CustomEnumDefinitionProvider(considerEnumJsonValue, considerEnumJsonProperty));
        }
        if (this.options.contains((Object)JacksonOption.RESPECT_JSONPROPERTY_ORDER)) {
            generalConfigPart.withPropertySorter((Comparator)new JsonPropertySorter(true));
        }
        boolean lookUpSubtypes = !this.options.contains((Object)JacksonOption.SKIP_SUBTYPE_LOOKUP);
        boolean bl = includeTypeInfoTransform = !this.options.contains((Object)JacksonOption.IGNORE_TYPE_INFO_TRANSFORM);
        if (lookUpSubtypes || includeTypeInfoTransform) {
            JsonSubTypesResolver subtypeResolver = new JsonSubTypesResolver();
            if (lookUpSubtypes) {
                generalConfigPart.withSubtypeResolver((SubtypeResolver)subtypeResolver);
                fieldConfigPart.withTargetTypeOverridesResolver(subtypeResolver::findTargetTypeOverrides);
                methodConfigPart.withTargetTypeOverridesResolver(subtypeResolver::findTargetTypeOverrides);
            }
            if (includeTypeInfoTransform) {
                generalConfigPart.withCustomDefinitionProvider((CustomDefinitionProviderV2)subtypeResolver);
                fieldConfigPart.withCustomDefinitionProvider(subtypeResolver::provideCustomPropertySchemaDefinition);
                methodConfigPart.withCustomDefinitionProvider(subtypeResolver::provideCustomPropertySchemaDefinition);
            }
        }
    }

    private void applyToConfigBuilderPart(SchemaGeneratorConfigPart<?> configPart) {
        configPart.withDescriptionResolver(this::resolveDescription);
        configPart.withPropertyNameOverrideResolver(this::getPropertyNameOverrideBasedOnJsonPropertyAnnotation);
        configPart.withReadOnlyCheck(this::getReadOnlyCheck);
        configPart.withWriteOnlyCheck(this::getWriteOnlyCheck);
        if (this.options.contains((Object)JacksonOption.RESPECT_JSONPROPERTY_REQUIRED)) {
            configPart.withRequiredCheck(this::getRequiredCheckBasedOnJsonPropertyAnnotation);
        }
    }

    protected String resolveDescription(MemberScope<?, ?> member) {
        JsonPropertyDescription propertyAnnotation = (JsonPropertyDescription)member.getAnnotationConsideringFieldAndGetterIfSupported(JsonPropertyDescription.class);
        if (propertyAnnotation != null) {
            return propertyAnnotation.value();
        }
        return null;
    }

    protected String resolveDescriptionForType(TypeScope scope) {
        Class rawType = scope.getType().getErasedType();
        JsonClassDescription classAnnotation = rawType.getAnnotation(JsonClassDescription.class);
        if (classAnnotation != null) {
            return classAnnotation.value();
        }
        return null;
    }

    protected String getPropertyNameOverrideBasedOnJsonPropertyAnnotation(MemberScope<?, ?> member) {
        String nameOverride;
        JsonProperty annotation = (JsonProperty)member.getAnnotationConsideringFieldAndGetter(JsonProperty.class);
        if (annotation != null && (nameOverride = annotation.value()) != null && !nameOverride.isEmpty() && !nameOverride.equals(member.getDeclaredName())) {
            return nameOverride;
        }
        return null;
    }

    protected String getPropertyNameOverrideBasedOnJsonNamingAnnotation(FieldScope field) {
        PropertyNamingStrategy strategy = this.namingStrategies.computeIfAbsent(field.getDeclaringType().getErasedType(), this::getAnnotatedNamingStrategy);
        if (strategy == null) {
            return null;
        }
        return strategy.nameForField(null, null, field.getName());
    }

    private PropertyNamingStrategy getAnnotatedNamingStrategy(Class<?> declaringType) {
        return Optional.ofNullable(declaringType.getAnnotation(JsonNaming.class)).map(JsonNaming::value).map(strategyType -> {
            try {
                return (PropertyNamingStrategy)strategyType.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException | SecurityException ex) {
                return null;
            }
        }).orElse(null);
    }

    protected final BeanDescription getBeanDescriptionForClass(ResolvedType targetType) {
        return this.beanDescriptions.computeIfAbsent(targetType.getErasedType(), type -> this.objectMapper.getSerializationConfig().introspect(this.objectMapper.getTypeFactory().constructType((Type)type)));
    }

    protected boolean shouldIgnoreField(FieldScope field) {
        String fieldName;
        if (field.getAnnotationConsideringFieldAndGetterIfSupported(JsonBackReference.class) != null) {
            return true;
        }
        HierarchicType topMostHierarchyType = (HierarchicType)field.getDeclaringTypeMembers().allTypesAndOverrides().get(0);
        BeanDescription beanDescription = this.getBeanDescriptionForClass(topMostHierarchyType.getType());
        Set ignoredProperties = this.objectMapper.getSerializationConfig().getAnnotationIntrospector().findPropertyIgnoralByName(null, (Annotated)beanDescription.getClassInfo()).getIgnored();
        if (ignoredProperties.contains(fieldName = field.getName())) {
            return true;
        }
        return beanDescription.findProperties().stream().noneMatch(propertyDefinition -> fieldName.equals(propertyDefinition.getInternalName()));
    }

    protected boolean shouldIgnoreMethod(MethodScope method) {
        FieldScope getterField = method.findGetterField();
        if (getterField != null && this.shouldIgnoreField(getterField)) {
            return true;
        }
        if (getterField == null && method.getAnnotationConsideringFieldAndGetterIfSupported(JsonBackReference.class) != null) {
            return true;
        }
        return this.options.contains((Object)JacksonOption.INCLUDE_ONLY_JSONPROPERTY_ANNOTATED_METHODS) && method.getAnnotationConsideringFieldAndGetter(JsonProperty.class) == null;
    }

    protected boolean getRequiredCheckBasedOnJsonPropertyAnnotation(MemberScope<?, ?> member) {
        JsonProperty jsonProperty = (JsonProperty)member.getAnnotationConsideringFieldAndGetterIfSupported(JsonProperty.class);
        return jsonProperty != null && jsonProperty.required();
    }

    protected boolean getReadOnlyCheck(MemberScope<?, ?> member) {
        JsonProperty jsonProperty = (JsonProperty)member.getAnnotationConsideringFieldAndGetter(JsonProperty.class);
        return jsonProperty != null && jsonProperty.access() == JsonProperty.Access.READ_ONLY;
    }

    protected boolean getWriteOnlyCheck(MemberScope<?, ?> member) {
        JsonProperty jsonProperty = (JsonProperty)member.getAnnotationConsideringFieldAndGetter(JsonProperty.class);
        return jsonProperty != null && jsonProperty.access() == JsonProperty.Access.WRITE_ONLY;
    }
}

