/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.project;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.github.mustachejava.TemplateFunction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.JReleaserOutput;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.VersionPattern;
import org.jreleaser.model.api.common.Java;
import org.jreleaser.model.api.project.Project;
import org.jreleaser.model.internal.JReleaserModel;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.ExtraProperties;
import org.jreleaser.model.internal.common.Icon;
import org.jreleaser.model.internal.common.Screenshot;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.Env;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.version.CalVer;
import org.jreleaser.version.ChronVer;
import org.jreleaser.version.CustomVersion;
import org.jreleaser.version.JavaModuleVersion;
import org.jreleaser.version.JavaRuntimeVersion;
import org.jreleaser.version.SemanticVersion;
import org.jreleaser.version.Version;

public final class Project
extends AbstractModelObject<Project>
implements Domain,
ExtraProperties,
Active.Releaseable {
    private static final long serialVersionUID = -4652723515081514165L;
    private final List<String> authors = new ArrayList<String>();
    private final List<String> tags = new ArrayList<String>();
    private final List<String> maintainers = new ArrayList<String>();
    private final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    private final Links links = new Links();
    private final org.jreleaser.model.internal.common.Java java = new org.jreleaser.model.internal.common.Java();
    private final Snapshot snapshot = new Snapshot();
    private final List<Screenshot> screenshots = new ArrayList<Screenshot>();
    private final List<Icon> icons = new ArrayList<Icon>();
    private String name;
    private String version;
    private VersionPattern versionPattern = new VersionPattern();
    private String description;
    private String longDescription;
    private String license;
    private String inceptionYear;
    private String copyright;
    private String vendor;
    private Stereotype stereotype = Stereotype.NONE;
    @JsonIgnore
    private final org.jreleaser.model.api.project.Project immutable = new org.jreleaser.model.api.project.Project(){
        private static final long serialVersionUID = 4384858957895818432L;
        private List<? extends org.jreleaser.model.api.common.Screenshot> screenshots;
        private List<? extends org.jreleaser.model.api.common.Icon> icons;

        public boolean isSnapshot() {
            return Project.this.isSnapshot();
        }

        public boolean isRelease() {
            return Project.this.isRelease();
        }

        public String getName() {
            return Project.this.name;
        }

        public String getVersion() {
            return Project.this.version;
        }

        public String getVersionPattern() {
            return Project.this.versionPattern.toString();
        }

        public Project.Snapshot getSnapshot() {
            return Project.this.snapshot.asImmutable();
        }

        public String getDescription() {
            return Project.this.description;
        }

        public String getLongDescription() {
            return Project.this.longDescription;
        }

        public String getWebsite() {
            return Project.this.getWebsite();
        }

        public String getLicense() {
            return Project.this.license;
        }

        public String getLicenseUrl() {
            return Project.this.getLicenseUrl();
        }

        public String getInceptionYear() {
            return Project.this.inceptionYear;
        }

        public String getCopyright() {
            return Project.this.copyright;
        }

        public String getVendor() {
            return Project.this.vendor;
        }

        public String getDocsUrl() {
            return Project.this.getDocsUrl();
        }

        public Stereotype getStereotype() {
            return Project.this.stereotype;
        }

        public List<? extends org.jreleaser.model.api.common.Screenshot> getScreenshots() {
            if (null == this.screenshots) {
                this.screenshots = Project.this.screenshots.stream().map(Screenshot::asImmutable).collect(Collectors.toList());
            }
            return this.screenshots;
        }

        public List<? extends org.jreleaser.model.api.common.Icon> getIcons() {
            if (null == this.icons) {
                this.icons = Project.this.icons.stream().map(Icon::asImmutable).collect(Collectors.toList());
            }
            return this.icons;
        }

        public Java getJava() {
            return Project.this.java.asImmutable();
        }

        public List<String> getAuthors() {
            return Collections.unmodifiableList(Project.this.authors);
        }

        public List<String> getTags() {
            return Collections.unmodifiableList(Project.this.tags);
        }

        public List<String> getMaintainers() {
            return Collections.unmodifiableList(Project.this.maintainers);
        }

        public Project.Links getLinks() {
            return Project.this.links.asImmutable();
        }

        public Version<?> version() {
            return Project.this.version();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Project.this.asMap(full));
        }

        public String getPrefix() {
            return Project.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(Project.this.extraProperties);
        }
    };

    public org.jreleaser.model.api.project.Project asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Project source) {
        this.name = this.merge(this.name, source.name);
        this.version = this.merge(this.version, source.version);
        this.versionPattern = this.merge(this.versionPattern, source.versionPattern);
        this.description = this.merge(this.description, source.description);
        this.longDescription = this.merge(this.longDescription, source.longDescription);
        this.license = this.merge(this.license, source.license);
        this.inceptionYear = this.merge(this.inceptionYear, source.inceptionYear);
        this.copyright = this.merge(this.copyright, source.copyright);
        this.vendor = this.merge(this.vendor, source.vendor);
        this.stereotype = this.merge(this.stereotype, source.stereotype);
        this.setJava(source.java);
        this.setSnapshot(source.snapshot);
        this.setAuthors(this.merge(this.authors, source.authors));
        this.setTags(this.merge(this.tags, source.tags));
        this.setMaintainers(this.merge(this.maintainers, source.maintainers));
        this.setExtraProperties(this.merge(this.extraProperties, source.extraProperties));
        this.setLinks(source.links);
        this.setScreenshots(this.merge(this.screenshots, source.screenshots));
        this.setIcons(this.merge(this.icons, source.icons));
    }

    @Override
    public String prefix() {
        return "project";
    }

    public String getEffectiveVersion() {
        if (this.isSnapshot()) {
            return this.getSnapshot().getEffectiveLabel();
        }
        return this.getResolvedVersion();
    }

    public boolean isSnapshot() {
        return this.snapshot.isSnapshot(this.getResolvedVersion());
    }

    public boolean isRelease() {
        return !this.isSnapshot();
    }

    public String getResolvedName() {
        return Env.env((String)"PROJECT_NAME", (String)this.name);
    }

    public String getResolvedVersion() {
        String resolvedVersion = Env.env((String)"PROJECT_VERSION", (String)this.version);
        return StringUtils.isNotBlank((String)resolvedVersion) ? resolvedVersion : "";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersionPattern() {
        return null != this.versionPattern ? this.versionPattern.toString() : "";
    }

    public void setVersionPattern(VersionPattern versionPattern) {
        this.versionPattern.merge(versionPattern);
    }

    public void setVersionPattern(String str) {
        this.setVersionPattern(VersionPattern.of(str));
    }

    public VersionPattern versionPattern() {
        return this.versionPattern;
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(Snapshot snapshot) {
        this.snapshot.merge(snapshot);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    @Deprecated
    @JsonPropertyDescription(value="project.website is deprecated since 1.2.0 and will be removed in 2.0.0. Use project.links.homepage instead")
    public String getWebsite() {
        return this.links.getHomepage();
    }

    @Deprecated
    public void setWebsite(String website) {
        JReleaserOutput.nag((String)"project.website is deprecated since 1.2.0 and will be removed in 2.0.0. Use project.links.homepage instead");
        this.links.setHomepage(website);
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    @Deprecated
    @JsonPropertyDescription(value="project.licenseUrl is deprecated since 1.2.0 and will be removed in 2.0.0. Use project.links.license instead")
    public String getLicenseUrl() {
        return this.links.getLicense();
    }

    @Deprecated
    public void setLicenseUrl(String licenseUrl) {
        JReleaserOutput.nag((String)"project.licenseUrl is deprecated since 1.2.0 and will be removed in 2.0.0. Use project.links.license instead");
        this.links.setLicense(licenseUrl);
    }

    public String getInceptionYear() {
        return this.inceptionYear;
    }

    public void setInceptionYear(String inceptionYear) {
        this.inceptionYear = inceptionYear;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    @Deprecated
    @JsonPropertyDescription(value="project.docsUrl is deprecated since 1.2.0 and will be removed in 2.0.0. Use project.links.documentation instead")
    public String getDocsUrl() {
        return this.links.getDocumentation();
    }

    @Deprecated
    public void setDocsUrl(String docsUrl) {
        JReleaserOutput.nag((String)"project.docsUrl is deprecated since 1.2.0 and will be removed in 2.0.0. Use project.links.documentation instead");
        this.links.setDocumentation(docsUrl);
    }

    public Stereotype getStereotype() {
        return this.stereotype;
    }

    public void setStereotype(Stereotype stereotype) {
        this.stereotype = stereotype;
    }

    public void setStereotype(String str) {
        this.setStereotype(Stereotype.of((String)str));
    }

    public List<Screenshot> getScreenshots() {
        return this.screenshots;
    }

    public void setScreenshots(List<Screenshot> screenshots) {
        this.screenshots.clear();
        this.screenshots.addAll(screenshots);
    }

    public void addScreenshot(Screenshot screenshot) {
        if (null != screenshot) {
            this.screenshots.add(screenshot);
        }
    }

    public List<Icon> getIcons() {
        return this.icons;
    }

    public void setIcons(List<Icon> icons) {
        this.icons.clear();
        this.icons.addAll(icons);
    }

    public void addIcon(Icon icon) {
        if (null != icon) {
            this.icons.add(icon);
        }
    }

    public org.jreleaser.model.internal.common.Java getJava() {
        return this.java;
    }

    public void setJava(org.jreleaser.model.internal.common.Java java) {
        this.java.merge(java);
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.putAll(extraProperties);
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public void setAuthors(List<String> authors) {
        this.authors.clear();
        this.authors.addAll(authors);
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags.clear();
        this.tags.addAll(tags);
    }

    public List<String> getMaintainers() {
        return this.maintainers;
    }

    public void setMaintainers(List<String> maintainers) {
        this.maintainers.clear();
        this.maintainers.addAll(maintainers);
    }

    public Links getLinks() {
        return this.links;
    }

    public void setLinks(Links links) {
        this.links.merge(links);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("name", this.name);
        map.put("version", this.version);
        map.put("versionPattern", this.versionPattern);
        map.put("snapshot", this.snapshot.asMap(full));
        map.put("description", this.description);
        map.put("longDescription", this.longDescription);
        map.put("license", this.license);
        map.put("inceptionYear", this.inceptionYear);
        map.put("copyright", this.copyright);
        map.put("vendor", this.vendor);
        map.put("authors", this.authors);
        map.put("tags", this.tags);
        map.put("maintainers", this.maintainers);
        map.put("stereotype", this.stereotype);
        map.put("links", this.links.asMap(full));
        LinkedHashMap<String, Map<String, Object>> sm = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (Screenshot screenshot : this.screenshots) {
            sm.put("screenshot " + i++, screenshot.asMap(full));
        }
        map.put("screenshots", sm);
        sm = new LinkedHashMap();
        i = 0;
        for (Icon icon : this.icons) {
            sm.put("icon " + i++, icon.asMap(full));
        }
        map.put("icons", sm);
        map.put("extraProperties", this.getExtraProperties());
        if (this.java.isEnabled()) {
            map.put("java", this.java.asMap(full));
        }
        return map;
    }

    public void parseVersion() {
        String v = this.getResolvedVersion();
        if (StringUtils.isBlank((String)v)) {
            return;
        }
        switch (this.versionPattern().getType()) {
            case SEMVER: {
                SemanticVersion parsedVersion;
                try {
                    parsedVersion = SemanticVersion.of((String)v);
                    StringBuilder vn = new StringBuilder().append(parsedVersion.getMajor());
                    this.addExtraProperty("versionMajor", parsedVersion.getMajor());
                    if (parsedVersion.hasMinor()) {
                        vn.append(".").append(parsedVersion.getMinor());
                        this.addExtraProperty("versionMinor", parsedVersion.getMinor());
                    }
                    if (parsedVersion.hasPatch()) {
                        vn.append(".").append(parsedVersion.getPatch());
                        this.addExtraProperty("versionPatch", parsedVersion.getPatch());
                    }
                    this.addExtraProperty("versionNumber", vn.toString());
                    if (parsedVersion.hasTag()) {
                        this.addExtraProperty("versionTag", parsedVersion.getTag());
                    }
                    if (!parsedVersion.hasBuild()) break;
                    this.addExtraProperty("versionBuild", parsedVersion.getBuild());
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new JReleaserException(RB.$((String)"ERROR_version_invalid", (Object[])new Object[]{v, "semver"}), (Throwable)e);
                }
            }
            case JAVA_RUNTIME: {
                SemanticVersion parsedVersion;
                try {
                    parsedVersion = JavaRuntimeVersion.of((String)v);
                    this.addExtraProperty("versionNumber", parsedVersion.getVersion());
                    if (parsedVersion.hasPrerelease()) {
                        this.addExtraProperty("versionPrerelease", parsedVersion.getPrerelease());
                    }
                    if (parsedVersion.hasBuild()) {
                        this.addExtraProperty("versionBuild", parsedVersion.getBuild());
                    }
                    if (!parsedVersion.hasOptional()) break;
                    this.addExtraProperty("versionOptional", parsedVersion.getOptional());
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new JReleaserException(RB.$((String)"ERROR_version_invalid", (Object[])new Object[]{v, "Java runtime"}), (Throwable)e);
                }
            }
            case JAVA_MODULE: {
                SemanticVersion parsedVersion;
                try {
                    parsedVersion = JavaModuleVersion.of((String)v);
                    this.addExtraProperty("versionNumber", parsedVersion.getVersion());
                    if (parsedVersion.hasPrerelease()) {
                        this.addExtraProperty("versionPrerelease", parsedVersion.getPrerelease());
                    }
                    if (!parsedVersion.hasBuild()) break;
                    this.addExtraProperty("versionBuild", parsedVersion.getBuild());
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new JReleaserException(RB.$((String)"ERROR_version_invalid", (Object[])new Object[]{v, "Java module"}), (Throwable)e);
                }
            }
            case CALVER: {
                SemanticVersion parsedVersion;
                try {
                    parsedVersion = CalVer.of((String)this.versionPattern().getFormat(), (String)v);
                    this.addExtraProperty("versionNumber", v);
                    this.addExtraProperty("versionYear", parsedVersion.getYear());
                    if (parsedVersion.hasMonth()) {
                        this.addExtraProperty("versionMonth", parsedVersion.getMonth());
                    }
                    if (parsedVersion.hasDay()) {
                        this.addExtraProperty("versionDay", parsedVersion.getDay());
                    }
                    if (parsedVersion.hasWeek()) {
                        this.addExtraProperty("versionWeek", parsedVersion.getWeek());
                    }
                    if (parsedVersion.hasMinor()) {
                        this.addExtraProperty("versionMinor", parsedVersion.getMinor());
                    }
                    if (parsedVersion.hasMicro()) {
                        this.addExtraProperty("versionMicro", parsedVersion.getMicro());
                    }
                    if (!parsedVersion.hasModifier()) break;
                    this.addExtraProperty("versionModifier", parsedVersion.getModifier());
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new JReleaserException(RB.$((String)"ERROR_version_invalid", (Object[])new Object[]{v, "calver"}), (Throwable)e);
                }
            }
            case CHRONVER: {
                SemanticVersion parsedVersion;
                try {
                    parsedVersion = ChronVer.of((String)v);
                    this.addExtraProperty("versionNumber", v);
                    this.addExtraProperty("versionYear", parsedVersion.getYear());
                    this.addExtraProperty("versionMonth", parsedVersion.getMonth());
                    this.addExtraProperty("versionDay", parsedVersion.getDay());
                    if (!parsedVersion.hasChangeset()) break;
                    this.addExtraProperty("versionModifier", parsedVersion.getChangeset().toString());
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new JReleaserException(RB.$((String)"ERROR_version_invalid", (Object[])new Object[]{v, "chronver"}), (Throwable)e);
                }
            }
            default: {
                this.addExtraProperty("versionNumber", v);
            }
        }
        String vn = (String)this.getExtraProperties().get("versionNumber");
        String ev = this.getEffectiveVersion();
        this.addExtraProperty("versionWithUnderscores", this.underscore(v));
        this.addExtraProperty("versionWithDashes", this.dash(v));
        this.addExtraProperty("versionNumberWithUnderscores", this.underscore(vn));
        this.addExtraProperty("versionNumberWithDashes", this.dash(vn));
        if (StringUtils.isNotBlank((String)ev)) {
            this.addExtraProperty("effectiveVersionWithUnderscores", this.underscore(ev));
            this.addExtraProperty("effectiveVersionWithDashes", this.dash(ev));
        }
    }

    private String underscore(String input) {
        return input.replace(".", "_").replace("-", "_").replace("+", "_");
    }

    private String dash(String input) {
        return input.replace(".", "-").replace("_", "-").replace("+", "-");
    }

    public Version<?> version() {
        String v = this.getResolvedVersion();
        switch (this.versionPattern().getType()) {
            case SEMVER: {
                return SemanticVersion.of((String)v);
            }
            case JAVA_RUNTIME: {
                return JavaRuntimeVersion.of((String)v);
            }
            case JAVA_MODULE: {
                return JavaModuleVersion.of((String)v);
            }
            case CALVER: {
                return CalVer.of((String)this.versionPattern().getFormat(), (String)v);
            }
            case CHRONVER: {
                return ChronVer.of((String)v);
            }
        }
        return CustomVersion.of((String)v);
    }

    public static class Links
    extends AbstractModelObject<Links>
    implements Domain {
        private static final String PROJECT_LINK = "projectLink";
        private static final long serialVersionUID = 1574571238759859477L;
        private String homepage;
        private String documentation;
        private String license;
        private String bugTracker;
        private String faq;
        private String help;
        private String donation;
        private String translate;
        private String contact;
        private String vcsBrowser;
        private String contribute;
        @JsonIgnore
        private final Project.Links immutable = new Project.Links(){
            private static final long serialVersionUID = 3891594676066031996L;

            public String getHomepage() {
                return homepage;
            }

            public String getDocumentation() {
                return documentation;
            }

            public String getLicense() {
                return license;
            }

            public String getBugTracker() {
                return bugTracker;
            }

            public String getFaq() {
                return faq;
            }

            public String getHelp() {
                return help;
            }

            public String getDonation() {
                return donation;
            }

            public String getTranslate() {
                return translate;
            }

            public String getContact() {
                return contact;
            }

            public String getVcsBrowser() {
                return vcsBrowser;
            }

            public String getContribute() {
                return contribute;
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public Project.Links asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Links source) {
            this.homepage = this.merge(this.homepage, source.homepage);
            this.documentation = this.merge(this.documentation, source.documentation);
            this.license = this.merge(this.license, source.license);
            this.bugTracker = this.merge(this.bugTracker, source.bugTracker);
            this.faq = this.merge(this.faq, source.faq);
            this.help = this.merge(this.help, source.help);
            this.donation = this.merge(this.donation, source.donation);
            this.translate = this.merge(this.translate, source.translate);
            this.contact = this.merge(this.contact, source.contact);
            this.vcsBrowser = this.merge(this.vcsBrowser, source.vcsBrowser);
            this.contribute = this.merge(this.contribute, source.contribute);
        }

        public String getHomepage() {
            return this.homepage;
        }

        public void setHomepage(String homepage) {
            this.homepage = homepage;
        }

        public String getDocumentation() {
            return this.documentation;
        }

        public void setDocumentation(String documentation) {
            this.documentation = documentation;
        }

        public String getLicense() {
            return this.license;
        }

        public void setLicense(String license) {
            this.license = license;
        }

        public String getBugTracker() {
            return this.bugTracker;
        }

        public void setBugTracker(String bugTracker) {
            this.bugTracker = bugTracker;
        }

        public String getFaq() {
            return this.faq;
        }

        public void setFaq(String faq) {
            this.faq = faq;
        }

        public String getHelp() {
            return this.help;
        }

        public void setHelp(String help) {
            this.help = help;
        }

        public String getDonation() {
            return this.donation;
        }

        public void setDonation(String donation) {
            this.donation = donation;
        }

        public String getTranslate() {
            return this.translate;
        }

        public void setTranslate(String translate) {
            this.translate = translate;
        }

        public String getContact() {
            return this.contact;
        }

        public void setContact(String contact) {
            this.contact = contact;
        }

        public String getVcsBrowser() {
            return this.vcsBrowser;
        }

        public void setVcsBrowser(String vcsBrowser) {
            this.vcsBrowser = vcsBrowser;
        }

        public String getContribute() {
            return this.contribute;
        }

        public void setContribute(String contribute) {
            this.contribute = contribute;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            if (StringUtils.isNotBlank((String)this.homepage)) {
                map.put("homepage", this.homepage);
            }
            if (StringUtils.isNotBlank((String)this.documentation)) {
                map.put("documentation", this.documentation);
            }
            if (StringUtils.isNotBlank((String)this.license)) {
                map.put("license", this.license);
            }
            if (StringUtils.isNotBlank((String)this.bugTracker)) {
                map.put("bugTracker", this.bugTracker);
            }
            if (StringUtils.isNotBlank((String)this.vcsBrowser)) {
                map.put("vcsBrowser", this.vcsBrowser);
            }
            if (StringUtils.isNotBlank((String)this.faq)) {
                map.put("faq", this.faq);
            }
            if (StringUtils.isNotBlank((String)this.help)) {
                map.put("help", this.help);
            }
            if (StringUtils.isNotBlank((String)this.donation)) {
                map.put("donation", this.donation);
            }
            if (StringUtils.isNotBlank((String)this.translate)) {
                map.put("translate", this.translate);
            }
            if (StringUtils.isNotBlank((String)this.contact)) {
                map.put("contact", this.contact);
            }
            if (StringUtils.isNotBlank((String)this.contribute)) {
                map.put("contribute", this.contribute);
            }
            return map;
        }

        public void fillProps(TemplateContext props) {
            props.set("projectLinkHomepage", (Object)this.homepage);
            props.set("projectLinkDocumentation", (Object)this.documentation);
            props.set("projectLinkLicense", (Object)this.license);
            props.set("projectLinkBugTracker", (Object)this.bugTracker);
            props.set("projectLinkVcsBrowser", (Object)this.vcsBrowser);
            props.set("projectLinkFaq", (Object)this.faq);
            props.set("projectLinkHelp", (Object)this.help);
            props.set("projectLinkDonation", (Object)this.donation);
            props.set("projectLinkTranslate", (Object)this.translate);
            props.set("projectLinkContact", (Object)this.contact);
            props.set("projectLinkContribute", (Object)this.contribute);
            props.set("projectWebsite", (Object)this.homepage);
            props.set("projectDocsUrl", (Object)this.documentation);
            props.set("projectLicenseUrl", (Object)this.license);
        }

        public Collection<LinkTemplate> asLinkTemplates(boolean flatpak) {
            ArrayList<LinkTemplate> links = new ArrayList<LinkTemplate>();
            if (StringUtils.isNotBlank((String)this.homepage)) {
                links.add(new LinkTemplate("homepage", this.homepage));
            }
            if (!flatpak && StringUtils.isNotBlank((String)this.documentation)) {
                links.add(new LinkTemplate("documentation", this.documentation));
            }
            if (!flatpak && StringUtils.isNotBlank((String)this.license)) {
                links.add(new LinkTemplate("license", this.license));
            }
            if (StringUtils.isNotBlank((String)this.bugTracker)) {
                links.add(new LinkTemplate("bugtracker", this.bugTracker));
            }
            if (StringUtils.isNotBlank((String)this.vcsBrowser)) {
                links.add(new LinkTemplate("vcs-browser", this.vcsBrowser));
            }
            if (StringUtils.isNotBlank((String)this.faq)) {
                links.add(new LinkTemplate("faq", this.faq));
            }
            if (StringUtils.isNotBlank((String)this.help)) {
                links.add(new LinkTemplate("help", this.help));
            }
            if (StringUtils.isNotBlank((String)this.donation)) {
                links.add(new LinkTemplate("donation", this.donation));
            }
            if (StringUtils.isNotBlank((String)this.translate)) {
                links.add(new LinkTemplate("translate", this.translate));
            }
            if (StringUtils.isNotBlank((String)this.contact)) {
                links.add(new LinkTemplate("contact", this.contact));
            }
            if (StringUtils.isNotBlank((String)this.contribute)) {
                links.add(new LinkTemplate("contribute", this.contribute));
            }
            return links;
        }

        public static final class LinkTemplate {
            private final String type;
            private final String url;

            public LinkTemplate(String type, String url) {
                this.type = type;
                this.url = url;
            }

            public String getType() {
                return this.type;
            }

            public TemplateFunction getUrl() {
                return s -> this.url;
            }
        }
    }

    public static class Snapshot
    extends AbstractModelObject<Snapshot>
    implements Domain {
        private static final long serialVersionUID = -4157019875957411109L;
        private Boolean enabled;
        private String pattern;
        private String label;
        private Boolean fullChangelog;
        @JsonIgnore
        private String cachedLabel;
        @JsonIgnore
        private final Project.Snapshot immutable = new Project.Snapshot(){
            private static final long serialVersionUID = 2581314557970795502L;

            public String getPattern() {
                return pattern;
            }

            public String getLabel() {
                return label;
            }

            public boolean isFullChangelog() {
                return this.isFullChangelog();
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public Project.Snapshot asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Snapshot source) {
            this.enabled = this.merge(this.enabled, source.enabled);
            this.pattern = this.merge(this.pattern, source.pattern);
            this.label = this.merge(this.label, source.label);
            this.fullChangelog = this.merge(this.fullChangelog, source.fullChangelog);
        }

        public boolean isSnapshot(String version) {
            if (null == this.enabled) {
                this.enabled = version.matches(this.getResolvedPattern());
            }
            return this.enabled;
        }

        public String getConfiguredPattern() {
            return Env.env((String)"PROJECT_SNAPSHOT_PATTERN", (String)this.pattern);
        }

        public String getResolvedPattern() {
            this.pattern = this.getConfiguredPattern();
            if (StringUtils.isBlank((String)this.pattern)) {
                this.pattern = ".*-SNAPSHOT";
            }
            return this.pattern;
        }

        public String getConfiguredLabel() {
            return Env.env((String)"PROJECT_SNAPSHOT_LABEL", (String)this.label);
        }

        public String getResolvedLabel(JReleaserModel model) {
            if (StringUtils.isBlank((String)this.cachedLabel)) {
                this.cachedLabel = this.getConfiguredLabel();
            }
            if (StringUtils.isBlank((String)this.cachedLabel)) {
                this.cachedLabel = Templates.resolveTemplate((String)this.label, (TemplateContext)this.props(model));
            } else if (this.cachedLabel.contains("{{")) {
                this.cachedLabel = Templates.resolveTemplate((String)this.cachedLabel, (TemplateContext)this.props(model));
            }
            return this.cachedLabel;
        }

        public String getEffectiveLabel() {
            return this.cachedLabel;
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public Boolean getFullChangelog() {
            return this.fullChangelog;
        }

        public boolean isFullChangelog() {
            return null != this.fullChangelog && this.fullChangelog != false;
        }

        public void setFullChangelog(Boolean fullChangelog) {
            this.fullChangelog = fullChangelog;
        }

        public boolean isFullChangelogSet() {
            return null != this.fullChangelog;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("enabled", this.enabled);
            map.put("pattern", this.getConfiguredPattern());
            map.put("label", this.getConfiguredLabel());
            map.put("fullChangelog", this.isFullChangelog());
            return map;
        }

        public TemplateContext props(JReleaserModel model) {
            TemplateContext props = new TemplateContext();
            Project project = model.getProject();
            props.setAll(model.getEnvironment().getProperties());
            props.setAll(model.getEnvironment().getSourcedProperties());
            props.set("projectName", (Object)project.getName());
            props.set("projectNameCapitalized", (Object)StringUtils.getCapitalizedName((String)project.getName()));
            props.set("projectStereotype", (Object)project.getStereotype());
            props.set("projectVersion", (Object)project.getVersion());
            props.set("projectSnapshot", (Object)String.valueOf(project.isSnapshot()));
            if (StringUtils.isNotBlank((String)project.getDescription())) {
                props.set("projectDescription", (Object)MustacheUtils.passThrough((String)project.getDescription()));
            }
            if (StringUtils.isNotBlank((String)project.getLongDescription())) {
                props.set("projectLongDescription", (Object)MustacheUtils.passThrough((String)project.getLongDescription()));
            }
            props.set("projectLicense", (Object)project.getLicense());
            props.set("projectInceptionYear", (Object)project.getInceptionYear());
            props.set("projectCopyright", (Object)project.getCopyright());
            props.set("projectVendor", (Object)project.getVendor());
            project.getLinks().fillProps(props);
            if (project.getJava().isEnabled()) {
                props.setAll(project.getJava().resolvedExtraProperties());
                props.set("projectJavaGroupId", (Object)project.getJava().getGroupId());
                props.set("projectJavaArtifactId", (Object)project.getJava().getArtifactId());
                String javaVersion = project.getJava().getVersion();
                props.set("projectJavaVersion", (Object)javaVersion);
                props.set("projectJavaMainClass", (Object)project.getJava().getMainClass());
                if (StringUtils.isNotBlank((String)javaVersion)) {
                    SemanticVersion jv = SemanticVersion.of((String)javaVersion);
                    props.set("projectJavaVersionMajor", (Object)jv.getMajor());
                    if (jv.hasMinor()) {
                        props.set("projectJavaVersionMinor", (Object)jv.getMinor());
                    }
                    if (jv.hasPatch()) {
                        props.set("projectJavaVersionPatch", (Object)jv.getPatch());
                    }
                    if (jv.hasTag()) {
                        props.set("projectJavaVersionTag", (Object)jv.getTag());
                    }
                    if (jv.hasBuild()) {
                        props.set("projectJavaVersionBuild", (Object)jv.getBuild());
                    }
                }
            }
            project.parseVersion();
            props.setAll(project.resolvedExtraProperties());
            String osName = PlatformUtils.getDetectedOs();
            String osArch = PlatformUtils.getDetectedArch();
            props.set("osName", (Object)osName);
            props.set("osArch", (Object)osArch);
            props.set("osVersion", (Object)PlatformUtils.getDetectedVersion());
            props.set("osPlatform", (Object)PlatformUtils.getCurrentFull());
            props.set("osPlatformReplaced", (Object)model.getPlatform().applyReplacements(PlatformUtils.getCurrentFull()));
            MustacheUtils.applyTemplates((TemplateContext)props, project.resolvedExtraProperties());
            props.set("__ZonedDateTime_now__", (Object)model.getNow());
            return props;
        }
    }

    public static class VersionPattern
    extends AbstractModelObject<VersionPattern>
    implements Serializable {
        private static final long serialVersionUID = -8292733451111227968L;
        private VersionPattern.Type type;
        private String format;
        @JsonIgnore
        private final Project.VersionPattern immutable = new Project.VersionPattern(){
            private static final long serialVersionUID = 1073045324421554619L;

            public VersionPattern.Type getType() {
                return type;
            }

            public String getFormat() {
                return format;
            }

            public String toString() {
                return this.toString();
            }
        };

        public VersionPattern() {
            this.type = VersionPattern.Type.SEMVER;
        }

        public Project.VersionPattern asImmutable() {
            return this.immutable;
        }

        public VersionPattern.Type getType() {
            return this.type;
        }

        public void setType(VersionPattern.Type type) {
            this.type = type;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public String toString() {
            String s = this.type.toString();
            switch (this.type) {
                case CALVER: 
                case CUSTOM: {
                    if (!StringUtils.isNotBlank((String)this.format)) break;
                    s = s + ":" + this.format;
                    break;
                }
            }
            return s;
        }

        @Override
        public void merge(VersionPattern source) {
            if (null != source) {
                this.type = this.merge(this.type, source.type);
                this.format = this.merge(this.format, source.format);
            }
        }

        public static VersionPattern of(String str) {
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            String[] parts = str.trim().split(":");
            VersionPattern vp = new VersionPattern();
            switch (parts.length) {
                case 1: {
                    vp.setType(VersionPattern.Type.of((String)parts[0]));
                    break;
                }
                case 2: {
                    vp.setType(VersionPattern.Type.of((String)parts[0]));
                    vp.setFormat(parts[1].trim());
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return vp;
        }
    }
}

