/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.s3;

import java.nio.file.Path;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.upload.S3Uploader;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.spi.upload.UploadException;
import org.jreleaser.sdk.commons.AbstractArtifactUploader;
import org.jreleaser.util.StringUtils;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.endpoints.S3EndpointParams;
import software.amazon.awssdk.services.s3.endpoints.S3EndpointProvider;
import software.amazon.awssdk.services.s3.model.AccessControlPolicy;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetBucketAclRequest;
import software.amazon.awssdk.services.s3.model.Grant;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.Owner;
import software.amazon.awssdk.services.s3.model.Permission;
import software.amazon.awssdk.services.s3.model.PutObjectAclRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.Type;

public class S3ArtifactUploader
extends AbstractArtifactUploader<S3Uploader, org.jreleaser.model.internal.upload.S3Uploader> {
    private org.jreleaser.model.internal.upload.S3Uploader uploader;

    public S3ArtifactUploader(JReleaserContext context) {
        super(context);
    }

    public org.jreleaser.model.internal.upload.S3Uploader getUploader() {
        return this.uploader;
    }

    public void setUploader(org.jreleaser.model.internal.upload.S3Uploader uploader) {
        this.uploader = uploader;
    }

    public String getType() {
        return "s3";
    }

    public void upload(String name) throws UploadException {
        Set artifacts = this.collectArtifacts();
        if (artifacts.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"artifacts.no.match", (Object[])new Object[0]));
        }
        String bucketName = this.uploader.getBucket();
        S3Client s3 = this.createS3Client();
        String ownerId = null;
        if (!this.context.isDryrun()) {
            try {
                Owner owner;
                this.context.getLogger().debug(RB.$((String)"s3.bucket.check", (Object[])new Object[0]), new Object[]{bucketName});
                if (!this.doesBucketExist(s3, bucketName)) {
                    this.createBucket(s3, bucketName);
                }
                if ((owner = s3.getBucketAcl((GetBucketAclRequest)GetBucketAclRequest.builder().bucket(bucketName).build()).owner()) != null) {
                    ownerId = owner.id();
                }
            }
            catch (SdkException e) {
                this.context.getLogger().trace((Throwable)e);
                throw new UploadException(RB.$((String)"ERROR_unexpected_upload2", (Object[])new Object[0]), (Throwable)e);
            }
        }
        for (Artifact artifact : artifacts) {
            Path path = artifact.getEffectivePath(this.context);
            try {
                this.context.getLogger().info(" - {}", new Object[]{path.getFileName()});
                String bucketPath = this.uploader.getResolvedPath(this.context, artifact);
                this.context.getLogger().debug("   {}", new Object[]{bucketPath});
                if (this.context.isDryrun()) continue;
                this.context.getLogger().debug(RB.$((String)"s3.object.check", (Object[])new Object[0]), new Object[]{bucketName, bucketPath});
                if (this.doesObjectExist(s3, bucketName, bucketPath)) {
                    this.deleteObject(s3, bucketName, bucketPath);
                }
                this.putObject(s3, ownerId, bucketName, bucketPath, path);
            }
            catch (SdkException e) {
                this.context.getLogger().trace((Throwable)e);
                throw new UploadException(RB.$((String)"ERROR_unexpected_upload", (Object[])new Object[]{this.context.relativizeToBasedir(path)}), (Throwable)e);
            }
        }
    }

    private S3Client createS3Client() {
        S3ClientBuilder builder = (S3ClientBuilder)S3Client.builder().httpClientBuilder((SdkHttpClient.Builder)ApacheHttpClient.builder());
        if (StringUtils.isNotBlank((String)this.uploader.getAccessKeyId()) && StringUtils.isNotBlank((String)this.uploader.getSecretKey()) && StringUtils.isNotBlank((String)this.uploader.getSessionToken())) {
            builder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsSessionCredentials.create((String)this.uploader.getAccessKeyId(), (String)this.uploader.getSecretKey(), (String)this.uploader.getSessionToken())));
        } else if (StringUtils.isNotBlank((String)this.uploader.getAccessKeyId()) && StringUtils.isNotBlank((String)this.uploader.getSecretKey())) {
            builder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)this.uploader.getAccessKeyId(), (String)this.uploader.getSecretKey())));
        }
        if (StringUtils.isBlank((String)this.uploader.getEndpoint())) {
            builder.region(Region.of((String)this.uploader.getRegion()));
        } else {
            builder.endpointProvider((S3EndpointProvider)new MyS3EndpointProvider(this.uploader.getEndpoint(), Region.of((String)this.uploader.getRegion())));
        }
        builder.overrideConfiguration(confBuilder -> {
            this.uploader.getHeaders().forEach((arg_0, arg_1) -> ((ClientOverrideConfiguration.Builder)confBuilder).putHeader(arg_0, arg_1));
            confBuilder.apiCallAttemptTimeout(Duration.of(this.uploader.getConnectTimeout().intValue(), ChronoUnit.SECONDS));
        });
        return (S3Client)builder.build();
    }

    private boolean doesBucketExist(S3Client s3, String bucketName) {
        try {
            return s3.headBucket((HeadBucketRequest)HeadBucketRequest.builder().bucket(bucketName).build()).sdkHttpResponse().isSuccessful();
        }
        catch (NoSuchBucketException e) {
            return false;
        }
    }

    private void createBucket(S3Client s3, String bucketName) throws SdkException {
        this.context.getLogger().debug(RB.$((String)"s3.bucket.create", (Object[])new Object[0]), new Object[]{bucketName});
        s3.createBucket((CreateBucketRequest)CreateBucketRequest.builder().bucket(bucketName).build());
        this.context.getLogger().debug(RB.$((String)"s3.bucket.create.wait", (Object[])new Object[0]), new Object[]{bucketName});
        s3.waiter().waitUntilBucketExists((HeadBucketRequest)HeadBucketRequest.builder().bucket(bucketName).build());
    }

    private void deleteObject(S3Client s3, String bucketName, String bucketPath) throws SdkException {
        this.context.getLogger().debug(RB.$((String)"s3.object.delete", (Object[])new Object[0]), new Object[]{bucketName, bucketPath});
        s3.deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(bucketName).key(bucketPath).build());
        this.context.getLogger().debug(RB.$((String)"s3.object.delete.wait", (Object[])new Object[0]), new Object[]{bucketName, bucketPath});
        s3.waiter().waitUntilObjectNotExists((HeadObjectRequest)HeadObjectRequest.builder().bucket(bucketName).key(bucketPath).build());
    }

    private boolean doesObjectExist(S3Client s3, String bucketName, String bucketPath) {
        try {
            return s3.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(bucketName).key(bucketPath).build()).sdkHttpResponse().isSuccessful();
        }
        catch (NoSuchKeyException e) {
            return false;
        }
    }

    private void putObject(S3Client s3, String ownerId, String bucketName, String bucketPath, Path path) throws SdkException {
        this.context.getLogger().debug(RB.$((String)"s3.object.write", (Object[])new Object[0]), new Object[]{bucketName, bucketPath});
        s3.putObject((PutObjectRequest)PutObjectRequest.builder().bucket(bucketName).key(bucketPath).build(), path);
        if (ownerId != null) {
            ArrayList<Grant> grantList = new ArrayList<Grant>();
            grantList.add((Grant)Grant.builder().grantee(builder -> builder.id(ownerId).type(Type.CANONICAL_USER)).permission(Permission.FULL_CONTROL).build());
            grantList.add((Grant)Grant.builder().grantee(builder -> builder.uri("http://acs.amazonaws.com/groups/global/AllUsers").type(Type.GROUP)).permission(Permission.READ).build());
            AccessControlPolicy acl = (AccessControlPolicy)AccessControlPolicy.builder().owner(builder -> builder.id(ownerId)).grants(grantList).build();
            PutObjectAclRequest putAclReq = (PutObjectAclRequest)PutObjectAclRequest.builder().bucket(bucketName).key(bucketPath).accessControlPolicy(acl).build();
            this.context.getLogger().debug(RB.$((String)"s3.object.acl", (Object[])new Object[0]), new Object[]{bucketName, bucketPath});
            s3.putObjectAcl(putAclReq);
        }
    }

    public static class MyS3EndpointProvider
    implements S3EndpointProvider {
        private final S3EndpointProvider delegate = S3EndpointProvider.defaultProvider();
        private final String endpoint;
        private final Region region;

        public MyS3EndpointProvider(String endpoint, Region region) {
            this.endpoint = endpoint;
            this.region = region;
        }

        public CompletableFuture<Endpoint> resolveEndpoint(S3EndpointParams endpointParams) {
            S3EndpointParams.Builder builder = S3EndpointParams.builder();
            builder.accelerate(endpointParams.accelerate());
            builder.bucket(endpointParams.bucket());
            builder.useFips(endpointParams.useFips());
            builder.useDualStack(endpointParams.useDualStack());
            builder.forcePathStyle(endpointParams.forcePathStyle());
            builder.useGlobalEndpoint(endpointParams.useGlobalEndpoint());
            builder.useObjectLambdaEndpoint(endpointParams.useObjectLambdaEndpoint());
            builder.disableAccessPoints(endpointParams.disableAccessPoints());
            builder.disableMultiRegionAccessPoints(endpointParams.disableMultiRegionAccessPoints());
            builder.useArnRegion(endpointParams.useArnRegion());
            builder.endpoint(this.endpoint);
            builder.region(this.region);
            return this.delegate.resolveEndpoint(builder.build());
        }
    }
}

