/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.announce;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jreleaser.bundle.RB;
import org.jreleaser.extensions.api.workflow.WorkflowListenerException;
import org.jreleaser.model.api.JReleaserCommand;
import org.jreleaser.model.api.hooks.ExecutionEvent;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.JReleaserModel;
import org.jreleaser.model.internal.JReleaserSupport;
import org.jreleaser.model.spi.announce.AnnounceException;
import org.jreleaser.model.spi.announce.Announcer;
import org.jreleaser.model.spi.announce.AnnouncerBuilder;
import org.jreleaser.model.spi.announce.AnnouncerBuilderFactory;

public final class Announcers {
    private Announcers() {
    }

    public static void announce(JReleaserContext context) {
        context.getLogger().info(RB.$((String)"announcers.header", (Object[])new Object[0]));
        context.getLogger().increaseIndent();
        context.getLogger().setPrefix("announce");
        if (!context.getModel().getAnnounce().isEnabled()) {
            context.getLogger().info(RB.$((String)"announcers.not.enabled", (Object[])new Object[0]));
            context.getLogger().decreaseIndent();
            context.getLogger().restorePrefix();
            return;
        }
        Map<String, Announcer<?>> announcers = Announcers.findAnnouncers(context);
        if (announcers.isEmpty()) {
            context.getLogger().info(RB.$((String)"announcers.not.configured", (Object[])new Object[0]));
            context.getLogger().decreaseIndent();
            context.getLogger().restorePrefix();
            return;
        }
        if (!context.getIncludedAnnouncers().isEmpty()) {
            boolean announced = false;
            for (String announcerName : context.getIncludedAnnouncers()) {
                if (!JReleaserSupport.supportedAnnouncers().contains(announcerName)) {
                    context.getLogger().warn(RB.$((String)"ERROR_unsupported_announcer", (Object[])new Object[]{announcerName}));
                    continue;
                }
                Announcer<?> announcer = announcers.get(announcerName);
                if (null == announcer) {
                    context.getLogger().warn(RB.$((String)"announcers.announcer.not.found", (Object[])new Object[0]), new Object[]{announcerName});
                    continue;
                }
                if (!announcer.isEnabled()) {
                    context.getLogger().warn(RB.$((String)"announcers.announcer.not.enabled", (Object[])new Object[0]), new Object[]{announcerName});
                    continue;
                }
                if (!Announcers.announce(context, announcer)) continue;
                announced = true;
            }
            if (!announced) {
                context.getLogger().info(RB.$((String)"announcers.not.triggered", (Object[])new Object[0]));
            }
            context.getLogger().decreaseIndent();
            context.getLogger().restorePrefix();
            return;
        }
        boolean announced = false;
        for (Map.Entry<String, Announcer<?>> entry : announcers.entrySet()) {
            Announcer<?> announcer = entry.getValue();
            if (context.getExcludedAnnouncers().contains(announcer.getName())) {
                context.getLogger().info(RB.$((String)"announcers.announcer.excluded", (Object[])new Object[0]), new Object[]{announcer.getName()});
                continue;
            }
            if (!Announcers.announce(context, announcer)) continue;
            announced = true;
        }
        if (!announced) {
            context.getLogger().info(RB.$((String)"announcers.not.triggered", (Object[])new Object[0]));
        }
        context.getLogger().decreaseIndent();
        context.getLogger().restorePrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean announce(JReleaserContext context, Announcer<?> announcer) {
        block8: {
            try {
                context.getLogger().setPrefix(announcer.getName());
                if (announcer.isEnabled()) {
                    Announcers.fireAnnounceEvent(ExecutionEvent.before((String)JReleaserCommand.ANNOUNCE.toStep()), context, announcer);
                    try {
                        announcer.announce();
                        Announcers.fireAnnounceEvent(ExecutionEvent.success((String)JReleaserCommand.ANNOUNCE.toStep()), context, announcer);
                        boolean bl = true;
                        return bl;
                    }
                    catch (AnnounceException e) {
                        Announcers.fireAnnounceEvent(ExecutionEvent.failure((String)JReleaserCommand.ANNOUNCE.toStep(), (Throwable)e), context, announcer);
                        context.getLogger().warn(e.getMessage().trim());
                        boolean bl = true;
                        context.getLogger().restorePrefix();
                        return bl;
                    }
                }
                context.getLogger().debug(RB.$((String)"announcers.announcer.disabled", (Object[])new Object[0]));
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                context.getLogger().restorePrefix();
            }
        }
        return false;
    }

    private static void fireAnnounceEvent(ExecutionEvent event, JReleaserContext context, Announcer<?> announcer) {
        try {
            context.fireAnnounceStepEvent(event, announcer.getAnnouncer());
        }
        catch (WorkflowListenerException e) {
            context.getLogger().error(RB.$((String)"listener.failure", (Object[])new Object[]{e.getListener().getClass().getName()}));
            context.getLogger().trace((Throwable)e);
        }
    }

    private static Map<String, Announcer<?>> findAnnouncers(JReleaserContext context) {
        JReleaserModel model = context.getModel();
        Map<String, AnnouncerBuilder> builders = StreamSupport.stream(ServiceLoader.load(AnnouncerBuilderFactory.class, Announcers.class.getClassLoader()).spliterator(), false).collect(Collectors.toMap(AnnouncerBuilderFactory::getName, AnnouncerBuilderFactory::getBuilder));
        TreeMap announcers = new TreeMap();
        builders.forEach((name, builder) -> {
            if (null != model.getAnnounce().findAnnouncer(name) && !context.getExcludedAnnouncers().contains(name)) {
                announcers.put((String)name, (Announcer<?>)builder.configureWith(context).build());
            }
        });
        return announcers;
    }
}

