/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.ssh;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.schmizz.sshj.SSHClient;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.download.Downloader;
import org.jreleaser.model.internal.download.ScpDownloader;
import org.jreleaser.model.spi.download.DownloadException;
import org.jreleaser.sdk.commons.AbstractArtifactDownloader;
import org.jreleaser.sdk.ssh.SshUtils;
import org.jreleaser.util.StringUtils;

public class ScpArtifactDownloader
extends AbstractArtifactDownloader<org.jreleaser.model.api.download.ScpDownloader, ScpDownloader> {
    private ScpDownloader downloader;

    public ScpArtifactDownloader(JReleaserContext context) {
        super(context);
    }

    public ScpDownloader getDownloader() {
        return this.downloader;
    }

    public void setDownloader(ScpDownloader downloader) {
        this.downloader = downloader;
    }

    public String getType() {
        return "scp";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(String name) throws DownloadException {
        SSHClient ssh = SshUtils.createSSHClient(this.context, this.downloader);
        try {
            for (Downloader.Asset asset : this.downloader.getAssets()) {
                this.downloadAsset(name, ssh, asset);
            }
        }
        finally {
            SshUtils.disconnect(this.downloader, ssh);
        }
    }

    private void downloadAsset(String name, SSHClient ssh, Downloader.Asset asset) throws DownloadException {
        String input = asset.getResolvedInput(this.context, (Downloader)this.downloader);
        String output = asset.getResolvedOutput(this.context, (Downloader)this.downloader, Paths.get(input, new String[0]).getFileName().toString());
        if (StringUtils.isBlank((String)output)) {
            output = Paths.get(input, new String[0]).getFileName().toString();
        }
        Path outputPath = this.context.getDownloadDirectory().resolve(name).resolve(output);
        this.context.getLogger().info("{} -> {}", new Object[]{input, this.context.relativizeToBasedir(outputPath)});
        if (!this.context.isDryrun()) {
            try {
                Files.createDirectories(outputPath.toAbsolutePath().getParent(), new FileAttribute[0]);
                ssh.newSCPFileTransfer().download(input, outputPath.toAbsolutePath().toString());
            }
            catch (IOException e) {
                throw new DownloadException(RB.$((String)"ERROR_unexpected_download", (Object[])new Object[]{input}), (Throwable)e);
            }
        }
        this.unpack(asset.getUnpack(), outputPath);
    }
}

