/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.templates;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import org.jreleaser.model.JReleaserVersion;

public class VersionDecoratingWriter
extends BufferedWriter {
    private static final String VERSION_MARKER = "{{jreleaserCreationStamp}}";
    private static final String JRELEASER_VERSION = JReleaserVersion.getPlainVersion();
    private static final String VERSION_BANNER = String.format("Generated with JReleaser %s at %s", JRELEASER_VERSION, ZonedDateTime.now().format(new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).optionalStart().appendOffset("+HH:MM", "Z").optionalEnd().toFormatter()));

    public VersionDecoratingWriter(Writer out) {
        super(out);
    }

    @Override
    public void write(String str) throws IOException {
        if (this.needsVersionReplacement(str)) {
            super.write(str.replace(VERSION_MARKER, VERSION_BANNER));
        } else {
            super.write(str);
        }
    }

    private boolean needsVersionReplacement(String str) {
        return str.contains(VERSION_MARKER);
    }
}

