/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.packagers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Flatpak;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.api.common.CommitAuthor;
import org.jreleaser.model.api.common.Icon;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.Screenshot;
import org.jreleaser.model.internal.packagers.AbstractRepositoryPackager;
import org.jreleaser.model.internal.packagers.PackagerRepository;
import org.jreleaser.model.internal.packagers.RepositoryTap;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class FlatpakPackager
extends AbstractRepositoryPackager<org.jreleaser.model.api.packagers.FlatpakPackager, FlatpakPackager> {
    private static final Map<Distribution.DistributionType, Set<String>> SUPPORTED = new LinkedHashMap<Distribution.DistributionType, Set<String>>();
    private final FlatpakRepository repository = new FlatpakRepository();
    private final List<Screenshot> screenshots = new ArrayList<Screenshot>();
    private final List<String> categories = new ArrayList<String>();
    private final List<org.jreleaser.model.internal.common.Icon> icons = new ArrayList<org.jreleaser.model.internal.common.Icon>();
    private final Set<String> sdkExtensions = new LinkedHashSet<String>();
    private final Set<String> finishArgs = new LinkedHashSet<String>();
    private final Set<String> skipReleases = new LinkedHashSet<String>();
    private String componentId;
    private String developerName;
    private Flatpak.Runtime runtime;
    private String runtimeVersion;
    private final org.jreleaser.model.api.packagers.FlatpakPackager immutable = new org.jreleaser.model.api.packagers.FlatpakPackager(){
        private List<? extends org.jreleaser.model.api.common.Screenshot> screenshots;
        private List<? extends Icon> icons;

        public String getComponentId() {
            return FlatpakPackager.this.componentId;
        }

        public List<String> getCategories() {
            return Collections.unmodifiableList(FlatpakPackager.this.categories);
        }

        public String getDeveloperName() {
            return FlatpakPackager.this.developerName;
        }

        public Flatpak.Runtime getRuntime() {
            return FlatpakPackager.this.runtime;
        }

        public String getRuntimeVersion() {
            return FlatpakPackager.this.runtimeVersion;
        }

        public Set<String> getSdkExtensions() {
            return Collections.unmodifiableSet(FlatpakPackager.this.sdkExtensions);
        }

        public Set<String> getFinishArgs() {
            return Collections.unmodifiableSet(FlatpakPackager.this.finishArgs);
        }

        public List<? extends org.jreleaser.model.api.common.Screenshot> getScreenshots() {
            if (null == this.screenshots) {
                this.screenshots = FlatpakPackager.this.screenshots.stream().map(Screenshot::asImmutable).collect(Collectors.toList());
            }
            return this.screenshots;
        }

        public List<? extends Icon> getIcons() {
            if (null == this.icons) {
                this.icons = FlatpakPackager.this.icons.stream().map(org.jreleaser.model.internal.common.Icon::asImmutable).collect(Collectors.toList());
            }
            return this.icons;
        }

        public Set<String> getSkipReleases() {
            return Collections.unmodifiableSet(FlatpakPackager.this.skipReleases);
        }

        public org.jreleaser.model.api.packagers.PackagerRepository getRepository() {
            return FlatpakPackager.this.repository.asImmutable();
        }

        public org.jreleaser.model.api.packagers.PackagerRepository getPackagerRepository() {
            return this.getRepository();
        }

        public CommitAuthor getCommitAuthor() {
            return FlatpakPackager.this.commitAuthor.asImmutable();
        }

        public String getTemplateDirectory() {
            return FlatpakPackager.this.templateDirectory;
        }

        public List<String> getSkipTemplates() {
            return Collections.unmodifiableList(FlatpakPackager.this.skipTemplates);
        }

        public String getType() {
            return FlatpakPackager.this.type;
        }

        public String getDownloadUrl() {
            return FlatpakPackager.this.downloadUrl;
        }

        public boolean supportsPlatform(String platform) {
            return FlatpakPackager.this.supportsPlatform(platform);
        }

        public boolean supportsDistribution(Distribution.DistributionType distributionType) {
            return FlatpakPackager.this.supportsDistribution(distributionType);
        }

        public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
            return FlatpakPackager.this.getSupportedFileExtensions(distributionType);
        }

        public Set<Stereotype> getSupportedStereotypes() {
            return FlatpakPackager.this.getSupportedStereotypes();
        }

        public boolean isSnapshotSupported() {
            return FlatpakPackager.this.isSnapshotSupported();
        }

        public boolean isContinueOnError() {
            return FlatpakPackager.this.isContinueOnError();
        }

        public Active getActive() {
            return FlatpakPackager.this.active;
        }

        public boolean isEnabled() {
            return FlatpakPackager.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(FlatpakPackager.this.asMap(full));
        }

        public String getPrefix() {
            return FlatpakPackager.this.getPrefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(FlatpakPackager.this.extraProperties);
        }
    };

    public FlatpakPackager() {
        super("flatpak");
    }

    @Override
    public org.jreleaser.model.api.packagers.FlatpakPackager asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(FlatpakPackager source) {
        super.merge(source);
        this.componentId = this.merge(this.componentId, source.componentId);
        this.developerName = this.merge(this.developerName, source.developerName);
        this.runtime = this.merge(this.runtime, source.runtime);
        this.runtimeVersion = this.merge(this.runtimeVersion, source.runtimeVersion);
        this.setSdkExtensions(this.merge(this.sdkExtensions, source.sdkExtensions));
        this.setFinishArgs(this.merge(this.finishArgs, source.finishArgs));
        this.setRepository(source.repository);
        this.setCategories(this.merge(this.categories, source.categories));
        this.setScreenshots(this.merge(this.screenshots, source.screenshots));
        this.setIcons(this.merge(this.icons, source.icons));
        this.setSkipReleases(this.merge(this.skipReleases, source.skipReleases));
    }

    @Override
    public Set<Stereotype> getSupportedStereotypes() {
        return CollectionUtils.setOf((Object[])new Stereotype[]{Stereotype.CLI, Stereotype.DESKTOP});
    }

    public String getComponentId() {
        return this.componentId;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public void setCategories(List<String> tags) {
        this.categories.clear();
        this.categories.addAll(tags);
    }

    public String getDeveloperName() {
        return this.developerName;
    }

    public void setDeveloperName(String developerName) {
        this.developerName = developerName;
    }

    public Flatpak.Runtime getRuntime() {
        return this.runtime;
    }

    public void setRuntime(Flatpak.Runtime runtime) {
        this.runtime = runtime;
    }

    public void setRuntime(String runtime) {
        this.setRuntime(Flatpak.Runtime.of((String)runtime));
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public void setRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
    }

    public Set<String> getSdkExtensions() {
        return this.sdkExtensions;
    }

    public void setSdkExtensions(Set<String> sdkExtensions) {
        this.sdkExtensions.clear();
        this.sdkExtensions.addAll(sdkExtensions);
    }

    public Set<String> getFinishArgs() {
        return this.finishArgs;
    }

    public void setFinishArgs(Set<String> finishArgs) {
        this.finishArgs.clear();
        this.finishArgs.addAll(finishArgs);
    }

    public List<Screenshot> getScreenshots() {
        return this.screenshots;
    }

    public void setScreenshots(List<Screenshot> screenshots) {
        this.screenshots.clear();
        this.screenshots.addAll(screenshots);
    }

    public void addScreenshot(Screenshot screenshot) {
        if (null != screenshot) {
            this.screenshots.add(screenshot);
        }
    }

    public List<org.jreleaser.model.internal.common.Icon> getIcons() {
        return this.icons;
    }

    public void setIcons(List<org.jreleaser.model.internal.common.Icon> icons) {
        this.icons.clear();
        this.icons.addAll(icons);
    }

    public void addIcon(org.jreleaser.model.internal.common.Icon icon) {
        if (null != icon) {
            this.icons.add(icon);
        }
    }

    public Set<String> getSkipReleases() {
        return this.skipReleases;
    }

    public void setSkipReleases(Set<String> tags) {
        this.skipReleases.clear();
        this.skipReleases.addAll(tags);
    }

    public FlatpakRepository getRepository() {
        return this.repository;
    }

    public void setRepository(FlatpakRepository repository) {
        this.repository.merge(repository);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> map) {
        super.asMap(full, map);
        map.put("componentId", this.componentId);
        map.put("categories", this.categories);
        map.put("developerName", this.developerName);
        map.put("runtime", this.runtime);
        map.put("runtimeVersion", this.runtimeVersion);
        map.put("sdkExtensions", this.sdkExtensions);
        map.put("finishArgs", this.finishArgs);
        LinkedHashMap<String, Map<String, Object>> sm = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (Screenshot screenshot : this.screenshots) {
            sm.put("screenshot " + i++, screenshot.asMap(full));
        }
        map.put("screenshots", sm);
        sm = new LinkedHashMap();
        i = 0;
        for (org.jreleaser.model.internal.common.Icon icon : this.icons) {
            sm.put("icon " + i++, icon.asMap(full));
        }
        map.put("icons", sm);
        map.put("skipReleases", this.skipReleases);
        map.put("repository", this.repository.asMap(full));
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.getPackagerRepository();
    }

    public PackagerRepository getPackagerRepository() {
        return this.repository;
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return StringUtils.isBlank((String)platform) || PlatformUtils.isLinux((String)platform) && PlatformUtils.isIntel64((String)platform) && !PlatformUtils.isAlpineLinux((String)platform);
    }

    @Override
    public boolean supportsDistribution(Distribution.DistributionType distributionType) {
        return SUPPORTED.containsKey(distributionType);
    }

    @Override
    public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
        return Collections.unmodifiableSet(SUPPORTED.getOrDefault(distributionType, Collections.emptySet()));
    }

    @Override
    protected boolean isNotSkipped(Artifact artifact) {
        return StringUtils.isFalse((Object)artifact.getExtraProperties().get("skipFlatpak"));
    }

    static {
        Set extensions = CollectionUtils.setOf((Object[])new String[]{FileType.TAR_GZ.extension(), FileType.TAR_XZ.extension(), FileType.TGZ.extension(), FileType.TXZ.extension(), FileType.TAR.extension(), FileType.ZIP.extension()});
        SUPPORTED.put(Distribution.DistributionType.BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JAVA_BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JLINK, extensions);
        SUPPORTED.put(Distribution.DistributionType.NATIVE_IMAGE, extensions);
    }

    public static final class FlatpakRepository
    extends PackagerRepository {
        public FlatpakRepository() {
            super("flatpak", "flatpak");
        }
    }
}

