/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.TwitterAnnouncer;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class TwitterAnnouncerValidator
extends Validator {
    public static void validateTwitter(JReleaserContext context, TwitterAnnouncer twitter, Errors errors) {
        context.getLogger().debug("announce.twitter");
        if (!twitter.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        twitter.setConsumerKey(TwitterAnnouncerValidator.checkProperty(context, "TWITTER_CONSUMER_KEY", "twitter.consumerKey", twitter.getConsumerKey(), errors, context.isDryrun()));
        twitter.setConsumerSecret(TwitterAnnouncerValidator.checkProperty(context, "TWITTER_CONSUMER_SECRET", "twitter.consumerSecret", twitter.getConsumerSecret(), errors, context.isDryrun()));
        twitter.setAccessToken(TwitterAnnouncerValidator.checkProperty(context, "TWITTER_ACCESS_TOKEN", "twitter.accessToken", twitter.getAccessToken(), errors, context.isDryrun()));
        twitter.setAccessTokenSecret(TwitterAnnouncerValidator.checkProperty(context, "TWITTER_ACCESS_TOKEN_SECRET", "twitter.accessTokenSecret", twitter.getAccessTokenSecret(), errors, context.isDryrun()));
        if (StringUtils.isNotBlank((String)twitter.getStatusTemplate()) && !Files.exists(context.getBasedir().resolve(twitter.getStatusTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"twitter.statusTemplate", twitter.getStatusTemplate()}));
        }
        if (StringUtils.isBlank((String)twitter.getStatus()) && StringUtils.isBlank((String)twitter.getStatusTemplate()) && twitter.getStatuses().isEmpty()) {
            twitter.setStatus(RB.$((String)"default.release.message", (Object[])new Object[0]));
        }
        TwitterAnnouncerValidator.validateTimeout(twitter);
    }
}

