/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.mustachejava.TemplateFunction;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.JReleaserVersion;
import org.jreleaser.model.api.JReleaserModel;
import org.jreleaser.model.internal.announce.Announce;
import org.jreleaser.model.internal.assemble.Assemble;
import org.jreleaser.model.internal.checksum.Checksum;
import org.jreleaser.model.internal.deploy.Deploy;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.download.Download;
import org.jreleaser.model.internal.environment.Environment;
import org.jreleaser.model.internal.extensions.Extension;
import org.jreleaser.model.internal.files.Files;
import org.jreleaser.model.internal.hooks.Hooks;
import org.jreleaser.model.internal.packagers.Packagers;
import org.jreleaser.model.internal.platform.Platform;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.release.Release;
import org.jreleaser.model.internal.signing.Signing;
import org.jreleaser.model.internal.upload.Upload;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.version.SemanticVersion;

public class JReleaserModel {
    private final Environment environment = new Environment();
    private final Hooks hooks = new Hooks();
    private final Project project = new Project();
    private final Platform platform = new Platform();
    private final Release release = new Release();
    private final Packagers packagers = new Packagers();
    private final Announce announce = new Announce();
    private final Download download = new Download();
    private final Assemble assemble = new Assemble();
    private final Deploy deploy = new Deploy();
    private final Upload upload = new Upload();
    private final Checksum checksum = new Checksum();
    private final Signing signing = new Signing();
    private final Files files = new Files();
    private final Map<String, Distribution> distributions = new LinkedHashMap<String, Distribution>();
    private final Map<String, Extension> extensions = new LinkedHashMap<String, Extension>();
    @JsonIgnore
    private final ZonedDateTime now;
    @JsonIgnore
    private final String timestamp;
    @JsonIgnore
    private JReleaserModel.Commit commit;
    private final org.jreleaser.model.api.JReleaserModel immutable = new org.jreleaser.model.api.JReleaserModel(){
        private Map<String, ? extends org.jreleaser.model.api.distributions.Distribution> distributions;
        private Map<String, ? extends org.jreleaser.model.api.extensions.Extension> extensions;

        public ZonedDateTime getNow() {
            return JReleaserModel.this.now;
        }

        public String getTimestamp() {
            return JReleaserModel.this.timestamp;
        }

        public JReleaserModel.Commit getCommit() {
            return JReleaserModel.this.commit;
        }

        public org.jreleaser.model.api.environment.Environment getEnvironment() {
            return JReleaserModel.this.environment.asImmutable();
        }

        public org.jreleaser.model.api.hooks.Hooks getHooks() {
            return JReleaserModel.this.hooks.asImmutable();
        }

        public org.jreleaser.model.api.platform.Platform getPlatform() {
            return JReleaserModel.this.platform.asImmutable();
        }

        public org.jreleaser.model.api.project.Project getProject() {
            return JReleaserModel.this.project.asImmutable();
        }

        public org.jreleaser.model.api.release.Release getRelease() {
            return JReleaserModel.this.release.asImmutable();
        }

        public org.jreleaser.model.api.packagers.Packagers getPackagers() {
            return JReleaserModel.this.packagers.asImmutable();
        }

        public org.jreleaser.model.api.announce.Announce getAnnounce() {
            return JReleaserModel.this.announce.asImmutable();
        }

        public org.jreleaser.model.api.assemble.Assemble getAssemble() {
            return JReleaserModel.this.assemble.asImmutable();
        }

        public org.jreleaser.model.api.download.Download getDownload() {
            return JReleaserModel.this.download.asImmutable();
        }

        public org.jreleaser.model.api.deploy.Deploy getDeploy() {
            return JReleaserModel.this.deploy.asImmutable();
        }

        public org.jreleaser.model.api.upload.Upload getUpload() {
            return JReleaserModel.this.upload.asImmutable();
        }

        public org.jreleaser.model.api.checksum.Checksum getChecksum() {
            return JReleaserModel.this.checksum.asImmutable();
        }

        public org.jreleaser.model.api.signing.Signing getSigning() {
            return JReleaserModel.this.signing.asImmutable();
        }

        public org.jreleaser.model.api.files.Files getFiles() {
            return JReleaserModel.this.files.asImmutable();
        }

        public Map<String, ? extends org.jreleaser.model.api.distributions.Distribution> getDistributions() {
            if (null == this.distributions) {
                this.distributions = JReleaserModel.this.distributions.values().stream().map(Distribution::asImmutable).collect(Collectors.toMap(org.jreleaser.model.api.distributions.Distribution::getName, Function.identity()));
            }
            return this.distributions;
        }

        public Map<String, ? extends org.jreleaser.model.api.extensions.Extension> getExtensions() {
            if (null == this.extensions) {
                this.extensions = JReleaserModel.this.extensions.values().stream().map(Extension::asImmutable).collect(Collectors.toMap(org.jreleaser.model.api.extensions.Extension::getName, Function.identity()));
            }
            return this.extensions;
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(JReleaserModel.this.asMap(full));
        }
    };

    public JReleaserModel() {
        this.now = ZonedDateTime.now();
        this.timestamp = this.now.format(new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).optionalStart().appendOffset("+HH:MM", "Z").optionalEnd().toFormatter());
    }

    public org.jreleaser.model.api.JReleaserModel asImmutable() {
        return this.immutable;
    }

    public ZonedDateTime getNow() {
        return this.now;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public JReleaserModel.Commit getCommit() {
        return this.commit;
    }

    public void setCommit(JReleaserModel.Commit commit) {
        this.commit = commit;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment.merge(environment);
    }

    public Hooks getHooks() {
        return this.hooks;
    }

    public void setHooks(Hooks hooks) {
        this.hooks.merge(hooks);
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform.merge(platform);
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project.merge(project);
    }

    public Release getRelease() {
        return this.release;
    }

    public void setRelease(Release release) {
        this.release.merge(release);
    }

    public Packagers getPackagers() {
        return this.packagers;
    }

    public void setPackagers(Packagers packagers) {
        this.packagers.merge(packagers);
    }

    public Announce getAnnounce() {
        return this.announce;
    }

    public void setAnnounce(Announce announce) {
        this.announce.merge(announce);
    }

    public Assemble getAssemble() {
        return this.assemble;
    }

    public void setAssemble(Assemble assemble) {
        this.assemble.merge(assemble);
    }

    public Download getDownload() {
        return this.download;
    }

    public void setDownload(Download download) {
        this.download.merge(download);
    }

    public Deploy getDeploy() {
        return this.deploy;
    }

    public void setDeploy(Deploy deploy) {
        this.deploy.merge(deploy);
    }

    public Upload getUpload() {
        return this.upload;
    }

    public void setUpload(Upload upload) {
        this.upload.merge(upload);
    }

    public Checksum getChecksum() {
        return this.checksum;
    }

    public void setChecksum(Checksum checksum) {
        this.checksum.merge(checksum);
    }

    public Signing getSigning() {
        return this.signing;
    }

    public void setSigning(Signing signing) {
        this.signing.merge(signing);
    }

    public Files getFiles() {
        return this.files;
    }

    public void setFiles(Files files) {
        this.files.merge(files);
    }

    public List<Distribution> getActiveDistributions() {
        return this.distributions.values().stream().filter(Distribution::isEnabled).collect(Collectors.toList());
    }

    public Map<String, Distribution> getDistributions() {
        return this.distributions;
    }

    public void setDistributions(Map<String, Distribution> distributions) {
        this.distributions.clear();
        this.distributions.putAll(distributions);
    }

    public void addDistribution(Distribution distribution) {
        this.distributions.put(distribution.getName(), distribution);
    }

    public Distribution findDistribution(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new JReleaserException(RB.$((String)"ERROR_distribution_name_is_blank", (Object[])new Object[0]));
        }
        if (this.distributions.containsKey(name)) {
            return this.distributions.get(name);
        }
        throw new JReleaserException(RB.$((String)"ERROR_distribution_not_found", (Object[])new Object[]{name}));
    }

    public List<Extension> getActiveExtensions() {
        return this.extensions.values().stream().filter(Extension::isEnabled).collect(Collectors.toList());
    }

    public Map<String, Extension> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Map<String, Extension> extensions) {
        this.extensions.clear();
        this.extensions.putAll(extensions);
    }

    public void addExtension(Extension extension) {
        this.extensions.put(extension.getName(), extension);
    }

    public Map<String, Object> asMap(boolean full) {
        List distributions;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        List extensions = this.extensions.values().stream().filter(e -> full || e.isEnabled()).map(e -> e.asMap(full)).collect(Collectors.toList());
        if (!extensions.isEmpty()) {
            map.put("extensions", extensions);
        }
        if (full || this.environment.isSet()) {
            map.put("environment", this.environment.asMap(full));
        }
        if (full || this.hooks.isSet()) {
            map.put("hooks", this.hooks.asMap(full));
        }
        map.put("project", this.project.asMap(full));
        if (full || this.platform.isSet()) {
            map.put("platform", this.platform.asMap(full));
        }
        map.put("release", this.release.asMap(full));
        map.put("checksum", this.checksum.asMap(full));
        if (full || this.signing.isEnabled()) {
            map.put("signing", this.signing.asMap(full));
        }
        if (full || this.announce.isEnabled()) {
            map.put("announce", this.announce.asMap(full));
        }
        if (!this.files.isEmpty()) {
            map.put("files", this.files.asMap(full));
        }
        if (full || this.packagers.hasEnabledPackagers()) {
            map.put("packagers", this.packagers.asMap(full));
        }
        if (full || this.download.isEnabled()) {
            map.put("download", this.download.asMap(full));
        }
        if (full || this.assemble.isEnabled()) {
            map.put("assemble", this.assemble.asMap(full));
        }
        if (full || this.deploy.isEnabled()) {
            map.put("deploy", this.deploy.asMap(full));
        }
        if (full || this.upload.isEnabled()) {
            map.put("upload", this.upload.asMap(full));
        }
        if (!(distributions = this.distributions.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("distributions", distributions);
        }
        return map;
    }

    public Map<String, Object> props() {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        String jreleaserCreationStamp = String.format("Generated with JReleaser %s at %s", JReleaserVersion.getPlainVersion(), this.timestamp);
        props.put("jreleaserCreationStamp", jreleaserCreationStamp);
        this.fillProjectProperties(props, this.project);
        this.fillReleaserProperties(props, this.release);
        String osName = PlatformUtils.getDetectedOs();
        String osArch = PlatformUtils.getDetectedArch();
        props.put("osName", osName);
        props.put("osArch", osArch);
        props.put("osVersion", PlatformUtils.getDetectedVersion());
        props.put("osPlatform", PlatformUtils.getCurrentFull());
        props.put("osPlatformReplaced", this.getPlatform().applyReplacements(PlatformUtils.getCurrentFull()));
        MustacheUtils.applyTemplates(props, this.project.getResolvedExtraProperties());
        props.put("__ZonedDateTime_now__", this.now);
        props.put("f_release_download_url", new ReleaserDownloadUrl());
        return props;
    }

    private void fillProjectProperties(Map<String, Object> props, Project project) {
        props.putAll(this.environment.getProperties());
        props.putAll(this.environment.getSourcedProperties());
        props.put("timestamp", this.timestamp);
        if (this.commit != null) {
            props.put("commitShortHash", this.commit.getShortHash());
            props.put("commitFullHash", this.commit.getFullHash());
        }
        props.put("projectName", project.getName());
        props.put("projectNameCapitalized", StringUtils.getCapitalizedName((String)project.getName()));
        props.put("projectVersion", project.getVersion());
        props.put("projectStereotype", project.getStereotype());
        props.put("projectEffectiveVersion", project.getEffectiveVersion());
        props.put("projectSnapshot", String.valueOf(project.isSnapshot()));
        if (StringUtils.isNotBlank((String)project.getDescription())) {
            props.put("projectDescription", MustacheUtils.passThrough((String)project.getDescription()));
        }
        if (StringUtils.isNotBlank((String)project.getLongDescription())) {
            props.put("projectLongDescription", MustacheUtils.passThrough((String)project.getLongDescription()));
        }
        if (StringUtils.isNotBlank((String)project.getLicense())) {
            props.put("projectLicense", project.getLicense());
        }
        if (null != project.getInceptionYear()) {
            props.put("projectInceptionYear", project.getInceptionYear());
        }
        if (StringUtils.isNotBlank((String)project.getCopyright())) {
            props.put("projectCopyright", project.getCopyright());
        }
        if (StringUtils.isNotBlank((String)project.getVendor())) {
            props.put("projectVendor", project.getVendor());
        }
        project.getLinks().fillProps(props);
        props.put("projectAuthorsBySpace", String.join((CharSequence)" ", project.getAuthors()));
        props.put("projectAuthorsByComma", String.join((CharSequence)",", project.getAuthors()));
        props.put("projectTagsBySpace", String.join((CharSequence)" ", project.getTags()));
        props.put("projectTagsByComma", String.join((CharSequence)",", project.getTags()));
        if (project.getJava().isEnabled()) {
            props.putAll(project.getJava().getResolvedExtraProperties());
            props.put("projectJavaGroupId", project.getJava().getGroupId());
            props.put("projectJavaArtifactId", project.getJava().getArtifactId());
            props.put("projectJavaVersion", project.getJava().getVersion());
            props.put("projectJavaMainClass", project.getJava().getMainClass());
            SemanticVersion jv = SemanticVersion.of((String)project.getJava().getVersion());
            props.put("projectJavaVersionMajor", jv.getMajor());
            if (jv.hasMinor()) {
                props.put("projectJavaVersionMinor", jv.getMinor());
            }
            if (jv.hasPatch()) {
                props.put("projectJavaVersionPatch", jv.getPatch());
            }
            if (jv.hasTag()) {
                props.put("projectJavaVersionTag", jv.getTag());
            }
            if (jv.hasBuild()) {
                props.put("projectJavaVersionBuild", jv.getBuild());
            }
        }
        project.parseVersion();
        props.putAll(project.getResolvedExtraProperties());
    }

    private void fillReleaserProperties(Map<String, Object> props, Release release) {
        BaseReleaser<?, ?> service = release.getReleaser();
        props.put("repoHost", service.getHost());
        props.put("repoOwner", service.getOwner());
        props.put("repoName", service.getName());
        props.put("repoBranch", service.getBranch());
        props.put("reverseRepoHost", service.getReverseRepoHost());
        props.put("repoCanonicalName", service.getCanonicalRepoName());
        props.put("tagName", service.getEffectiveTagName(this));
        props.put("releaseName", service.getEffectiveReleaseName());
        props.put("milestoneName", service.getMilestone().getEffectiveName());
        props.put("repoUrl", service.getResolvedRepoUrl(this));
        props.put("repoCloneUrl", service.getResolvedRepoCloneUrl(this));
        props.put("commitsUrl", service.getResolvedCommitUrl(this));
        props.put("srcUrl", service.getResolvedSrcUrl(this));
        props.put("releaseNotesUrl", service.getResolvedReleaseNotesUrl(this));
        props.put("latestReleaseUrl", service.getResolvedLatestReleaseUrl(this));
        props.put("issueTrackerUrl", service.getResolvedIssueTrackerUrl(this));
    }

    private final class ReleaserDownloadUrl
    implements TemplateFunction {
        private static final String NAME = "f_release_download_url";

        private ReleaserDownloadUrl() {
        }

        public String apply(String input) {
            String format = "md";
            String artifactFile = "";
            String[] parts = input.split(":");
            if (parts.length == 1) {
                artifactFile = parts[0];
            } else if (parts.length == 2) {
                format = parts[0];
                artifactFile = parts[1];
            } else {
                throw new JReleaserException(RB.$((String)"ERROR_invalid_function_input", (Object[])new Object[]{input, NAME}));
            }
            switch (format.toLowerCase(Locale.ENGLISH)) {
                case "md": {
                    return ("[{{artifactFile}}](" + JReleaserModel.this.getRelease().getReleaser().getDownloadUrl() + ")").replace("{{artifactFile}}", artifactFile);
                }
                case "adoc": {
                    return ("link:" + JReleaserModel.this.getRelease().getReleaser().getDownloadUrl() + "[{{artifactFile}}]").replace("{{artifactFile}}", artifactFile);
                }
                case "html": {
                    return ("<a href=\"" + JReleaserModel.this.getRelease().getReleaser().getDownloadUrl() + "\">{{artifactFile}}</a>").replace("{{artifactFile}}", artifactFile);
                }
            }
            throw new JReleaserException(RB.$((String)"ERROR_invalid_function_input", (Object[])new Object[]{input, NAME}));
        }
    }
}

