/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.github;

import java.io.IOException;
import java.util.LinkedHashMap;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.release.GithubReleaser;
import org.jreleaser.model.spi.announce.AnnounceException;
import org.jreleaser.model.spi.announce.Announcer;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.sdk.github.Github;
import org.jreleaser.util.StringUtils;

public class DiscussionsAnnouncer
implements Announcer<org.jreleaser.model.api.announce.DiscussionsAnnouncer> {
    private final JReleaserContext context;
    private final org.jreleaser.model.internal.announce.DiscussionsAnnouncer discussions;

    public DiscussionsAnnouncer(JReleaserContext context) {
        this.context = context;
        this.discussions = context.getModel().getAnnounce().getDiscussions();
    }

    public org.jreleaser.model.api.announce.DiscussionsAnnouncer getAnnouncer() {
        return this.discussions.asImmutable();
    }

    public String getName() {
        return "discussions";
    }

    public boolean isEnabled() {
        return this.discussions.isEnabled();
    }

    public void announce() throws AnnounceException {
        GithubReleaser github = this.context.getModel().getRelease().getGithub();
        String message = "";
        if (StringUtils.isNotBlank((String)this.discussions.getMessage())) {
            message = this.discussions.getResolvedMessage(this.context);
        } else {
            LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
            props.put("changelog", MustacheUtils.passThrough((String)this.context.getChangelog()));
            this.context.getModel().getRelease().getReleaser().fillProps(props, this.context.getModel());
            message = this.discussions.getResolvedMessageTemplate(this.context, props);
        }
        String title = this.discussions.getResolvedTitle(this.context);
        this.context.getLogger().info("title: {}", new Object[]{title});
        this.context.getLogger().debug("message: {}", new Object[]{message});
        try {
            Github api = new Github(this.context.getLogger(), github.getApiEndpoint(), github.getResolvedToken(), this.discussions.getConnectTimeout(), this.discussions.getReadTimeout());
            if (api.findDiscussion(this.discussions.getOrganization(), this.discussions.getTeam(), title).isPresent()) {
                throw new IllegalStateException(RB.$((String)"ERROR_git_discussion_duplicate", (Object[])new Object[]{title, this.discussions.getOrganization(), this.discussions.getTeam()}));
            }
            api.createDiscussion(this.discussions.getOrganization(), this.discussions.getTeam(), title, message);
        }
        catch (IOException | IllegalStateException e) {
            this.context.getLogger().trace((Throwable)e);
            throw new AnnounceException((Throwable)e);
        }
    }
}

