/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.announce;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.api.announce.Announcer;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.AbstractAnnouncer;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.StringUtils;

public abstract class AbstractMessageAnnouncer<S extends AbstractMessageAnnouncer<S, A>, A extends Announcer>
extends AbstractAnnouncer<S, A> {
    private static final long serialVersionUID = -6198150578785334265L;
    private String message;
    private String messageTemplate;

    protected AbstractMessageAnnouncer(String type) {
        super(type);
    }

    @Override
    public void merge(S source) {
        super.merge(source);
        this.message = this.merge(this.message, ((AbstractMessageAnnouncer)source).getMessage());
        this.messageTemplate = this.merge(this.messageTemplate, ((AbstractMessageAnnouncer)source).getMessageTemplate());
    }

    @Override
    protected boolean isSet() {
        return super.isSet() || StringUtils.isNotBlank((String)this.message) || StringUtils.isNotBlank((String)this.messageTemplate);
    }

    public String getResolvedMessage(JReleaserContext context) {
        TemplateContext props = context.fullProps();
        MustacheUtils.applyTemplates((TemplateContext)props, this.resolvedExtraProperties());
        return Templates.resolveTemplate((String)this.message, (TemplateContext)props);
    }

    public String getResolvedMessageTemplate(JReleaserContext context, TemplateContext extraProps) {
        TemplateContext props = context.fullProps();
        MustacheUtils.applyTemplates((TemplateContext)props, this.resolvedExtraProperties());
        props.set("tagName", (Object)context.getModel().getRelease().getReleaser().getEffectiveTagName(context.getModel()));
        props.set("previousTagName", (Object)context.getModel().getRelease().getReleaser().getResolvedPreviousTagName(context.getModel()));
        props.setAll(extraProps);
        Path templatePath = context.getBasedir().resolve(this.messageTemplate);
        try {
            BufferedReader reader = Files.newBufferedReader(templatePath);
            return MustacheUtils.applyTemplate((Reader)reader, (TemplateContext)props);
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_reading_template", (Object[])new Object[]{context.relativizeToBasedir(templatePath)}));
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public void setMessageTemplate(String messageTemplate) {
        this.messageTemplate = messageTemplate;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("message", this.message);
        props.put("messageTemplate", this.messageTemplate);
    }
}

