/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import twitter4j.HashtagEntity;
import twitter4j.HashtagEntityJSONImpl;
import twitter4j.JSONArray;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.MediaEntity;
import twitter4j.MediaEntityJSONImpl;
import twitter4j.SymbolEntity;
import twitter4j.TwitterException;
import twitter4j.URLEntity;
import twitter4j.URLEntityJSONImpl;
import twitter4j.UserMentionEntity;
import twitter4j.UserMentionEntityJSONImpl;

class EntitiesParseUtil {
    EntitiesParseUtil() {
    }

    static UserMentionEntity[] getUserMentions(JSONObject entities) throws JSONException, TwitterException {
        if (!entities.isNull("user_mentions")) {
            JSONArray userMentionsArray = entities.getJSONArray("user_mentions");
            int len = userMentionsArray.length();
            UserMentionEntity[] userMentionEntities = new UserMentionEntity[len];
            for (int i = 0; i < len; ++i) {
                userMentionEntities[i] = new UserMentionEntityJSONImpl(userMentionsArray.getJSONObject(i));
            }
            return userMentionEntities;
        }
        return null;
    }

    static URLEntity[] getUrls(JSONObject entities) throws JSONException, TwitterException {
        if (!entities.isNull("urls")) {
            JSONArray urlsArray = entities.getJSONArray("urls");
            int len = urlsArray.length();
            URLEntity[] urlEntities = new URLEntity[len];
            for (int i = 0; i < len; ++i) {
                urlEntities[i] = new URLEntityJSONImpl(urlsArray.getJSONObject(i));
            }
            return urlEntities;
        }
        return null;
    }

    static HashtagEntity[] getHashtags(JSONObject entities) throws JSONException, TwitterException {
        if (!entities.isNull("hashtags")) {
            JSONArray hashtagsArray = entities.getJSONArray("hashtags");
            int len = hashtagsArray.length();
            HashtagEntity[] hashtagEntities = new HashtagEntity[len];
            for (int i = 0; i < len; ++i) {
                hashtagEntities[i] = new HashtagEntityJSONImpl(hashtagsArray.getJSONObject(i));
            }
            return hashtagEntities;
        }
        return null;
    }

    static SymbolEntity[] getSymbols(JSONObject entities) throws JSONException, TwitterException {
        if (!entities.isNull("symbols")) {
            JSONArray symbolsArray = entities.getJSONArray("symbols");
            int len = symbolsArray.length();
            SymbolEntity[] symbolEntities = new SymbolEntity[len];
            for (int i = 0; i < len; ++i) {
                symbolEntities[i] = new HashtagEntityJSONImpl(symbolsArray.getJSONObject(i));
            }
            return symbolEntities;
        }
        return null;
    }

    static MediaEntity[] getMedia(JSONObject entities) throws JSONException, TwitterException {
        if (!entities.isNull("media")) {
            JSONArray mediaArray = entities.getJSONArray("media");
            int len = mediaArray.length();
            MediaEntity[] mediaEntities = new MediaEntity[len];
            for (int i = 0; i < len; ++i) {
                mediaEntities[i] = new MediaEntityJSONImpl(mediaArray.getJSONObject(i));
            }
            return mediaEntities;
        }
        return null;
    }
}

