/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.catalog.sbom;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.catalog.sbom.SbomCataloger;
import org.jreleaser.model.api.catalog.sbom.SyftSbomCataloger;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.catalog.sbom.AbstractSbomCataloger;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.ExtraProperties;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.FileType;
import org.jreleaser.util.StringUtils;

public final class SyftSbomCataloger
extends AbstractSbomCataloger<SyftSbomCataloger, org.jreleaser.model.api.catalog.sbom.SyftSbomCataloger> {
    private static final long serialVersionUID = 8892967680009048184L;
    private final Set<SyftSbomCataloger.Format> formats = new LinkedHashSet<SyftSbomCataloger.Format>();
    private String version;
    @JsonIgnore
    private final org.jreleaser.model.api.catalog.sbom.SyftSbomCataloger immutable = new org.jreleaser.model.api.catalog.sbom.SyftSbomCataloger(){
        private static final long serialVersionUID = 6622561901807746751L;

        public String getVersion() {
            return SyftSbomCataloger.this.getVersion();
        }

        public Set<SyftSbomCataloger.Format> getFormats() {
            return Collections.unmodifiableSet(SyftSbomCataloger.this.getFormats());
        }

        public boolean isDistributions() {
            return SyftSbomCataloger.this.isDistributions();
        }

        public boolean isFiles() {
            return SyftSbomCataloger.this.isFiles();
        }

        public SbomCataloger.Pack getPack() {
            return SyftSbomCataloger.this.getPack().asImmutable();
        }

        public String getGroup() {
            return "sbom";
        }

        public String getType() {
            return SyftSbomCataloger.this.getType();
        }

        public Active getActive() {
            return SyftSbomCataloger.this.getActive();
        }

        public boolean isEnabled() {
            return SyftSbomCataloger.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(SyftSbomCataloger.this.asMap(full));
        }

        public String getPrefix() {
            return SyftSbomCataloger.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(SyftSbomCataloger.this.getExtraProperties());
        }
    };

    public SyftSbomCataloger() {
        super("syft");
    }

    @Override
    public org.jreleaser.model.api.catalog.sbom.SyftSbomCataloger asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(SyftSbomCataloger source) {
        super.merge(source);
        this.version = this.merge(this.version, source.version);
        this.setFormats(this.merge(this.formats, source.formats));
    }

    @Override
    protected boolean isSet() {
        return super.isSet() || StringUtils.isNotBlank((String)this.version) || !this.formats.isEmpty();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Set<SyftSbomCataloger.Format> getFormats() {
        return this.formats;
    }

    public void setFormats(Set<SyftSbomCataloger.Format> formats) {
        this.formats.clear();
        this.formats.addAll(formats);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("version", this.version);
        props.put("formats", this.formats);
    }

    @Override
    public Set<Artifact> resolveArtifacts(JReleaserContext context, Set<Artifact> candidates) {
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        if (this.getPack().isEnabled()) {
            artifacts.add(Artifact.of(this.resolveArchivePath(context)));
        } else {
            artifacts.addAll(this.doResolveArtifacts(context, candidates));
        }
        return artifacts;
    }

    @Override
    public boolean isSkipped(ExtraProperties target) {
        return StringUtils.isTrue((Object)target.getExtraProperties().get("skipSbom")) || StringUtils.isTrue((Object)target.getExtraProperties().get("skipSbomSyft"));
    }

    @Override
    public Path resolveArchivePath(JReleaserContext context) {
        Path catalogDirectory = context.getCatalogsDirectory().resolve("sbom").resolve(this.getType());
        String archiveName = this.resolveArchiveName(context);
        return catalogDirectory.resolve(archiveName);
    }

    private String resolveArchiveName(JReleaserContext context) {
        String archiveName = this.getPack().getName();
        TemplateContext props = context.fullProps();
        props.setAll(this.resolvedExtraProperties());
        return Templates.resolveTemplate((String)archiveName, (TemplateContext)props) + FileType.ZIP.extension();
    }

    private Set<Artifact> doResolveArtifacts(JReleaserContext context, Set<Artifact> candidates) {
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        Path catalogDirectory = context.getCatalogsDirectory().resolve("sbom").resolve(this.getType());
        for (SyftSbomCataloger.Format format : this.formats) {
            for (Artifact artifact : candidates) {
                String artifactFile = artifact.getEffectivePath().getFileName().toString();
                Path targetPath = catalogDirectory.resolve(artifactFile + format.extension());
                artifacts.add(Artifact.of(targetPath));
            }
        }
        return artifacts;
    }
}

