/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.AutoCloseBase;
import com.github.luben.zstd.EndDirective;
import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictCompress;
import com.github.luben.zstd.ZstdException;
import com.github.luben.zstd.ZstdFrameProgression;
import com.github.luben.zstd.util.Native;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ZstdCompressCtx
extends AutoCloseBase {
    private long nativePtr = 0L;
    private ZstdDictCompress compression_dict = null;

    private native void init();

    private native void free();

    public ZstdCompressCtx() {
        this.init();
        if (0L == this.nativePtr) {
            throw new IllegalStateException("ZSTD_createCompressCtx failed");
        }
        this.storeFence();
    }

    @Override
    void doClose() {
        if (this.nativePtr != 0L) {
            this.free();
            this.nativePtr = 0L;
        }
    }

    public ZstdCompressCtx setLevel(int n) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        this.setLevel0(n);
        this.releaseSharedLock();
        return this;
    }

    private native void setLevel0(int var1);

    public ZstdCompressCtx setMagicless(boolean bl) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        Zstd.setCompressionMagicless(this.nativePtr, bl);
        this.releaseSharedLock();
        return this;
    }

    public ZstdCompressCtx setChecksum(boolean bl) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        this.setChecksum0(bl);
        this.releaseSharedLock();
        return this;
    }

    private native void setChecksum0(boolean var1);

    public ZstdCompressCtx setWorkers(int n) {
        this.acquireSharedLock();
        Zstd.setCompressionWorkers(this.nativePtr, n);
        this.releaseSharedLock();
        return this;
    }

    public ZstdCompressCtx setContentSize(boolean bl) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        this.setContentSize0(bl);
        this.releaseSharedLock();
        return this;
    }

    private native void setContentSize0(boolean var1);

    public ZstdCompressCtx setDictID(boolean bl) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        this.setDictID0(bl);
        this.releaseSharedLock();
        return this;
    }

    private native void setDictID0(boolean var1);

    public ZstdCompressCtx setLong(int n) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        Zstd.setCompressionLong(this.nativePtr, n);
        this.releaseSharedLock();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZstdCompressCtx loadDict(ZstdDictCompress zstdDictCompress) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        zstdDictCompress.acquireSharedLock();
        try {
            long l = this.loadCDictFast0(zstdDictCompress);
            if (Zstd.isError(l)) {
                throw new ZstdException(l);
            }
            this.compression_dict = zstdDictCompress;
        }
        finally {
            zstdDictCompress.releaseSharedLock();
            this.releaseSharedLock();
        }
        return this;
    }

    private native long loadCDictFast0(ZstdDictCompress var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZstdCompressCtx loadDict(byte[] byArray) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        try {
            long l = this.loadCDict0(byArray);
            if (Zstd.isError(l)) {
                throw new ZstdException(l);
            }
            this.compression_dict = null;
        }
        finally {
            this.releaseSharedLock();
        }
        return this;
    }

    private native long loadCDict0(byte[] var1);

    private void ensureOpen() {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
    }

    public ZstdFrameProgression getFrameProgression() {
        this.ensureOpen();
        return this.getFrameProgression0();
    }

    private native ZstdFrameProgression getFrameProgression0();

    public void reset() {
        this.ensureOpen();
        long l = this.reset0();
        if (Zstd.isError(l)) {
            throw new ZstdException(l);
        }
    }

    private native long reset0();

    public void setPledgedSrcSize(long l) {
        this.ensureOpen();
        long l2 = this.setPledgedSrcSize0(l);
        if (Zstd.isError(l2)) {
            throw new ZstdException(l2);
        }
    }

    private native long setPledgedSrcSize0(long var1);

    public boolean compressDirectByteBufferStream(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, EndDirective endDirective) {
        this.ensureOpen();
        long l = this.compressDirectByteBufferStream0(byteBuffer, byteBuffer.position(), byteBuffer.limit(), byteBuffer2, byteBuffer2.position(), byteBuffer2.limit(), endDirective.value());
        if ((l & 0x80000000L) != 0L) {
            long l2 = l & 0xFFL;
            throw new ZstdException(l2, Zstd.getErrorName(l2));
        }
        byteBuffer2.position((int)(l & Integer.MAX_VALUE));
        byteBuffer.position((int)(l >>> 32) & Integer.MAX_VALUE);
        return l >>> 63 == 1L;
    }

    private native long compressDirectByteBufferStream0(ByteBuffer var1, int var2, int var3, ByteBuffer var4, int var5, int var6, int var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compressDirectByteBuffer(ByteBuffer byteBuffer, int n, int n2, ByteBuffer byteBuffer2, int n3, int n4) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        if (!byteBuffer2.isDirect()) {
            throw new IllegalArgumentException("srcBuff must be a direct buffer");
        }
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("dstBuff must be a direct buffer");
        }
        this.acquireSharedLock();
        try {
            long l = this.compressDirectByteBuffer0(byteBuffer, n, n2, byteBuffer2, n3, n4);
            if (Zstd.isError(l)) {
                throw new ZstdException(l);
            }
            if (l > Integer.MAX_VALUE) {
                throw new ZstdException(Zstd.errGeneric(), "Output size is greater than MAX_INT");
            }
            int n5 = (int)l;
            return n5;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private native long compressDirectByteBuffer0(ByteBuffer var1, int var2, int var3, ByteBuffer var4, int var5, int var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compressByteArray(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        try {
            long l = this.compressByteArray0(byArray, n, n2, byArray2, n3, n4);
            if (Zstd.isError(l)) {
                throw new ZstdException(l);
            }
            if (l > Integer.MAX_VALUE) {
                throw new ZstdException(Zstd.errGeneric(), "Output size is greater than MAX_INT");
            }
            int n5 = (int)l;
            return n5;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private native long compressByteArray0(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6);

    public int compress(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        int n = this.compressDirectByteBuffer(byteBuffer, byteBuffer.position(), byteBuffer.limit() - byteBuffer.position(), byteBuffer2, byteBuffer2.position(), byteBuffer2.limit() - byteBuffer2.position());
        byteBuffer2.position(byteBuffer2.limit());
        byteBuffer.position(byteBuffer.position() + n);
        return n;
    }

    public ByteBuffer compress(ByteBuffer byteBuffer) throws ZstdException {
        long l = Zstd.compressBound(byteBuffer.limit() - byteBuffer.position());
        if (l > Integer.MAX_VALUE) {
            throw new ZstdException(Zstd.errGeneric(), "Max output size is greater than MAX_INT");
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect((int)l);
        int n = this.compressDirectByteBuffer(byteBuffer2, 0, (int)l, byteBuffer, byteBuffer.position(), byteBuffer.limit() - byteBuffer.position());
        byteBuffer.position(byteBuffer.limit());
        byteBuffer2.limit(n);
        return byteBuffer2;
    }

    public int compress(byte[] byArray, byte[] byArray2) {
        return this.compressByteArray(byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    public byte[] compress(byte[] byArray) {
        long l = Zstd.compressBound(byArray.length);
        if (l > Integer.MAX_VALUE) {
            throw new ZstdException(Zstd.errGeneric(), "Max output size is greater than MAX_INT");
        }
        byte[] byArray2 = new byte[(int)l];
        int n = this.compressByteArray(byArray2, 0, byArray2.length, byArray, 0, byArray.length);
        return Arrays.copyOfRange(byArray2, 0, n);
    }

    static {
        Native.load();
    }
}

