/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.telegram;

import java.util.Objects;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.sdk.telegram.TelegramException;
import org.jreleaser.sdk.telegram.api.Message;
import org.jreleaser.sdk.telegram.api.TelegramAPI;
import org.jreleaser.util.StringUtils;

public class TelegramSdk {
    private final JReleaserLogger logger;
    private final TelegramAPI api;
    private final boolean dryrun;

    private TelegramSdk(JReleaserLogger logger, String apiHost, int connectTimeout, int readTimeout, boolean dryrun) {
        Objects.requireNonNull(logger, "'logger' must not be null");
        StringUtils.requireNonBlank((String)apiHost, (String)"'apiHost' must not be blank");
        this.logger = logger;
        this.dryrun = dryrun;
        this.api = (TelegramAPI)ClientUtils.builder((JReleaserLogger)logger, (int)connectTimeout, (int)readTimeout).target(TelegramAPI.class, apiHost);
        this.logger.debug(RB.$((String)"workflow.dryrun", (Object[])new Object[0]), new Object[]{dryrun});
    }

    public void sendMessage(String chatId, String message) throws TelegramException {
        Message payload = Message.of(chatId, message);
        this.logger.debug("telegram.message: " + payload);
        this.wrap(() -> this.api.sendMessage(payload));
    }

    private void wrap(Runnable runnable) throws TelegramException {
        try {
            if (!this.dryrun) {
                runnable.run();
            }
        }
        catch (RestAPIException e) {
            this.logger.trace(e.getStatus() + ": " + e.getReason());
            this.logger.trace((Throwable)e);
            throw new TelegramException(RB.$((String)"sdk.operation.failed", (Object[])new Object[]{"Telegram"}), e);
        }
    }

    public static Builder builder(JReleaserLogger logger) {
        return new Builder(logger);
    }

    public static class Builder {
        private final JReleaserLogger logger;
        private boolean dryrun;
        private String apiHost;
        private String token;
        private int connectTimeout = 20;
        private int readTimeout = 60;

        private Builder(JReleaserLogger logger) {
            this.logger = Objects.requireNonNull(logger, "'logger' must not be null");
        }

        public Builder dryrun(boolean dryrun) {
            this.dryrun = dryrun;
            return this;
        }

        public Builder apiHost(String apiHost) {
            this.apiHost = StringUtils.requireNonBlank((String)apiHost, (String)"'apiHost' must not be blank").trim();
            return this;
        }

        public Builder token(String token) {
            this.token = StringUtils.requireNonBlank((String)token, (String)"'token' must not be blank").trim();
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        private void validate() {
            StringUtils.requireNonBlank((String)this.token, (String)"'token' must not be blank");
            if (StringUtils.isBlank((String)this.apiHost)) {
                this.apiHost("https://api.telegram.org/bot");
            }
            if (!this.apiHost.endsWith(this.token)) {
                this.apiHost = this.apiHost + this.token;
            }
        }

        public TelegramSdk build() {
            this.validate();
            return new TelegramSdk(this.logger, this.apiHost, this.connectTimeout, this.readTimeout, this.dryrun);
        }
    }
}

