/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.sshj.userauth.keyprovider;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.security.PublicKey;
import net.schmizz.sshj.common.Base64;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.KeyType;

public class OpenSSHKeyFileUtil {
    private OpenSSHKeyFileUtil() {
    }

    public static File getPublicKeyFile(File privateKeyFile) {
        File pubKey = new File(privateKeyFile + "-cert.pub");
        if (!pubKey.exists()) {
            pubKey = new File(privateKeyFile + ".pub");
        }
        if (pubKey.exists()) {
            return pubKey;
        }
        return null;
    }

    public static ParsedPubKey initPubKey(Reader publicKey) throws IOException {
        try (BufferedReader br = new BufferedReader(publicKey);){
            String keydata;
            while ((keydata = br.readLine()) != null) {
                if ((keydata = keydata.trim()).isEmpty()) continue;
                String[] parts = keydata.trim().split("\\s+");
                if (parts.length >= 2) {
                    ParsedPubKey parsedPubKey = new ParsedPubKey(KeyType.fromString(parts[0]), new Buffer.PlainBuffer(Base64.decode(parts[1])).readPublicKey());
                    return parsedPubKey;
                }
                throw new IOException("Got line with only one column");
            }
            throw new IOException("Public key file is blank");
        }
    }

    public static class ParsedPubKey {
        private final KeyType type;
        private final PublicKey pubKey;

        public ParsedPubKey(KeyType type, PublicKey pubKey) {
            this.type = type;
            this.pubKey = pubKey;
        }

        public KeyType getType() {
            return this.type;
        }

        public PublicKey getPubKey() {
            return this.pubKey;
        }
    }
}

