/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.JbangPackager;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.spi.packagers.PackagerProcessingException;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.packagers.AbstractRepositoryPackagerProcessor;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.JsonUtils;
import org.jreleaser.util.StringUtils;

public class JbangPackagerProcessor
extends AbstractRepositoryPackagerProcessor<JbangPackager> {
    public JbangPackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    public boolean supportsDistribution(Distribution distribution) {
        return distribution.getType() != Distribution.DistributionType.JLINK;
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, TemplateContext props, Path packageDirectory) throws PackagerProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(props);
    }

    @Override
    protected boolean verifyAndAddArtifacts(TemplateContext props, Distribution distribution) {
        return true;
    }

    @Override
    protected void fillPackagerProperties(TemplateContext props, Distribution distribution) {
        String aliasName;
        BaseReleaser releaser = this.context.getModel().getRelease().getReleaser();
        props.set("jbangCatalogRepoUrl", (Object)releaser.getResolvedRepoUrl(this.context.getModel(), ((JbangPackager)this.packager).getCatalog().getOwner(), ((JbangPackager)this.packager).getCatalog().getResolvedName()));
        props.set("jbangCatalogRepoCloneUrl", (Object)releaser.getResolvedRepoCloneUrl(this.context.getModel(), ((JbangPackager)this.packager).getCatalog().getOwner(), ((JbangPackager)this.packager).getCatalog().getResolvedName()));
        String scriptName = aliasName = this.sanitizeAlias(((JbangPackager)this.packager).getAlias());
        if (this.context.getModel().getProject().isSnapshot()) {
            aliasName = aliasName + "-snapshot";
            scriptName = scriptName + "_snapshot";
        }
        scriptName = this.sanitizeScriptName(scriptName);
        props.set("jbangAliasName", (Object)aliasName);
        props.set("jbangScriptName", (Object)scriptName);
        String jbangDistributionGA = (String)((JbangPackager)this.packager).resolvedExtraProperties().get("jbangDistributionGA");
        if (StringUtils.isBlank((String)jbangDistributionGA)) {
            if (this.context.getModel().getProject().isSnapshot()) {
                String reverseRepoHost = releaser.getReverseRepoHost();
                if (((JbangPackager)this.packager).getExtraProperties().containsKey("reverseDomain")) {
                    reverseRepoHost = (String)((JbangPackager)this.packager).getExtraProperties().get("reverseDomain");
                } else if (StringUtils.isBlank((String)reverseRepoHost)) {
                    reverseRepoHost = (String)((JbangPackager)this.packager).getExtraProperties().get("reverseRepoHost");
                }
                StringBuilder b = new StringBuilder(reverseRepoHost).append(".").append(releaser.getOwner());
                if (distribution.getJava().isMultiProject()) {
                    b.append(".").append(releaser.getName());
                }
                b.append(":").append(distribution.getJava().getArtifactId());
                jbangDistributionGA = b.toString();
            } else {
                jbangDistributionGA = distribution.getJava().getGroupId() + ":" + distribution.getJava().getArtifactId();
            }
        }
        props.set("jbangDistributionGA", (Object)jbangDistributionGA);
    }

    private String sanitizeAlias(String alias) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < alias.length(); ++i) {
            char ch = alias.charAt(i);
            if (!Character.isJavaIdentifierPart(ch) && ch != '-') continue;
            b.append(ch);
        }
        return b.toString();
    }

    private String sanitizeScriptName(String scriptName) {
        scriptName = scriptName.replace("-", "_");
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < scriptName.length(); ++i) {
            char ch = scriptName.charAt(i);
            if (!Character.isJavaIdentifierPart(ch)) continue;
            b.append(ch);
        }
        return b.toString();
    }

    @Override
    protected void writeFile(Distribution distribution, String content, TemplateContext props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        fileName = TemplateUtils.trimTplExtension((String)fileName);
        String scriptName = (String)props.get("jbangScriptName");
        Path outputFile = "jbang.java".equals(fileName) ? outputDirectory.resolve(scriptName.concat(".java")) : outputDirectory.resolve(fileName);
        this.writeFile(content, outputFile);
    }

    @Override
    protected void prepareWorkingCopy(TemplateContext props, Path directory, Distribution distribution) throws IOException {
        Path catalog = directory.resolve("jbang-catalog.json");
        if (catalog.toFile().exists()) {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode previous = objectMapper.readTree(Files.readAllBytes(catalog));
            super.prepareWorkingCopy(props, directory, distribution);
            JsonNode current = objectMapper.readTree(Files.readAllBytes(catalog));
            JsonNode merged = JsonUtils.merge((JsonNode)previous, (JsonNode)current);
            Files.write(catalog, merged.toPrettyString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        } else {
            super.prepareWorkingCopy(props, directory, distribution);
        }
    }
}

