/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.TIterator;
import gnu.trove.TLongObjectHashMap;
import java.util.ConcurrentModificationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TLongObjectIterator<V>
extends TIterator {
    private final TLongObjectHashMap<V> _map;

    public TLongObjectIterator(TLongObjectHashMap<V> map2) {
        super(map2);
        this._map = map2;
    }

    @Override
    protected final int nextIndex() {
        if (this._expectedSize != this._map.size()) {
            throw new ConcurrentModificationException();
        }
        Object[] values2 = this._map._values;
        int i = this._index;
        while (i-- > 0 && !TLongObjectHashMap.isFull(values2, i)) {
        }
        return i;
    }

    public void advance() {
        this.moveToNextIndex();
    }

    public long key() {
        return this._map._set[this._index];
    }

    public V value() {
        return this._map._values[this._index];
    }

    public V setValue(V val) {
        V old = this.value();
        this._map._values[this._index] = val;
        return old;
    }
}

