/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.cli;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.cli.Action;
import kotlinx.cli.ArgumentAction;
import kotlinx.cli.CommandLineException;
import kotlinx.cli.CommandLineInterface;
import kotlinx.cli.FlagAction;
import kotlinx.cli.HelpPrintedException;
import kotlinx.cli.HelpPrinter;
import kotlinx.cli.MissingArgumentException;
import kotlinx.cli.PositionalArgument;
import kotlinx.cli.StopParsingException;
import kotlinx.cli.UtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010*\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0016\u0010\u000f\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\nH\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u001b\u0010\u0016\u001a\u00020\f2\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0018\u00a2\u0006\u0002\u0010\u0019J\u0014\u0010\u0016\u001a\u00020\f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u001aJ\u0014\u0010\u001b\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\nJ\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a2\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u001aH\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a2\u0006\u0010\u0013\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lkotlinx/cli/CommandLineParser;", "", "cli", "Lkotlinx/cli/CommandLineInterface;", "(Lkotlinx/cli/CommandLineInterface;)V", "currentPositional", "Lkotlinx/cli/PositionalArgument;", "currentPositionalCount", "", "positionalsIterator", "", "checkEnoughPositionals", "", "positionalArgument", "actualCount", "doParse", "argsIterator", "", "handlePositionalArgument", "arg", "isShortTagPrefixed", "", "parse", "args", "", "([Ljava/lang/String;)V", "", "parseTokenized", "tokenizeArg", "tokenizeArgs", "tokenizeShortTags", "ki-shell"})
public final class CommandLineParser {
    private ListIterator<? extends PositionalArgument> positionalsIterator;
    private PositionalArgument currentPositional;
    private int currentPositionalCount;
    private final CommandLineInterface cli;

    public final void parse(@NotNull String[] args2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        this.parse(ArraysKt.asList(args2));
    }

    public final void parse(@NotNull List<String> args2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        this.parseTokenized(this.tokenizeArgs(args2).listIterator());
    }

    public final void parseTokenized(@NotNull ListIterator<String> argsIterator) {
        Intrinsics.checkNotNullParameter(argsIterator, "argsIterator");
        if (!argsIterator.hasNext() && this.cli.getPrintHelpByDefault()) {
            CommandLineInterface.printHelp$default(this.cli, null, 1, null);
            throw (Throwable)new HelpPrintedException();
        }
        try {
            this.doParse(argsIterator);
        }
        catch (StopParsingException e) {
            throw (Throwable)e;
        }
        catch (Throwable e) {
            String string2 = e.getMessage();
            if (string2 != null) {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                HelpPrinter helpPrinter = this.cli.getDefaultHelpPrinter();
                if (helpPrinter != null) {
                    helpPrinter.printText(it);
                }
            }
            CommandLineInterface.printHelp$default(this.cli, null, 1, null);
            throw e;
        }
    }

    private final void doParse(ListIterator<String> argsIterator) {
        ListIterator<? extends PositionalArgument> listIterator = this.positionalsIterator = this.cli.getPositionalArgumentsIterator();
        if (listIterator == null) {
            Intrinsics.throwUninitializedPropertyAccessException("positionalsIterator");
        }
        this.currentPositional = (PositionalArgument)UtilKt.nextOrNull((Iterator)listIterator);
        this.currentPositionalCount = 0;
        while (argsIterator.hasNext()) {
            String arg = argsIterator.next();
            if (this.cli.getArgumentsAfterDoubleDashArePositional() && Intrinsics.areEqual(arg, "--")) {
                while (argsIterator.hasNext()) {
                    this.handlePositionalArgument(argsIterator.next());
                }
                return;
            }
            Action action = this.cli.getFlagAction(arg);
            if (action == null) {
                this.handlePositionalArgument(arg);
                continue;
            }
            try {
                action.invoke(argsIterator);
            }
            catch (MissingArgumentException e) {
                throw (Throwable)new CommandLineException("No argument for flag " + arg);
            }
        }
        PositionalArgument positionalArgument2 = this.currentPositional;
        if (positionalArgument2 != null) {
            PositionalArgument positionalArgument3 = positionalArgument2;
            boolean bl = false;
            boolean bl2 = false;
            PositionalArgument it = positionalArgument3;
            boolean bl3 = false;
            this.checkEnoughPositionals(it, this.currentPositionalCount);
        }
        while (true) {
            ListIterator<? extends PositionalArgument> listIterator2 = this.positionalsIterator;
            if (listIterator2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("positionalsIterator");
            }
            if (!listIterator2.hasNext()) break;
            ListIterator<? extends PositionalArgument> listIterator3 = this.positionalsIterator;
            if (listIterator3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("positionalsIterator");
            }
            this.checkEnoughPositionals(listIterator3.next(), 0);
        }
    }

    private final void handlePositionalArgument(String arg) {
        PositionalArgument positionalArgument2 = this.currentPositional;
        boolean bl = false;
        boolean bl2 = false;
        PositionalArgument cp = positionalArgument2;
        boolean bl3 = false;
        if (cp != null) {
            cp.getAction().invoke(arg);
            int n = this.currentPositionalCount;
            this.currentPositionalCount = n + 1;
            if (this.currentPositionalCount >= cp.getMaxArgs()) {
                ListIterator<? extends PositionalArgument> listIterator = this.positionalsIterator;
                if (listIterator == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("positionalsIterator");
                }
                this.currentPositional = (PositionalArgument)UtilKt.nextOrNull((Iterator)listIterator);
                this.currentPositionalCount = 0;
            }
        } else {
            throw (Throwable)new CommandLineException("Unexpected positional argument: '" + arg + '\'');
        }
    }

    private final void checkEnoughPositionals(PositionalArgument positionalArgument2, int actualCount) {
        if (actualCount < positionalArgument2.getMinArgs()) {
            throw (Throwable)new CommandLineException("Not enough positional arguments for " + positionalArgument2.getName() + ": " + actualCount + ", expected at least " + positionalArgument2.getMinArgs());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> tokenizeArgs(List<String> args2) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = args2;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.tokenizeArg(it);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<String> tokenizeArg(String arg) {
        if (this.cli.getFlagAction(arg) != null) {
            return CollectionsKt.listOf(arg);
        }
        if (this.cli.getLongTagValueDelimiter() != null) {
            int k;
            boolean bl;
            block9: {
                Iterable $this$any$iv = this.cli.getLongTagPrefixes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.startsWith$default(arg, it, false, 2, null)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (bl && (k = StringsKt.indexOf$default((CharSequence)arg, this.cli.getLongTagValueDelimiter(), 0, false, 6, null)) >= 0) {
                String string2 = arg;
                int n = 0;
                int n2 = 0;
                Object object = string2;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = ((String)object).substring(n, k);
                Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String longTag = string3;
                String string4 = arg;
                n2 = k + 1;
                boolean bl3 = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n2);
                Intrinsics.checkNotNullExpressionValue(string6, "(this as java.lang.String).substring(startIndex)");
                String longValue = string6;
                return CollectionsKt.listOf(longTag, longValue);
            }
        }
        if (this.isShortTagPrefixed(arg)) {
            return this.tokenizeShortTags(arg);
        }
        return CollectionsKt.listOf(arg);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> tokenizeShortTags(String arg) {
        ArrayList<String> result2 = new ArrayList<String>();
        int n = 1;
        int n2 = arg.length();
        while (n < n2) {
            Action action;
            void i;
            String fullTag = this.cli.getShortTagPrefix() + arg.charAt((int)i);
            if (this.cli.getFlagAction(fullTag) == null) {
                return CollectionsKt.listOf(arg);
            }
            Action action2 = action;
            if (!(action2 instanceof FlagAction)) {
                if (action2 instanceof ArgumentAction) {
                    result2.add(fullTag);
                    if (i < StringsKt.getLastIndex(arg)) {
                        String string2 = arg;
                        void var9_10 = i + true;
                        boolean bl = false;
                        String string3 = string2;
                        if (string3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string4 = string3.substring((int)var9_10);
                        Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.String).substring(startIndex)");
                        result2.add(string4);
                    }
                    return result2;
                }
                String string5 = "Unexpected short tag action: " + fullTag + " => " + action;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string5.toString());
            }
            result2.add(fullTag);
            ++i;
        }
        return result2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isShortTagPrefixed(String arg) {
        String it;
        if (this.cli.getShortTagPrefix() == null) return false;
        if (!StringsKt.startsWith$default(arg, this.cli.getShortTagPrefix(), false, 2, null)) return false;
        Iterable $this$none$iv = this.cli.getLongTagPrefixes();
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$none$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!StringsKt.startsWith$default(arg, it, false, 2, null));
        return false;
    }

    public CommandLineParser(@NotNull CommandLineInterface cli) {
        Intrinsics.checkNotNullParameter(cli, "cli");
        this.cli = cli;
    }
}

