/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.util;

import java.util.Collection;
import org.apache.http.util.TextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Args {
    public static void check(boolean expression2, String message2) {
        if (!expression2) {
            throw new IllegalArgumentException(message2);
        }
    }

    public static void check(boolean expression2, String message2, Object ... args2) {
        if (!expression2) {
            throw new IllegalArgumentException(String.format(message2, args2));
        }
    }

    public static <T> T notNull(T argument, String name2) {
        if (argument == null) {
            throw new IllegalArgumentException(name2 + " may not be null");
        }
        return argument;
    }

    public static <T extends CharSequence> T notEmpty(T argument, String name2) {
        if (argument == null) {
            throw new IllegalArgumentException(name2 + " may not be null");
        }
        if (TextUtils.isEmpty(argument)) {
            throw new IllegalArgumentException(name2 + " may not be empty");
        }
        return argument;
    }

    public static <T extends CharSequence> T notBlank(T argument, String name2) {
        if (argument == null) {
            throw new IllegalArgumentException(name2 + " may not be null");
        }
        if (TextUtils.isBlank(argument)) {
            throw new IllegalArgumentException(name2 + " may not be blank");
        }
        return argument;
    }

    public static <E, T extends Collection<E>> T notEmpty(T argument, String name2) {
        if (argument == null) {
            throw new IllegalArgumentException(name2 + " may not be null");
        }
        if (argument.isEmpty()) {
            throw new IllegalArgumentException(name2 + " may not be empty");
        }
        return argument;
    }

    public static int positive(int n, String name2) {
        if (n <= 0) {
            throw new IllegalArgumentException(name2 + " may not be negative or zero");
        }
        return n;
    }

    public static long positive(long n, String name2) {
        if (n <= 0L) {
            throw new IllegalArgumentException(name2 + " may not be negative or zero");
        }
        return n;
    }

    public static int notNegative(int n, String name2) {
        if (n < 0) {
            throw new IllegalArgumentException(name2 + " may not be negative");
        }
        return n;
    }

    public static long notNegative(long n, String name2) {
        if (n < 0L) {
            throw new IllegalArgumentException(name2 + " may not be negative");
        }
        return n;
    }
}

