/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.eventspy.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.eventspy.EventSpy;
import org.apache.maven.eventspy.internal.EventSpyExecutionListener;
import org.apache.maven.eventspy.internal.EventSpyRepositoryListener;
import org.apache.maven.execution.ExecutionListener;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.RepositoryListener;

@Component(role=EventSpyDispatcher.class)
public class EventSpyDispatcher {
    @Requirement
    private Logger logger;
    @Requirement(role=EventSpy.class)
    private List<EventSpy> eventSpies;

    public void setEventSpies(List<EventSpy> eventSpies) {
        this.eventSpies = new ArrayList<EventSpy>(eventSpies);
    }

    public List<EventSpy> getEventSpies() {
        return this.eventSpies;
    }

    public ExecutionListener chainListener(ExecutionListener listener) {
        if (this.eventSpies.isEmpty()) {
            return listener;
        }
        return new EventSpyExecutionListener(this, listener);
    }

    public RepositoryListener chainListener(RepositoryListener listener) {
        if (this.eventSpies.isEmpty()) {
            return listener;
        }
        return new EventSpyRepositoryListener(this, listener);
    }

    public void init(EventSpy.Context context2) {
        if (this.eventSpies.isEmpty()) {
            return;
        }
        for (EventSpy eventSpy : this.eventSpies) {
            try {
                eventSpy.init(context2);
            }
            catch (Exception | LinkageError e) {
                this.logError("initialize", e, eventSpy);
            }
        }
    }

    public void onEvent(Object event) {
        if (this.eventSpies.isEmpty()) {
            return;
        }
        for (EventSpy eventSpy : this.eventSpies) {
            try {
                eventSpy.onEvent(event);
            }
            catch (Exception | LinkageError e) {
                this.logError("notify", e, eventSpy);
            }
        }
    }

    public void close() {
        if (this.eventSpies.isEmpty()) {
            return;
        }
        for (EventSpy eventSpy : this.eventSpies) {
            try {
                eventSpy.close();
            }
            catch (Exception | LinkageError e) {
                this.logError("close", e, eventSpy);
            }
        }
    }

    private void logError(String action, Throwable e, EventSpy spy) {
        String msg = "Failed to " + action + " spy " + spy.getClass().getName() + ": " + e.getMessage();
        if (this.logger.isDebugEnabled()) {
            this.logger.warn(msg, e);
        } else {
            this.logger.warn(msg);
        }
    }
}

