/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.extension.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.project.ExtensionDescriptor;
import org.apache.maven.project.ExtensionDescriptorBuilder;
import org.codehaus.plexus.classworlds.realm.ClassRealm;

public class CoreExtensionEntry {
    private final ClassRealm realm;
    private final Set<String> artifacts;
    private final Set<String> packages;
    private static final ExtensionDescriptorBuilder BUILDER = new ExtensionDescriptorBuilder();

    public CoreExtensionEntry(ClassRealm realm, Collection<String> artifacts, Collection<String> packages2) {
        this.realm = realm;
        this.artifacts = Collections.unmodifiableSet(new HashSet<String>(artifacts));
        this.packages = Collections.unmodifiableSet(new HashSet<String>(packages2));
    }

    public ClassRealm getClassRealm() {
        return this.realm;
    }

    public Set<String> getExportedArtifacts() {
        return this.artifacts;
    }

    public Set<String> getExportedPackages() {
        return this.packages;
    }

    public static CoreExtensionEntry discoverFrom(ClassRealm loader) {
        LinkedHashSet<String> artifacts = new LinkedHashSet<String>();
        LinkedHashSet<String> packages2 = new LinkedHashSet<String>();
        try {
            Enumeration<URL> urls = loader.getResources(BUILDER.getExtensionDescriptorLocation());
            while (urls.hasMoreElements()) {
                InputStream is = urls.nextElement().openStream();
                Throwable throwable = null;
                try {
                    ExtensionDescriptor descriptor2 = BUILDER.build(is);
                    artifacts.addAll(descriptor2.getExportedArtifacts());
                    packages2.addAll(descriptor2.getExportedPackages());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new CoreExtensionEntry(loader, artifacts, packages2);
    }

    public static CoreExtensionEntry discoverFrom(ClassRealm loader, Collection<File> classpath2) {
        LinkedHashSet<String> artifacts = new LinkedHashSet<String>();
        LinkedHashSet<String> packages2 = new LinkedHashSet<String>();
        try {
            for (File entry : classpath2) {
                ExtensionDescriptor descriptor2 = BUILDER.build(entry);
                if (descriptor2 == null) continue;
                artifacts.addAll(descriptor2.getExportedArtifacts());
                packages2.addAll(descriptor2.getExportedPackages());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new CoreExtensionEntry(loader, artifacts, packages2);
    }
}

