/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle;

import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;

public class LifecycleExecutionException
extends Exception {
    private MavenProject project;

    public LifecycleExecutionException(String message2) {
        super(message2);
    }

    public LifecycleExecutionException(Throwable cause) {
        super(cause);
    }

    public LifecycleExecutionException(String message2, Throwable cause) {
        super(message2, cause);
    }

    public LifecycleExecutionException(String message2, MavenProject project) {
        super(message2);
        this.project = project;
    }

    public LifecycleExecutionException(String message2, MojoExecution execution, MavenProject project) {
        super(message2);
        this.project = project;
    }

    public LifecycleExecutionException(String message2, MojoExecution execution, MavenProject project, Throwable cause) {
        super(message2, cause);
        this.project = project;
    }

    public LifecycleExecutionException(MojoExecution execution, MavenProject project, Throwable cause) {
        this(LifecycleExecutionException.createMessage(execution, project, cause), execution, project, cause);
    }

    public MavenProject getProject() {
        return this.project;
    }

    private static String createMessage(MojoExecution execution, MavenProject project, Throwable cause) {
        MessageBuilder buffer = MessageUtils.buffer(256);
        buffer.a("Failed to execute goal");
        if (execution != null) {
            buffer.a(Character.valueOf(' '));
            buffer.mojo(execution.getGroupId() + ':' + execution.getArtifactId() + ':' + execution.getVersion() + ':' + execution.getGoal());
            buffer.a(Character.valueOf(' ')).strong('(' + execution.getExecutionId() + ')');
        }
        if (project != null) {
            buffer.a(" on project ");
            buffer.project(project.getArtifactId());
        }
        if (cause != null) {
            buffer.a(": ").failure(cause.getMessage());
        }
        return buffer.toString();
    }
}

