/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.prefix.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.repository.metadata.io.MetadataReader;
import org.apache.maven.model.Build;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import org.apache.maven.plugin.prefix.PluginPrefixRequest;
import org.apache.maven.plugin.prefix.PluginPrefixResolver;
import org.apache.maven.plugin.prefix.PluginPrefixResult;
import org.apache.maven.plugin.prefix.internal.DefaultPluginPrefixResult;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;

@Component(role=PluginPrefixResolver.class)
public class DefaultPluginPrefixResolver
implements PluginPrefixResolver {
    private static final String REPOSITORY_CONTEXT = "plugin";
    @Requirement
    private Logger logger;
    @Requirement
    private BuildPluginManager pluginManager;
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private MetadataReader metadataReader;

    @Override
    public PluginPrefixResult resolve(PluginPrefixRequest request) throws NoPluginFoundForPrefixException {
        this.logger.debug("Resolving plugin prefix " + request.getPrefix() + " from " + request.getPluginGroups());
        PluginPrefixResult result2 = this.resolveFromProject(request);
        if (result2 == null) {
            result2 = this.resolveFromRepository(request);
            if (result2 == null) {
                throw new NoPluginFoundForPrefixException(request.getPrefix(), request.getPluginGroups(), request.getRepositorySession().getLocalRepository(), request.getRepositories());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Resolved plugin prefix " + request.getPrefix() + " to " + result2.getGroupId() + ":" + result2.getArtifactId() + " from repository " + (result2.getRepository() != null ? result2.getRepository().getId() : "null"));
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Resolved plugin prefix " + request.getPrefix() + " to " + result2.getGroupId() + ":" + result2.getArtifactId() + " from POM " + request.getPom());
        }
        return result2;
    }

    private PluginPrefixResult resolveFromProject(PluginPrefixRequest request) {
        Build build2;
        PluginPrefixResult result2 = null;
        if (request.getPom() != null && request.getPom().getBuild() != null && (result2 = this.resolveFromProject(request, (build2 = request.getPom().getBuild()).getPlugins())) == null && build2.getPluginManagement() != null) {
            result2 = this.resolveFromProject(request, build2.getPluginManagement().getPlugins());
        }
        return result2;
    }

    private PluginPrefixResult resolveFromProject(PluginPrefixRequest request, List<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            try {
                PluginDescriptor pluginDescriptor = this.pluginManager.loadPlugin(plugin, request.getRepositories(), request.getRepositorySession());
                if (!request.getPrefix().equals(pluginDescriptor.getGoalPrefix())) continue;
                return new DefaultPluginPrefixResult(plugin);
            }
            catch (Exception e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.warn("Failed to retrieve plugin descriptor for " + plugin.getId() + ": " + e.getMessage(), e);
                    continue;
                }
                this.logger.warn("Failed to retrieve plugin descriptor for " + plugin.getId() + ": " + e.getMessage());
            }
        }
        return null;
    }

    private PluginPrefixResult resolveFromRepository(PluginPrefixRequest request) {
        RequestTrace trace = RequestTrace.newChild(null, request);
        ArrayList<MetadataRequest> requests = new ArrayList<MetadataRequest>();
        for (String pluginGroup : request.getPluginGroups()) {
            DefaultMetadata metadata2 = new DefaultMetadata(pluginGroup, "maven-metadata.xml", Metadata.Nature.RELEASE_OR_SNAPSHOT);
            requests.add(new MetadataRequest(metadata2, null, REPOSITORY_CONTEXT).setTrace(trace));
            for (RemoteRepository repository : request.getRepositories()) {
                requests.add(new MetadataRequest(metadata2, repository, REPOSITORY_CONTEXT).setTrace(trace));
            }
        }
        List<MetadataResult> results = this.repositorySystem.resolveMetadata(request.getRepositorySession(), requests);
        requests.clear();
        PluginPrefixResult result2 = this.processResults(request, trace, results, requests);
        if (result2 != null) {
            return result2;
        }
        if (!request.getRepositorySession().isOffline() && !requests.isEmpty()) {
            DefaultRepositorySystemSession session2 = new DefaultRepositorySystemSession(request.getRepositorySession());
            session2.setUpdatePolicy("always");
            results = this.repositorySystem.resolveMetadata(session2, requests);
            return this.processResults(request, trace, results, null);
        }
        return null;
    }

    private PluginPrefixResult processResults(PluginPrefixRequest request, RequestTrace trace, List<MetadataResult> results, List<MetadataRequest> requests) {
        for (MetadataResult res2 : results) {
            Metadata metadata2 = res2.getMetadata();
            if (metadata2 != null) {
                PluginPrefixResult result2;
                ArtifactRepository repository = res2.getRequest().getRepository();
                if (repository == null) {
                    repository = request.getRepositorySession().getLocalRepository();
                }
                if ((result2 = this.resolveFromRepository(request, trace, metadata2.getGroupId(), metadata2, repository)) != null) {
                    return result2;
                }
            }
            if (requests == null || res2.isUpdated()) continue;
            requests.add(res2.getRequest());
        }
        return null;
    }

    private PluginPrefixResult resolveFromRepository(PluginPrefixRequest request, RequestTrace trace, String pluginGroup, Metadata metadata2, ArtifactRepository repository) {
        if (metadata2 != null && metadata2.getFile() != null && metadata2.getFile().isFile()) {
            try {
                Map<String, Boolean> options = Collections.singletonMap("org.apache.maven.artifact.repository.metadata.io.isStrict", Boolean.FALSE);
                org.apache.maven.artifact.repository.metadata.Metadata pluginGroupMetadata = this.metadataReader.read(metadata2.getFile(), options);
                List<org.apache.maven.artifact.repository.metadata.Plugin> plugins = pluginGroupMetadata.getPlugins();
                if (plugins != null) {
                    for (org.apache.maven.artifact.repository.metadata.Plugin plugin : plugins) {
                        if (!request.getPrefix().equals(plugin.getPrefix())) continue;
                        return new DefaultPluginPrefixResult(pluginGroup, plugin.getArtifactId(), repository);
                    }
                }
            }
            catch (IOException e) {
                this.invalidMetadata(request.getRepositorySession(), trace, metadata2, repository, e);
            }
        }
        return null;
    }

    private void invalidMetadata(RepositorySystemSession session2, RequestTrace trace, Metadata metadata2, ArtifactRepository repository, Exception exception) {
        RepositoryListener listener = session2.getRepositoryListener();
        if (listener != null) {
            RepositoryEvent.Builder event = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.METADATA_INVALID);
            event.setTrace(trace);
            event.setMetadata(metadata2);
            event.setException(exception);
            event.setRepository(repository);
            listener.metadataInvalid(event.build());
        }
    }
}

