/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.composite;

import java.lang.reflect.Modifier;
import java.util.Properties;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

public class PropertiesConverter
extends AbstractConfigurationConverter {
    @Override
    public boolean canConvert(Class<?> type2) {
        return Properties.class.isAssignableFrom(type2);
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration2, Class<?> type2, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Object value2 = this.fromExpression(configuration2, evaluator, type2);
        if (value2 != null) {
            return value2;
        }
        try {
            Properties properties2 = this.instantiateProperties(configuration2, type2, loader);
            int i = 0;
            int size = configuration2.getChildCount();
            while (i < size) {
                PlexusConfiguration element = configuration2.getChild(i);
                if ("property".equals(element.getName()) && element.getChildCount() > 0) {
                    Object name2 = this.fromExpression(element.getChild("name"), evaluator);
                    this.setProperty(properties2, name2, element.getChild("value"), evaluator);
                } else if (element.getChildCount() == 0) {
                    this.setProperty(properties2, element.getName(), element, evaluator);
                }
                ++i;
            }
            return properties2;
        }
        catch (ComponentConfigurationException e) {
            if (e.getFailedConfiguration() == null) {
                e.setFailedConfiguration(configuration2);
            }
            throw e;
        }
    }

    private Properties instantiateProperties(PlexusConfiguration configuration2, Class<?> type2, ClassLoader loader) throws ComponentConfigurationException {
        Class<?> implType = this.getClassForImplementationHint(type2, configuration2, loader);
        if (implType == null || Modifier.isAbstract(implType.getModifiers())) {
            return new Properties();
        }
        Object impl = this.instantiateObject(implType);
        this.failIfNotTypeCompatible(impl, type2, configuration2);
        return (Properties)impl;
    }

    private void setProperty(Properties properties2, Object name2, PlexusConfiguration valueConfiguration, ExpressionEvaluator evaluator) throws ComponentConfigurationException {
        String key;
        String string2 = key = name2 != null ? name2.toString() : null;
        if (key == null) {
            throw new ComponentConfigurationException("Missing name in properties");
        }
        Object value2 = this.fromExpression(valueConfiguration, evaluator);
        properties2.setProperty(key, value2 != null ? value2.toString() : "");
    }
}

