/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeployResult;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.DependencyCollector;
import org.eclipse.aether.impl.Deployer;
import org.eclipse.aether.impl.Installer;
import org.eclipse.aether.impl.LocalRepositoryProvider;
import org.eclipse.aether.impl.MetadataResolver;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.SyncContextFactory;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallResult;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.internal.impl.ArtifactRequestBuilder;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.resolution.VersionRequest;
import org.eclipse.aether.resolution.VersionResolutionException;
import org.eclipse.aether.resolution.VersionResult;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.spi.log.NullLoggerFactory;
import org.eclipse.aether.util.graph.visitor.FilteringDependencyVisitor;
import org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
public class DefaultRepositorySystem
implements RepositorySystem,
Service {
    private Logger logger = NullLoggerFactory.LOGGER;
    private VersionResolver versionResolver;
    private VersionRangeResolver versionRangeResolver;
    private ArtifactResolver artifactResolver;
    private MetadataResolver metadataResolver;
    private ArtifactDescriptorReader artifactDescriptorReader;
    private DependencyCollector dependencyCollector;
    private Installer installer;
    private Deployer deployer;
    private LocalRepositoryProvider localRepositoryProvider;
    private SyncContextFactory syncContextFactory;
    private RemoteRepositoryManager remoteRepositoryManager;

    public DefaultRepositorySystem() {
    }

    @Inject
    DefaultRepositorySystem(VersionResolver versionResolver, VersionRangeResolver versionRangeResolver, ArtifactResolver artifactResolver, MetadataResolver metadataResolver, ArtifactDescriptorReader artifactDescriptorReader, DependencyCollector dependencyCollector, Installer installer, Deployer deployer, LocalRepositoryProvider localRepositoryProvider, SyncContextFactory syncContextFactory, RemoteRepositoryManager remoteRepositoryManager, LoggerFactory loggerFactory) {
        this.setVersionResolver(versionResolver);
        this.setVersionRangeResolver(versionRangeResolver);
        this.setArtifactResolver(artifactResolver);
        this.setMetadataResolver(metadataResolver);
        this.setArtifactDescriptorReader(artifactDescriptorReader);
        this.setDependencyCollector(dependencyCollector);
        this.setInstaller(installer);
        this.setDeployer(deployer);
        this.setLocalRepositoryProvider(localRepositoryProvider);
        this.setSyncContextFactory(syncContextFactory);
        this.setRemoteRepositoryManager(remoteRepositoryManager);
        this.setLoggerFactory(loggerFactory);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
        this.setVersionResolver(locator.getService(VersionResolver.class));
        this.setVersionRangeResolver(locator.getService(VersionRangeResolver.class));
        this.setArtifactResolver(locator.getService(ArtifactResolver.class));
        this.setMetadataResolver(locator.getService(MetadataResolver.class));
        this.setArtifactDescriptorReader(locator.getService(ArtifactDescriptorReader.class));
        this.setDependencyCollector(locator.getService(DependencyCollector.class));
        this.setInstaller(locator.getService(Installer.class));
        this.setDeployer(locator.getService(Deployer.class));
        this.setLocalRepositoryProvider(locator.getService(LocalRepositoryProvider.class));
        this.setRemoteRepositoryManager(locator.getService(RemoteRepositoryManager.class));
        this.setSyncContextFactory(locator.getService(SyncContextFactory.class));
    }

    public DefaultRepositorySystem setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, this.getClass());
        return this;
    }

    public DefaultRepositorySystem setVersionResolver(VersionResolver versionResolver) {
        if (versionResolver == null) {
            throw new IllegalArgumentException("version resolver has not been specified");
        }
        this.versionResolver = versionResolver;
        return this;
    }

    public DefaultRepositorySystem setVersionRangeResolver(VersionRangeResolver versionRangeResolver) {
        if (versionRangeResolver == null) {
            throw new IllegalArgumentException("version range resolver has not been specified");
        }
        this.versionRangeResolver = versionRangeResolver;
        return this;
    }

    public DefaultRepositorySystem setArtifactResolver(ArtifactResolver artifactResolver) {
        if (artifactResolver == null) {
            throw new IllegalArgumentException("artifact resolver has not been specified");
        }
        this.artifactResolver = artifactResolver;
        return this;
    }

    public DefaultRepositorySystem setMetadataResolver(MetadataResolver metadataResolver) {
        if (metadataResolver == null) {
            throw new IllegalArgumentException("metadata resolver has not been specified");
        }
        this.metadataResolver = metadataResolver;
        return this;
    }

    public DefaultRepositorySystem setArtifactDescriptorReader(ArtifactDescriptorReader artifactDescriptorReader) {
        if (artifactDescriptorReader == null) {
            throw new IllegalArgumentException("artifact descriptor reader has not been specified");
        }
        this.artifactDescriptorReader = artifactDescriptorReader;
        return this;
    }

    public DefaultRepositorySystem setDependencyCollector(DependencyCollector dependencyCollector) {
        if (dependencyCollector == null) {
            throw new IllegalArgumentException("dependency collector has not been specified");
        }
        this.dependencyCollector = dependencyCollector;
        return this;
    }

    public DefaultRepositorySystem setInstaller(Installer installer) {
        if (installer == null) {
            throw new IllegalArgumentException("installer has not been specified");
        }
        this.installer = installer;
        return this;
    }

    public DefaultRepositorySystem setDeployer(Deployer deployer) {
        if (deployer == null) {
            throw new IllegalArgumentException("deployer has not been specified");
        }
        this.deployer = deployer;
        return this;
    }

    public DefaultRepositorySystem setLocalRepositoryProvider(LocalRepositoryProvider localRepositoryProvider) {
        if (localRepositoryProvider == null) {
            throw new IllegalArgumentException("local repository provider has not been specified");
        }
        this.localRepositoryProvider = localRepositoryProvider;
        return this;
    }

    public DefaultRepositorySystem setSyncContextFactory(SyncContextFactory syncContextFactory) {
        if (syncContextFactory == null) {
            throw new IllegalArgumentException("sync context factory has not been specified");
        }
        this.syncContextFactory = syncContextFactory;
        return this;
    }

    public DefaultRepositorySystem setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        if (remoteRepositoryManager == null) {
            throw new IllegalArgumentException("remote repository manager has not been specified");
        }
        this.remoteRepositoryManager = remoteRepositoryManager;
        return this;
    }

    @Override
    public VersionResult resolveVersion(RepositorySystemSession session2, VersionRequest request) throws VersionResolutionException {
        this.validateSession(session2);
        return this.versionResolver.resolveVersion(session2, request);
    }

    @Override
    public VersionRangeResult resolveVersionRange(RepositorySystemSession session2, VersionRangeRequest request) throws VersionRangeResolutionException {
        this.validateSession(session2);
        return this.versionRangeResolver.resolveVersionRange(session2, request);
    }

    @Override
    public ArtifactDescriptorResult readArtifactDescriptor(RepositorySystemSession session2, ArtifactDescriptorRequest request) throws ArtifactDescriptorException {
        this.validateSession(session2);
        return this.artifactDescriptorReader.readArtifactDescriptor(session2, request);
    }

    @Override
    public ArtifactResult resolveArtifact(RepositorySystemSession session2, ArtifactRequest request) throws ArtifactResolutionException {
        this.validateSession(session2);
        return this.artifactResolver.resolveArtifact(session2, request);
    }

    @Override
    public List<ArtifactResult> resolveArtifacts(RepositorySystemSession session2, Collection<? extends ArtifactRequest> requests) throws ArtifactResolutionException {
        this.validateSession(session2);
        return this.artifactResolver.resolveArtifacts(session2, requests);
    }

    @Override
    public List<MetadataResult> resolveMetadata(RepositorySystemSession session2, Collection<? extends MetadataRequest> requests) {
        this.validateSession(session2);
        return this.metadataResolver.resolveMetadata(session2, requests);
    }

    @Override
    public CollectResult collectDependencies(RepositorySystemSession session2, CollectRequest request) throws DependencyCollectionException {
        this.validateSession(session2);
        return this.dependencyCollector.collectDependencies(session2, request);
    }

    @Override
    public DependencyResult resolveDependencies(RepositorySystemSession session2, DependencyRequest request) throws DependencyResolutionException {
        this.validateSession(session2);
        RequestTrace trace = RequestTrace.newChild(request.getTrace(), request);
        DependencyResult result2 = new DependencyResult(request);
        DependencyCollectionException dce = null;
        ArtifactResolutionException are = null;
        if (request.getRoot() != null) {
            result2.setRoot(request.getRoot());
        } else if (request.getCollectRequest() != null) {
            CollectResult collectResult;
            try {
                request.getCollectRequest().setTrace(trace);
                collectResult = this.dependencyCollector.collectDependencies(session2, request.getCollectRequest());
            }
            catch (DependencyCollectionException e) {
                dce = e;
                collectResult = e.getResult();
            }
            if (collectResult != null) {
                result2.setRoot(collectResult.getRoot());
                result2.setCycles(collectResult.getCycles());
                result2.setCollectExceptions(collectResult.getExceptions());
            }
        } else {
            throw new IllegalArgumentException("dependency node or collect request missing");
        }
        if (result2.getRoot() != null) {
            List<ArtifactResult> results;
            ArtifactRequestBuilder builder2 = new ArtifactRequestBuilder(trace);
            DependencyFilter filter2 = request.getFilter();
            DependencyVisitor visitor2 = filter2 != null ? new FilteringDependencyVisitor(builder2, filter2) : builder2;
            visitor2 = new TreeDependencyVisitor(visitor2);
            result2.getRoot().accept(visitor2);
            try {
                List<ArtifactRequest> requests = builder2.getRequests();
                results = this.artifactResolver.resolveArtifacts(session2, requests);
            }
            catch (ArtifactResolutionException e) {
                are = e;
                results = e.getResults();
            }
            result2.setArtifactResults(results);
            this.updateNodesWithResolvedArtifacts(results);
        }
        if (dce != null) {
            throw new DependencyResolutionException(result2, (Throwable)dce);
        }
        if (are != null) {
            throw new DependencyResolutionException(result2, are);
        }
        return result2;
    }

    private void updateNodesWithResolvedArtifacts(List<ArtifactResult> results) {
        for (ArtifactResult result2 : results) {
            Artifact artifact = result2.getArtifact();
            if (artifact == null) continue;
            result2.getRequest().getDependencyNode().setArtifact(artifact);
        }
    }

    @Override
    public InstallResult install(RepositorySystemSession session2, InstallRequest request) throws InstallationException {
        this.validateSession(session2);
        return this.installer.install(session2, request);
    }

    @Override
    public DeployResult deploy(RepositorySystemSession session2, DeployRequest request) throws DeploymentException {
        this.validateSession(session2);
        return this.deployer.deploy(session2, request);
    }

    @Override
    public LocalRepositoryManager newLocalRepositoryManager(RepositorySystemSession session2, LocalRepository localRepository) {
        try {
            return this.localRepositoryProvider.newLocalRepositoryManager(session2, localRepository);
        }
        catch (NoLocalRepositoryManagerException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public SyncContext newSyncContext(RepositorySystemSession session2, boolean shared) {
        this.validateSession(session2);
        return this.syncContextFactory.newInstance(session2, shared);
    }

    @Override
    public List<RemoteRepository> newResolutionRepositories(RepositorySystemSession session2, List<RemoteRepository> repositories) {
        this.validateSession(session2);
        repositories = this.remoteRepositoryManager.aggregateRepositories(session2, new ArrayList<RemoteRepository>(), repositories, true);
        return repositories;
    }

    @Override
    public RemoteRepository newDeploymentRepository(RepositorySystemSession session2, RemoteRepository repository) {
        this.validateSession(session2);
        RemoteRepository.Builder builder2 = new RemoteRepository.Builder(repository);
        Authentication auth = session2.getAuthenticationSelector().getAuthentication(repository);
        builder2.setAuthentication(auth);
        Proxy proxy2 = session2.getProxySelector().getProxy(repository);
        builder2.setProxy(proxy2);
        return builder2.build();
    }

    private void validateSession(RepositorySystemSession session2) {
        if (session2 == null) {
            throw new IllegalArgumentException("Invalid repository system session: the session may not be null.");
        }
        if (session2.getLocalRepositoryManager() == null) {
            this.invalidSession("LocalRepositoryManager");
        }
        if (session2.getSystemProperties() == null) {
            this.invalidSession("SystemProperties");
        }
        if (session2.getUserProperties() == null) {
            this.invalidSession("UserProperties");
        }
        if (session2.getConfigProperties() == null) {
            this.invalidSession("ConfigProperties");
        }
        if (session2.getMirrorSelector() == null) {
            this.invalidSession("MirrorSelector");
        }
        if (session2.getProxySelector() == null) {
            this.invalidSession("ProxySelector");
        }
        if (session2.getAuthenticationSelector() == null) {
            this.invalidSession("AuthenticationSelector");
        }
        if (session2.getArtifactTypeRegistry() == null) {
            this.invalidSession("ArtifactTypeRegistry");
        }
        if (session2.getData() == null) {
            this.invalidSession("Data");
        }
    }

    private void invalidSession(String name2) {
        throw new IllegalArgumentException("Invalid repository system session: " + name2 + " is not set.");
    }
}

