/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transfer;

import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.repository.RemoteRepository;

public class NoRepositoryConnectorException
extends RepositoryException {
    private final transient RemoteRepository repository;

    public NoRepositoryConnectorException(RemoteRepository repository) {
        this(repository, NoRepositoryConnectorException.toMessage(repository));
    }

    public NoRepositoryConnectorException(RemoteRepository repository, String message2) {
        super(message2);
        this.repository = repository;
    }

    public NoRepositoryConnectorException(RemoteRepository repository, Throwable cause) {
        this(repository, NoRepositoryConnectorException.toMessage(repository), cause);
    }

    public NoRepositoryConnectorException(RemoteRepository repository, String message2, Throwable cause) {
        super(message2, cause);
        this.repository = repository;
    }

    private static String toMessage(RemoteRepository repository) {
        if (repository != null) {
            return "No connector available to access repository " + repository.getId() + " (" + repository.getUrl() + ") of type " + repository.getContentType();
        }
        return "No connector available to access repository";
    }

    public RemoteRepository getRepository() {
        return this.repository;
    }
}

