/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.params.AuthParams;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.params.ConnRouteParams;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DecompressingHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.cookie.DateUtils;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.transport.AbstractTransporter;
import org.eclipse.aether.spi.connector.transport.GetTask;
import org.eclipse.aether.spi.connector.transport.PeekTask;
import org.eclipse.aether.spi.connector.transport.PutTask;
import org.eclipse.aether.spi.connector.transport.TransportTask;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.transfer.NoTransporterException;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transport.http.DeferredCredentialsProvider;
import org.eclipse.aether.transport.http.DemuxCredentialsProvider;
import org.eclipse.aether.transport.http.HttpMkCol;
import org.eclipse.aether.transport.http.LocalState;
import org.eclipse.aether.transport.http.SharingHttpContext;
import org.eclipse.aether.transport.http.SslConfig;
import org.eclipse.aether.transport.http.UriUtils;
import org.eclipse.aether.util.ConfigUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HttpTransporter
extends AbstractTransporter {
    private static final Pattern CONTENT_RANGE_PATTERN = Pattern.compile("\\s*bytes\\s+([0-9]+)\\s*-\\s*([0-9]+)\\s*/.*");
    private static final Pattern HOST_SPLIT_PATTERN = Pattern.compile("\\s*[,]\\s*");
    private final Logger logger;
    private final AuthenticationContext repoAuthContext;
    private final AuthenticationContext proxyAuthContext;
    private final URI baseUri;
    private final HttpHost server;
    private final HttpHost proxy;
    private final HttpClient client;
    private final Map<?, ?> headers;
    private final LocalState state;

    public HttpTransporter(RemoteRepository repository, RepositorySystemSession session2, Logger logger) throws NoTransporterException {
        if (!"http".equalsIgnoreCase(repository.getProtocol()) && !"https".equalsIgnoreCase(repository.getProtocol())) {
            throw new NoTransporterException(repository);
        }
        this.logger = logger;
        try {
            this.baseUri = new URI(repository.getUrl()).parseServerAuthority();
            if (this.baseUri.isOpaque()) {
                throw new URISyntaxException(repository.getUrl(), "URL must not be opaque");
            }
            this.server = URIUtils.extractHost(this.baseUri);
            if (this.server == null) {
                throw new URISyntaxException(repository.getUrl(), "URL lacks host name");
            }
        }
        catch (URISyntaxException e) {
            throw new NoTransporterException(repository, e.getMessage(), e);
        }
        this.proxy = HttpTransporter.toHost(repository.getProxy());
        this.repoAuthContext = AuthenticationContext.forRepository(session2, repository);
        this.proxyAuthContext = AuthenticationContext.forProxy(session2, repository);
        this.state = new LocalState(session2, repository, new SslConfig(session2, this.repoAuthContext));
        this.headers = ConfigUtils.getMap(session2, Collections.emptyMap(), "aether.connector.http.headers." + repository.getId(), "aether.connector.http.headers");
        DefaultHttpClient client = new DefaultHttpClient(this.state.getConnectionManager());
        HttpTransporter.configureClient(client.getParams(), session2, repository, this.proxy);
        boolean redirectedAuth = HttpTransporter.getRedirectedAuth(session2, repository, this.server);
        client.setCredentialsProvider(HttpTransporter.toCredentials(this.server, this.repoAuthContext, redirectedAuth, this.proxy, this.proxyAuthContext));
        this.client = new DecompressingHttpClient(client);
    }

    private static HttpHost toHost(Proxy proxy2) {
        HttpHost host = null;
        if (proxy2 != null) {
            host = new HttpHost(proxy2.getHost(), proxy2.getPort());
        }
        return host;
    }

    private static void configureClient(HttpParams params, RepositorySystemSession session2, RemoteRepository repository, HttpHost proxy2) {
        AuthParams.setCredentialCharset(params, ConfigUtils.getString(session2, "ISO-8859-1", "aether.connector.http.credentialEncoding." + repository.getId(), "aether.connector.http.credentialEncoding"));
        ConnRouteParams.setDefaultProxy(params, proxy2);
        HttpConnectionParams.setConnectionTimeout(params, ConfigUtils.getInteger(session2, 10000, "aether.connector.connectTimeout." + repository.getId(), "aether.connector.connectTimeout"));
        HttpConnectionParams.setSoTimeout(params, ConfigUtils.getInteger(session2, 1800000, "aether.connector.requestTimeout." + repository.getId(), "aether.connector.requestTimeout"));
        HttpProtocolParams.setUserAgent(params, ConfigUtils.getString(session2, "Aether", "aether.connector.userAgent"));
    }

    private static boolean getRedirectedAuth(RepositorySystemSession session2, RemoteRepository repo, HttpHost server) {
        String mode = ConfigUtils.getString(session2, "false", "aether.connector.http.redirectedAuthentication." + repo.getId(), "aether.connector.http.redirectedAuthentication");
        if ("false".equalsIgnoreCase(mode)) {
            return false;
        }
        if ("true".equalsIgnoreCase(mode)) {
            return true;
        }
        String host = server.getHostName();
        for (String allowed : HOST_SPLIT_PATTERN.split(mode.trim())) {
            if (!allowed.equalsIgnoreCase(host)) continue;
            return true;
        }
        return false;
    }

    private static CredentialsProvider toCredentials(HttpHost server, AuthenticationContext serverAuthCtx, boolean redirectedAuth, HttpHost proxy2, AuthenticationContext proxyAuthCtx) {
        CredentialsProvider provider = HttpTransporter.toCredentials(redirectedAuth ? AuthScope.ANY_HOST : server.getHostName(), -1, serverAuthCtx);
        if (proxy2 != null) {
            CredentialsProvider p = HttpTransporter.toCredentials(proxy2.getHostName(), proxy2.getPort(), proxyAuthCtx);
            provider = new DemuxCredentialsProvider(provider, p, proxy2);
        }
        return provider;
    }

    private static CredentialsProvider toCredentials(String host, int port, AuthenticationContext ctx) {
        DeferredCredentialsProvider provider = new DeferredCredentialsProvider();
        if (ctx != null) {
            AuthScope basicScope = new AuthScope(host, port);
            provider.setCredentials(basicScope, new DeferredCredentialsProvider.BasicFactory(ctx));
            AuthScope ntlmScope = new AuthScope(host, port, AuthScope.ANY_REALM, "ntlm");
            provider.setCredentials(ntlmScope, new DeferredCredentialsProvider.NtlmFactory(ctx));
        }
        return provider;
    }

    LocalState getState() {
        return this.state;
    }

    private URI resolve(TransportTask task) {
        return UriUtils.resolve(this.baseUri, task.getLocation());
    }

    @Override
    public int classify(Throwable error) {
        if (error instanceof HttpResponseException && ((HttpResponseException)error).getStatusCode() == 404) {
            return 1;
        }
        return 0;
    }

    @Override
    protected void implPeek(PeekTask task) throws Exception {
        HttpHead request = this.commonHeaders(new HttpHead(this.resolve(task)));
        this.execute(request, null);
    }

    @Override
    protected void implGet(GetTask task) throws Exception {
        EntityGetter getter2 = new EntityGetter(task);
        HttpGet request = this.commonHeaders(new HttpGet(this.resolve(task)));
        this.resume(request, task);
        try {
            this.execute(request, getter2);
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 412 && request.containsHeader("Range")) {
                request = this.commonHeaders(new HttpGet(request.getURI()));
                this.execute(request, getter2);
                return;
            }
            throw e;
        }
    }

    @Override
    protected void implPut(PutTask task) throws Exception {
        PutTaskEntity entity = new PutTaskEntity(task);
        HttpPut request = (HttpPut)this.commonHeaders((HttpUriRequest)this.entity(new HttpPut(this.resolve(task)), entity));
        try {
            this.execute(request, null);
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 417 && request.containsHeader("Expect")) {
                this.state.setExpectContinue(false);
                request = (HttpPut)this.commonHeaders((HttpUriRequest)this.entity(new HttpPut(request.getURI()), entity));
                this.execute(request, null);
                return;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(HttpUriRequest request, EntityGetter getter2) throws Exception {
        try {
            SharingHttpContext context2 = new SharingHttpContext(this.state);
            this.prepare(request, context2);
            HttpResponse response = this.client.execute(this.server, (HttpRequest)request, (HttpContext)context2);
            try {
                context2.close();
                this.handleStatus(response);
                if (getter2 != null) {
                    getter2.handle(response);
                }
            }
            finally {
                EntityUtils.consumeQuietly(response.getEntity());
            }
        }
        catch (IOException e) {
            if (e.getCause() instanceof TransferCancelledException) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepare(HttpUriRequest request, SharingHttpContext context2) {
        boolean put2 = "PUT".equalsIgnoreCase(request.getMethod());
        if ((put2 || this.isPayloadPresent(request)) && !this.state.isProbed()) {
            LocalState localState = this.state;
            synchronized (localState) {
                if (!this.state.isProbed()) {
                    this.probe(request, context2);
                    this.state.setProbed();
                }
            }
        }
        if (put2 && this.state.isWebDav()) {
            this.mkdirs(request.getURI(), context2);
        }
    }

    private void probe(HttpUriRequest request, SharingHttpContext context2) {
        try {
            HttpOptions req = this.commonHeaders(new HttpOptions(request.getURI()));
            HttpResponse response = this.client.execute(this.server, (HttpRequest)req, (HttpContext)context2);
            this.state.setWebDav(this.isWebDav(response));
            EntityUtils.consumeQuietly(response.getEntity());
        }
        catch (IOException e) {
            this.logger.debug("Failed to probe HTTP server", e);
        }
    }

    private boolean isWebDav(HttpResponse response) {
        return response.containsHeader("Dav") && !this.isWebDavOptional(response);
    }

    private boolean isWebDavOptional(HttpResponse response) {
        Header header = response.getFirstHeader("Server");
        String server = header != null ? header.getValue() : null;
        return server != null && (server.startsWith("Artifactory/") || server.startsWith("Nexus/"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mkdirs(URI uri, SharingHttpContext context2) {
        HttpResponse response;
        int index2;
        List<URI> dirs = UriUtils.getDirectories(this.baseUri, uri);
        for (index2 = 0; index2 < dirs.size(); ++index2) {
            try {
                response = this.client.execute(this.server, (HttpRequest)this.commonHeaders(new HttpMkCol(dirs.get(index2))), (HttpContext)context2);
                try {
                    int status2 = response.getStatusLine().getStatusCode();
                    if (status2 < 300 || status2 == 405) break;
                    if (status2 == 409) continue;
                    this.handleStatus(response);
                    continue;
                }
                finally {
                    EntityUtils.consumeQuietly(response.getEntity());
                }
            }
            catch (IOException e) {
                this.logger.debug("Failed to create parent directory " + dirs.get(index2), e);
                return;
            }
        }
        --index2;
        while (index2 >= 0) {
            try {
                response = this.client.execute(this.server, (HttpRequest)this.commonHeaders(new HttpMkCol(dirs.get(index2))), (HttpContext)context2);
                try {
                    this.handleStatus(response);
                }
                finally {
                    EntityUtils.consumeQuietly(response.getEntity());
                }
            }
            catch (IOException e) {
                this.logger.debug("Failed to create parent directory " + dirs.get(index2), e);
                return;
            }
            --index2;
        }
    }

    private <T extends HttpEntityEnclosingRequest> T entity(T request, HttpEntity entity) {
        request.setEntity(entity);
        return request;
    }

    private boolean isPayloadPresent(HttpUriRequest request) {
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntity entity = ((HttpEntityEnclosingRequest)((Object)request)).getEntity();
            return entity != null && entity.getContentLength() != 0L;
        }
        return false;
    }

    private <T extends HttpUriRequest> T commonHeaders(T request) {
        request.setHeader("Cache-Control", "no-cache, no-store");
        request.setHeader("Pragma", "no-cache");
        if (this.state.isExpectContinue() && this.isPayloadPresent(request)) {
            request.setHeader("Expect", "100-continue");
        }
        for (Map.Entry<?, ?> entry : this.headers.entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            if (entry.getValue() instanceof String) {
                request.setHeader(entry.getKey().toString(), entry.getValue().toString());
                continue;
            }
            request.removeHeaders(entry.getKey().toString());
        }
        if (!this.state.isExpectContinue()) {
            request.removeHeaders("Expect");
        }
        return request;
    }

    private <T extends HttpUriRequest> T resume(T request, GetTask task) {
        long resumeOffset = task.getResumeOffset();
        if (resumeOffset > 0L && task.getDataFile() != null) {
            request.setHeader("Range", "bytes=" + Long.toString(resumeOffset) + '-');
            request.setHeader("If-Unmodified-Since", DateUtils.formatDate(new Date(task.getDataFile().lastModified() - 60000L)));
            request.setHeader("Accept-Encoding", "identity");
        }
        return request;
    }

    private void handleStatus(HttpResponse response) throws HttpResponseException {
        int status2 = response.getStatusLine().getStatusCode();
        if (status2 >= 300) {
            throw new HttpResponseException(status2, response.getStatusLine().getReasonPhrase() + " (" + status2 + ")");
        }
    }

    @Override
    protected void implClose() {
        AuthenticationContext.close(this.repoAuthContext);
        AuthenticationContext.close(this.proxyAuthContext);
        this.state.close();
    }

    private class PutTaskEntity
    extends AbstractHttpEntity {
        private final PutTask task;

        public PutTaskEntity(PutTask task) {
            this.task = task;
        }

        public boolean isRepeatable() {
            return true;
        }

        public boolean isStreaming() {
            return false;
        }

        public long getContentLength() {
            return this.task.getDataLength();
        }

        public InputStream getContent() throws IOException {
            return this.task.newInputStream();
        }

        public void writeTo(OutputStream os) throws IOException {
            try {
                HttpTransporter.this.utilPut(this.task, os, false);
            }
            catch (TransferCancelledException e) {
                throw (IOException)new InterruptedIOException().initCause(e);
            }
        }
    }

    private class EntityGetter {
        private final GetTask task;

        public EntityGetter(GetTask task) {
            this.task = task;
        }

        public void handle(HttpResponse response) throws IOException, TransferCancelledException {
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                entity = new ByteArrayEntity(new byte[0]);
            }
            long offset2 = 0L;
            long length = entity.getContentLength();
            String range = this.getHeader(response, "Content-Range");
            if (range != null) {
                Matcher m = CONTENT_RANGE_PATTERN.matcher(range);
                if (!m.matches()) {
                    throw new IOException("Invalid Content-Range header for partial download: " + range);
                }
                offset2 = Long.parseLong(m.group(1));
                length = Long.parseLong(m.group(2)) + 1L;
                if (offset2 < 0L || offset2 >= length || offset2 > 0L && offset2 != this.task.getResumeOffset()) {
                    throw new IOException("Invalid Content-Range header for partial download from offset " + this.task.getResumeOffset() + ": " + range);
                }
            }
            InputStream is = entity.getContent();
            HttpTransporter.this.utilGet(this.task, is, true, length, offset2 > 0L);
            this.extractChecksums(response);
        }

        private void extractChecksums(HttpResponse response) {
            String etag = this.getHeader(response, "ETag");
            if (etag != null) {
                int start = etag.indexOf("SHA1{");
                int end = etag.indexOf("}", start + 5);
                if (start >= 0 && end > start) {
                    this.task.setChecksum("SHA-1", etag.substring(start + 5, end));
                }
            }
        }

        private String getHeader(HttpResponse response, String name2) {
            Header header = response.getFirstHeader(name2);
            return header != null ? header.getValue() : null;
        }
    }
}

