/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.RemoteRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultMirrorSelector
implements MirrorSelector {
    private static final String WILDCARD = "*";
    private static final String EXTERNAL_WILDCARD = "external:*";
    private final List<MirrorDef> mirrors = new ArrayList<MirrorDef>();

    public DefaultMirrorSelector add(String id, String url, String type2, boolean repositoryManager, String mirrorOfIds, String mirrorOfTypes) {
        return this.add(id, url, type2, repositoryManager, DefaultMirrorSelector.split(mirrorOfIds), DefaultMirrorSelector.split(mirrorOfTypes));
    }

    public DefaultMirrorSelector add(String id, String url, String type2, boolean repositoryManager, Collection<String> mirrorOfIds, Collection<String> mirrorOfTypes) {
        this.mirrors.add(new MirrorDef(id, url, type2, repositoryManager, mirrorOfIds, mirrorOfTypes));
        return this;
    }

    @Override
    public RemoteRepository getMirror(RemoteRepository repository) {
        MirrorDef mirror = this.findMirror(repository);
        if (mirror == null) {
            return null;
        }
        RemoteRepository.Builder builder2 = new RemoteRepository.Builder(mirror.id, repository.getContentType(), mirror.url);
        builder2.setRepositoryManager(mirror.repositoryManager);
        if (mirror.type != null && mirror.type.length() > 0) {
            builder2.setContentType(mirror.type);
        }
        builder2.setSnapshotPolicy(repository.getPolicy(true));
        builder2.setReleasePolicy(repository.getPolicy(false));
        builder2.setMirroredRepositories(Collections.singletonList(repository));
        return builder2.build();
    }

    private MirrorDef findMirror(RemoteRepository repository) {
        if (!this.mirrors.isEmpty()) {
            String repoId = repository.getId();
            String repoType = repository.getContentType();
            for (MirrorDef mirror : this.mirrors) {
                if (!mirror.idMatcher.isExactMatch(repoId) || !mirror.typeMatcher.isMatch(repoType)) continue;
                return mirror;
            }
            for (MirrorDef mirror : this.mirrors) {
                if (!mirror.idMatcher.isMatch(repository) || !mirror.typeMatcher.isMatch(repoType)) continue;
                return mirror;
            }
        }
        return null;
    }

    static List<String> split(String list2) {
        List<String> tokens = null;
        if (list2 != null) {
            tokens = Arrays.asList(list2.trim().split("\\s*,\\s*"));
        }
        return tokens;
    }

    static String[] clean(Collection<String> tokens) {
        ArrayList<String> cleaned = new ArrayList<String>();
        if (tokens != null) {
            for (String token : tokens) {
                if (token == null || token.length() <= 0) continue;
                cleaned.add(token);
            }
        }
        return cleaned.toArray(new String[cleaned.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class MirrorDef {
        final String id;
        final String url;
        final String type;
        final boolean repositoryManager;
        final IdMatcher idMatcher;
        final TypeMatcher typeMatcher;

        public MirrorDef(String id, String url, String type2, boolean repositoryManager, Collection<String> mirrorOfIds, Collection<String> mirrorOfTypes) {
            this.id = id;
            this.url = url;
            this.type = type2;
            this.repositoryManager = repositoryManager;
            this.idMatcher = new IdMatcher(mirrorOfIds);
            this.typeMatcher = new TypeMatcher(mirrorOfTypes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TypeMatcher {
        final String[] mirrorOfTypes;

        public TypeMatcher(Collection<String> mirrorOfTypes) {
            this.mirrorOfTypes = DefaultMirrorSelector.clean(mirrorOfTypes);
        }

        boolean isMatch(String repoType) {
            boolean result2 = false;
            if (this.mirrorOfTypes.length <= 0) {
                result2 = true;
            } else {
                for (String mirrorOfType : this.mirrorOfTypes) {
                    if (mirrorOfType.equals(repoType)) {
                        result2 = true;
                        break;
                    }
                    if (mirrorOfType.startsWith("!") && mirrorOfType.substring(1).equals(repoType)) {
                        result2 = false;
                        break;
                    }
                    if (!DefaultMirrorSelector.WILDCARD.equals(mirrorOfType)) continue;
                    result2 = true;
                }
            }
            return result2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class IdMatcher {
        final String[] mirrorOfIds;

        public IdMatcher(Collection<String> mirrorOfIds) {
            this.mirrorOfIds = DefaultMirrorSelector.clean(mirrorOfIds);
        }

        boolean isExactMatch(String repoId) {
            return this.mirrorOfIds.length == 1 && this.mirrorOfIds[0].equals(repoId);
        }

        boolean isMatch(RemoteRepository repository) {
            boolean result2 = false;
            if (this.mirrorOfIds.length <= 0) {
                result2 = false;
            } else {
                String repoId = repository.getId();
                for (String mirrorOfId : this.mirrorOfIds) {
                    if (mirrorOfId.equals(repoId)) {
                        result2 = true;
                        break;
                    }
                    if (mirrorOfId.startsWith("!") && mirrorOfId.substring(1).equals(repoId)) {
                        result2 = false;
                        break;
                    }
                    if (DefaultMirrorSelector.EXTERNAL_WILDCARD.equals(mirrorOfId) && IdMatcher.isExternalRepo(repository)) {
                        result2 = true;
                        continue;
                    }
                    if (!DefaultMirrorSelector.WILDCARD.equals(mirrorOfId)) continue;
                    result2 = true;
                }
            }
            return result2;
        }

        static boolean isExternalRepo(RemoteRepository repository) {
            boolean local2 = "localhost".equals(repository.getHost()) || "127.0.0.1".equals(repository.getHost()) || "file".equalsIgnoreCase(repository.getProtocol());
            return !local2;
        }
    }
}

