/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultProxySelector
implements ProxySelector {
    private List<ProxyDef> proxies = new ArrayList<ProxyDef>();

    public DefaultProxySelector add(Proxy proxy2, String nonProxyHosts) {
        return this.add(proxy2, NonProxyHosts.split(nonProxyHosts));
    }

    public DefaultProxySelector add(Proxy proxy2, Collection<String> nonProxyHosts) {
        if (proxy2 == null) {
            throw new IllegalArgumentException("proxy not specified");
        }
        this.proxies.add(new ProxyDef(proxy2, nonProxyHosts));
        return this;
    }

    @Override
    public Proxy getProxy(RemoteRepository repository) {
        ProxyDef proxy22;
        HashMap<String, ProxyDef> candidates2 = new HashMap<String, ProxyDef>();
        String host = repository.getHost();
        for (ProxyDef proxy22 : this.proxies) {
            String key;
            if (proxy22.nonProxyHosts.isNonProxyHost(host) || candidates2.containsKey(key = proxy22.proxy.getType().toLowerCase(Locale.ENGLISH))) continue;
            candidates2.put(key, proxy22);
        }
        String protocol = repository.getProtocol().toLowerCase(Locale.ENGLISH);
        if ("davs".equals(protocol)) {
            protocol = "https";
        } else if ("dav".equals(protocol)) {
            protocol = "http";
        } else if (protocol.startsWith("dav:")) {
            protocol = protocol.substring("dav:".length());
        }
        proxy22 = (ProxyDef)candidates2.get(protocol);
        if (proxy22 == null && "https".equals(protocol)) {
            proxy22 = (ProxyDef)candidates2.get("http");
        }
        return proxy22 != null ? proxy22.proxy : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ProxyDef {
        final Proxy proxy;
        final NonProxyHosts nonProxyHosts;

        public ProxyDef(Proxy proxy2, Collection<String> nonProxyHosts) {
            this.proxy = proxy2;
            this.nonProxyHosts = new NonProxyHosts(nonProxyHosts);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NonProxyHosts {
        private final Pattern[] patterns;

        public NonProxyHosts(Collection<String> nonProxyHosts) {
            ArrayList<Pattern> patterns2 = new ArrayList<Pattern>();
            if (nonProxyHosts != null) {
                for (String nonProxyHost : nonProxyHosts) {
                    if (nonProxyHost == null || nonProxyHost.length() <= 0) continue;
                    String pattern = nonProxyHost;
                    pattern = pattern.replace(".", "\\.").replace("*", ".*");
                    patterns2.add(Pattern.compile(pattern, 2));
                }
            }
            this.patterns = patterns2.toArray(new Pattern[patterns2.size()]);
        }

        static List<String> split(String nonProxyHosts) {
            List<String> hosts = null;
            if (nonProxyHosts != null) {
                hosts = Arrays.asList(nonProxyHosts.trim().split("\\s*[|,]\\s*"));
            }
            return hosts;
        }

        boolean isNonProxyHost(String host) {
            if (host != null) {
                for (Pattern pattern : this.patterns) {
                    if (!pattern.matcher(host).matches()) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

