/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import com.google.inject.spi.TypeEncounter;
import javax.inject.Provider;
import org.codehaus.plexus.component.annotations.Configuration;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.sisu.bean.BeanManager;
import org.eclipse.sisu.bean.BeanProperty;
import org.eclipse.sisu.bean.PropertyBinder;
import org.eclipse.sisu.bean.PropertyBinding;
import org.eclipse.sisu.plexus.OptionalPropertyBinding;
import org.eclipse.sisu.plexus.PlexusBeanMetadata;
import org.eclipse.sisu.plexus.PlexusConfigurations;
import org.eclipse.sisu.plexus.PlexusRequirements;
import org.eclipse.sisu.plexus.ProvidedPropertyBinding;

final class PlexusPropertyBinder
implements PropertyBinder {
    private static final boolean OPTIONAL_SUPPORTED;
    private final BeanManager manager;
    private final PlexusBeanMetadata metadata;
    private final PlexusConfigurations configurations;
    private final PlexusRequirements requirements;

    static {
        boolean optionalSupported = true;
        try {
            Requirement.class.getDeclaredMethod("optional", new Class[0]);
        }
        catch (Exception exception) {
            optionalSupported = false;
        }
        catch (LinkageError linkageError) {
            optionalSupported = false;
        }
        OPTIONAL_SUPPORTED = optionalSupported;
    }

    PlexusPropertyBinder(BeanManager manager, TypeEncounter<?> encounter, PlexusBeanMetadata metadata2) {
        this.manager = manager;
        this.metadata = metadata2;
        this.configurations = new PlexusConfigurations(encounter);
        this.requirements = new PlexusRequirements(encounter);
    }

    @Override
    public <T> PropertyBinding bindProperty(BeanProperty<T> property2) {
        if (this.metadata.isEmpty()) {
            return PropertyBinder.LAST_BINDING;
        }
        Configuration configuration2 = this.metadata.getConfiguration(property2);
        if (configuration2 != null) {
            Provider<T> valueProvider = this.configurations.lookup(configuration2, property2);
            return new ProvidedPropertyBinding<T>(property2, valueProvider);
        }
        Requirement requirement2 = this.metadata.getRequirement(property2);
        if (requirement2 != null) {
            PropertyBinding managedBinding;
            if (this.manager != null && (managedBinding = this.manager.manage(property2)) != null) {
                return managedBinding;
            }
            Provider<T> roleProvider = this.requirements.lookup(requirement2, property2);
            if (OPTIONAL_SUPPORTED && requirement2.optional()) {
                return new OptionalPropertyBinding<T>(property2, roleProvider);
            }
            return new ProvidedPropertyBinding<T>(property2, roleProvider);
        }
        return null;
    }
}

