/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.backend.common.FunctionsFromAnyGenerator;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0016\u0010\u0019\u001a\u00020\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u0010H\u0002J\u001e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u0010H$J\u0016\u0010\u001e\u001a\u00020\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u0010H\u0002J\u001e\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u0010H$J\u0016\u0010 \u001a\u00020\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u0010H\u0002J\u001e\u0010!\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u0010H$R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00108DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0013\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/backend/common/FunctionsFromAnyGenerator;", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getClassDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getDeclaration", "()Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "primaryConstructorParameters", "", "Lorg/jetbrains/kotlin/psi/KtParameter;", "getPrimaryConstructorParameters", "()Ljava/util/List;", "primaryConstructorProperties", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getPrimaryConstructorProperties", "generate", "", "generateEqualsIfNeeded", "properties", "generateEqualsMethod", "function", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "generateHashCodeIfNeeded", "generateHashCodeMethod", "generateToStringIfNeeded", "generateToStringMethod", "backend-common"})
public abstract class FunctionsFromAnyGenerator {
    @NotNull
    private final KtClassOrObject declaration;
    @NotNull
    private final BindingContext bindingContext;
    @NotNull
    private final ClassDescriptor classDescriptor;

    public FunctionsFromAnyGenerator(@NotNull KtClassOrObject declaration2, @NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        this.declaration = declaration2;
        this.bindingContext = bindingContext;
        Object v = BindingContextUtils.getNotNull(this.bindingContext, BindingContext.CLASS, this.declaration);
        Intrinsics.checkNotNullExpressionValue(v, "getNotNull(bindingContext, BindingContext.CLASS, declaration)");
        this.classDescriptor = (ClassDescriptor)v;
    }

    @NotNull
    protected final KtClassOrObject getDeclaration() {
        return this.declaration;
    }

    @NotNull
    protected final BindingContext getBindingContext() {
        return this.bindingContext;
    }

    @NotNull
    protected final ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    public void generate() {
        List<PropertyDescriptor> properties2 = this.getPrimaryConstructorProperties();
        Collection collection = properties2;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.generateToStringIfNeeded(properties2);
            this.generateHashCodeIfNeeded(properties2);
            this.generateEqualsIfNeeded(properties2);
        }
    }

    protected abstract void generateToStringMethod(@NotNull FunctionDescriptor var1, @NotNull List<? extends PropertyDescriptor> var2);

    protected abstract void generateHashCodeMethod(@NotNull FunctionDescriptor var1, @NotNull List<? extends PropertyDescriptor> var2);

    protected abstract void generateEqualsMethod(@NotNull FunctionDescriptor var1, @NotNull List<? extends PropertyDescriptor> var2);

    private final void generateToStringIfNeeded(List<? extends PropertyDescriptor> properties2) {
        FunctionDescriptor functionDescriptor = CodegenUtil.INSTANCE.getMemberToGenerate(this.classDescriptor, "toString", generateToStringIfNeeded.function.1.INSTANCE, generateToStringIfNeeded.function.2.INSTANCE);
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor function2 = functionDescriptor;
        this.generateToStringMethod(function2, properties2);
    }

    private final void generateHashCodeIfNeeded(List<? extends PropertyDescriptor> properties2) {
        FunctionDescriptor functionDescriptor = CodegenUtil.INSTANCE.getMemberToGenerate(this.classDescriptor, "hashCode", generateHashCodeIfNeeded.function.1.INSTANCE, generateHashCodeIfNeeded.function.2.INSTANCE);
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor function2 = functionDescriptor;
        this.generateHashCodeMethod(function2, properties2);
    }

    private final void generateEqualsIfNeeded(List<? extends PropertyDescriptor> properties2) {
        FunctionDescriptor functionDescriptor = CodegenUtil.INSTANCE.getMemberToGenerate(this.classDescriptor, "equals", generateEqualsIfNeeded.function.1.INSTANCE, generateEqualsIfNeeded.function.2.INSTANCE);
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor function2 = functionDescriptor;
        this.generateEqualsMethod(function2, properties2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<PropertyDescriptor> getPrimaryConstructorProperties() {
        void $this$mapTo$iv$iv;
        KtParameter it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getPrimaryConstructorParameters();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (KtParameter)element$iv$iv;
            boolean bl = false;
            if (!it.hasValOrVar()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (KtParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.getBindingContext().get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, it);
            Intrinsics.checkNotNull(propertyDescriptor);
            PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
            collection.add(propertyDescriptor2);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected final List<KtParameter> getPrimaryConstructorParameters() {
        KtClassOrObject ktClassOrObject = this.declaration;
        List list2 = ktClassOrObject instanceof KtClass ? (KtClass)ktClassOrObject : null;
        list2 = list2 == null ? null : ((KtClassOrObject)((Object)list2)).getPrimaryConstructorParameters();
        boolean bl = false;
        List list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }
}

