/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.lower.InheritedDefaultMethodsOnClassesLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.InitBlockOrConstructorImpl;
import org.jetbrains.kotlin.backend.jvm.lower.inlineclasses.InlineClassAbi;
import org.jetbrains.kotlin.backend.jvm.lower.inlineclasses.InlineClassAbiKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrElementKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrGeneratorWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainerKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrReturnTarget;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementContainer;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrBindableSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.TransformKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u00f2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0015H\u0002J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0015H\u0002J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0015H\u0002J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0002J\u0018\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0002J\u0018\u0010(\u001a\u00020&2\u0006\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020*H\u0002J\n\u0010+\u001a\u0004\u0018\u00010,H\u0002J\u0018\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\"H\u0002J\u0010\u00101\u001a\u00020\u000f2\u0006\u00102\u001a\u000203H\u0016J\u001e\u00104\u001a\b\u0012\u0004\u0012\u000206052\u0006\u00107\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020&H\u0002J\u0018\u00108\u001a\n\u0012\u0004\u0012\u000206\u0018\u0001052\u0006\u00109\u001a\u00020\u0011H\u0002J\u001e\u0010:\u001a\b\u0012\u0004\u0012\u000206052\u0006\u00109\u001a\u00020&2\u0006\u0010\u0012\u001a\u00020&H\u0002J0\u0010;\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020=\u0012\u0006\u0012\u0004\u0018\u00010 0<052\u0006\u00109\u001a\u00020\u00112\n\u0010>\u001a\u0006\u0012\u0002\b\u00030?H\u0002J\u0010\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0016J\u0010\u0010D\u001a\u00020 2\u0006\u0010>\u001a\u00020\fH\u0016J\u0010\u0010E\u001a\u00020F2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010G\u001a\u00020 2\u0006\u0010>\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020 2\u0006\u0010>\u001a\u00020JH\u0016J\u0010\u0010K\u001a\u00020 2\u0006\u0010>\u001a\u00020LH\u0016J\u0010\u0010M\u001a\u00020 2\u0006\u0010>\u001a\u00020NH\u0016J\u0010\u0010O\u001a\u00020 2\u0006\u0010>\u001a\u00020PH\u0016J\u0010\u0010Q\u001a\u00020 2\u0006\u0010>\u001a\u00020RH\u0016J\u0010\u0010S\u001a\u00020 2\u0006\u0010>\u001a\u00020TH\u0016J\u0010\u0010U\u001a\u00020\u000f2\u0006\u0010V\u001a\u00020WH\u0002J,\u0010X\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030?2\u0006\u0010Y\u001a\u00020\u00112\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030?2\u0006\u0010\u0012\u001a\u00020&H\u0002J\f\u0010Z\u001a\u00020\u001e*\u00020 H\u0002J\f\u0010[\u001a\u00020\u000b*\u00020&H\u0002J\u001e\u0010\\\u001a\u0004\u0018\u00010 *\u00020]2\u0006\u0010^\u001a\u00020 2\u0006\u0010_\u001a\u00020 H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\u00020\u000b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\r\u00a8\u0006`"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmInlineClassLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "valueMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "isSpecializedInlineClassEqEq", "", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Z", "addBindingsFor", "", "original", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "replacement", "addJvmInlineAnnotation", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "buildBoxFunction", "irClass", "buildPrimaryInlineClassConstructor", "irConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "buildSpecializedEqualsMethod", "buildUnboxFunction", "coerceInlineClasses", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrCallImpl;", "argument", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "from", "Lorg/jetbrains/kotlin/ir/types/IrType;", "to", "createBridgeBody", "source", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "target", "createBridgeDeclaration", "mangledName", "Lorg/jetbrains/kotlin/name/Name;", "findInitBlockOrConstructorImpl", "Lorg/jetbrains/kotlin/backend/jvm/lower/InitBlockOrConstructorImpl;", "getConstructorImplArgumentValue", "ctor", "Lorg/jetbrains/kotlin/backend/jvm/lower/InitBlockOrConstructorImpl$ConstructorImpl;", "expectedType", "lower", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "transformConstructorFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "constructor", "transformFunctionFlat", "function", "transformSimpleFunctionFlat", "typedArgumentList", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "visitBlockBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "visitCall", "visitClassNew", "Lorg/jetbrains/kotlin/ir/IrStatement;", "visitContainerExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "visitFunctionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "visitStatementContainer", "container", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementContainer;", "buildReplacement", "originalFunction", "coerceToUnboxed", "signatureRequiresMangling", "specializeEqualsCall", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "left", "right", "backend.jvm"})
final class JvmInlineClassLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final Map<IrValueSymbol, IrValueDeclaration> valueMap;

    public JvmInlineClassLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        boolean bl = false;
        this.valueMap = new LinkedHashMap();
    }

    private final void addBindingsFor(IrFunction original, IrFunction replacement) {
        for (Pair pair : CollectionsKt.zip((Iterable)IrUtilsKt.getExplicitParameters(original), (Iterable)IrUtilsKt.getExplicitParameters(replacement))) {
            IrValueParameter param = (IrValueParameter)pair.component1();
            IrValueParameter newParam = (IrValueParameter)pair.component2();
            Map<IrValueSymbol, IrValueDeclaration> map2 = this.valueMap;
            IrValueParameterSymbol irValueParameterSymbol = (IrValueParameterSymbol)param.getSymbol();
            boolean bl = false;
            map2.put(irValueParameterSymbol, newParam);
        }
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        this.transformChildrenVoid(irFile);
    }

    @Override
    @NotNull
    public IrStatement visitClassNew(@NotNull IrClass declaration2) {
        IrConstructor irConstructor2;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        IrConstructor irConstructor3 = IrUtilsKt.getPrimaryConstructor(declaration2);
        if (irConstructor3 != null) {
            irConstructor2 = irConstructor3;
            boolean bl = false;
            boolean bl2 = false;
            IrConstructor it = irConstructor2;
            boolean bl3 = false;
            IrSimpleFunction irSimpleFunction = this.context.getInlineClassReplacements().getGetReplacementFunction().invoke(it);
            if (irSimpleFunction != null) {
                IrSimpleFunction irSimpleFunction2 = irSimpleFunction;
                boolean bl4 = false;
                boolean bl5 = false;
                IrSimpleFunction replacement = irSimpleFunction2;
                boolean bl6 = false;
                this.addBindingsFor(it, replacement);
            }
        }
        TransformKt.transformDeclarationsFlat(declaration2, (Function1<? super IrDeclaration, ? extends List<? extends IrDeclaration>>)new Function1<IrDeclaration, List<? extends IrDeclaration>>(this){
            final /* synthetic */ JvmInlineClassLowering this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final List<IrDeclaration> invoke(@NotNull IrDeclaration memberDeclaration) {
                List list2;
                Intrinsics.checkNotNullParameter(memberDeclaration, "memberDeclaration");
                if (memberDeclaration instanceof IrFunction) {
                    list2 = JvmInlineClassLowering.access$transformFunctionFlat(this.this$0, (IrFunction)memberDeclaration);
                } else {
                    memberDeclaration.accept(this.this$0, null);
                    list2 = null;
                }
                return list2;
            }
        });
        if (declaration2.isInline()) {
            irConstructor2 = IrUtilsKt.getPrimaryConstructor(declaration2);
            Intrinsics.checkNotNull(irConstructor2);
            IrConstructor irConstructor4 = irConstructor2;
            declaration2.getDeclarations().removeIf(new Predicate<IrDeclaration>(irConstructor4){
                final /* synthetic */ IrConstructor $irConstructor;
                {
                    this.$irConstructor = $irConstructor;
                }

                public final boolean test(@NotNull IrDeclaration it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return Intrinsics.areEqual(it, this.$irConstructor) || it instanceof IrFunction && InlineClassAbiKt.isInlineClassFieldGetter((IrFunction)it) && !((IrFunction)it).getVisibility().isPublicAPI();
                }
            });
            this.buildPrimaryInlineClassConstructor(declaration2, irConstructor4);
            this.buildBoxFunction(declaration2);
            this.buildUnboxFunction(declaration2);
            this.buildSpecializedEqualsMethod(declaration2);
            this.addJvmInlineAnnotation(declaration2);
        }
        return declaration2;
    }

    private final void addJvmInlineAnnotation(IrClass declaration2) {
        if (IrUtilsKt.hasAnnotation((IrAnnotationContainer)declaration2, InlineClassesUtilsKt.getJVM_INLINE_ANNOTATION_FQ_NAME())) {
            return;
        }
        IrConstructorSymbol constructor2 = SequencesKt.first(IrUtilsKt.getConstructors(this.context.getIr().getSymbols().getJvmInlineAnnotation()));
        declaration2.setAnnotations(CollectionsKt.plus((Collection)declaration2.getAnnotations(), IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, ((IrConstructor)constructor2.getOwner()).getReturnType(), constructor2, null, 4, null)));
    }

    private final List<IrDeclaration> transformFunctionFlat(IrFunction function2) {
        List<IrDeclaration> list2;
        if (InlineClassAbiKt.isPrimaryInlineClassConstructor(function2)) {
            return null;
        }
        IrSimpleFunction replacement = this.context.getInlineClassReplacements().getGetReplacementFunction().invoke(function2);
        if (replacement == null) {
            this.transformChildrenVoid(function2);
            return null;
        }
        this.addBindingsFor(function2, replacement);
        IrFunction irFunction2 = function2;
        if (irFunction2 instanceof IrSimpleFunction) {
            list2 = this.transformSimpleFunctionFlat((IrSimpleFunction)function2, replacement);
        } else if (irFunction2 instanceof IrConstructor) {
            list2 = this.transformConstructorFlat((IrConstructor)function2, replacement);
        } else {
            throw new IllegalStateException();
        }
        return list2;
    }

    private final List<IrDeclaration> transformSimpleFunctionFlat(IrSimpleFunction function2, IrSimpleFunction replacement) {
        IrPropertySymbol irPropertySymbol;
        Name name2;
        IrElement irElement;
        Object $this$forEach$iv = replacement.getValueParameters();
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            Object element$iv = object.next();
            IrValueParameter it = (IrValueParameter)element$iv;
            boolean bl = false;
            this.transformChildrenVoid(it);
        }
        UtilsKt.push(this.getAllScopes(), this.createScope(function2));
        $this$forEach$iv = function2.getBody();
        replacement.setBody($this$forEach$iv == null ? null : ((irElement = ((IrBody)$this$forEach$iv).transform((IrElementTransformer)this, (Object)null)) == null ? null : (IrBody)PatchDeclarationParentsKt.patchDeclarationParents(irElement, replacement)));
        UtilsKt.pop(this.getAllScopes());
        IrAttributeContainerKt.copyAttributes((IrAttributeContainer)replacement, function2);
        if (function2.getOverriddenSymbols().isEmpty() || replacement.getDispatchReceiverParameter() != null) {
            return CollectionsKt.listOf(replacement);
        }
        if ((!function2.isFakeOverride() || InheritedDefaultMethodsOnClassesLoweringKt.findInterfaceImplementation(function2, this.context.getState().getJvmDefaultMode()) != null) && this.signatureRequiresMangling(function2)) {
            name2 = replacement.getName();
        } else if (AdditionalIrUtilsKt.isGetter(replacement)) {
            irPropertySymbol = replacement.getCorrespondingPropertySymbol();
            Intrinsics.checkNotNull(irPropertySymbol);
            object = ((IrProperty)irPropertySymbol.getOwner()).getName().asString();
            Intrinsics.checkNotNullExpressionValue(object, "replacement.correspondingPropertySymbol!!.owner.name.asString()");
            Name name3 = Name.identifier(JvmAbi.getterName((String)object));
            Intrinsics.checkNotNullExpressionValue(name3, "identifier(JvmAbi.getterName(replacement.correspondingPropertySymbol!!.owner.name.asString()))");
            name2 = name3;
        } else if (AdditionalIrUtilsKt.isSetter(replacement)) {
            irPropertySymbol = replacement.getCorrespondingPropertySymbol();
            Intrinsics.checkNotNull(irPropertySymbol);
            object = ((IrProperty)irPropertySymbol.getOwner()).getName().asString();
            Intrinsics.checkNotNullExpressionValue(object, "replacement.correspondingPropertySymbol!!.owner.name.asString()");
            Name name4 = Name.identifier(JvmAbi.setterName((String)object));
            Intrinsics.checkNotNullExpressionValue(name4, "identifier(JvmAbi.setterName(replacement.correspondingPropertySymbol!!.owner.name.asString()))");
            name2 = name4;
        } else {
            name2 = function2.getName();
        }
        IrSimpleFunction bridgeFunction = this.createBridgeDeclaration(function2, name2);
        bridgeFunction.setOverriddenSymbols(replacement.getOverriddenSymbols());
        if (!bridgeFunction.isFakeOverride() || !IrUtilsKt.getParentAsClass(bridgeFunction).isInline()) {
            this.createBridgeBody(bridgeFunction, replacement);
        } else {
            this.createBridgeBody(replacement, bridgeFunction);
        }
        IrSimpleFunction[] irSimpleFunctionArray = new IrSimpleFunction[]{replacement, bridgeFunction};
        return CollectionsKt.listOf(irSimpleFunctionArray);
    }

    private final boolean signatureRequiresMangling(IrSimpleFunction $this$signatureRequiresMangling) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = InlineClassAbiKt.getFullValueParameterList($this$signatureRequiresMangling);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrValueParameter it = (IrValueParameter)element$iv;
                    boolean bl2 = false;
                    if (!InlineClassAbiKt.getRequiresMangling(it.getType())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl || this.context.getState().getFunctionsWithInlineClassReturnTypesMangled() && InlineClassAbiKt.getRequiresMangling($this$signatureRequiresMangling.getReturnType());
    }

    private final IrSimpleFunction createBridgeDeclaration(IrSimpleFunction source, Name mangledName) {
        IrFactory $this$buildFun$iv = this.context.getIrFactory();
        boolean $i$f$buildFun = false;
        IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
        boolean bl = false;
        boolean bl2 = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2d18$iv = irFunctionBuilder;
        boolean bl3 = false;
        IrFunctionBuilder $this$createBridgeDeclaration_u24lambda_u2d4 = $this$buildFun_u24lambda_u2d18$iv;
        boolean bl4 = false;
        $this$createBridgeDeclaration_u24lambda_u2d4.updateFrom(source);
        $this$createBridgeDeclaration_u24lambda_u2d4.setName(mangledName);
        $this$createBridgeDeclaration_u24lambda_u2d4.setReturnType(source.getReturnType());
        IrSimpleFunction irSimpleFunction = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u2d18$iv);
        boolean bl5 = false;
        boolean bl6 = false;
        IrSimpleFunction $this$createBridgeDeclaration_u24lambda_u2d5 = irSimpleFunction;
        boolean bl7 = false;
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyParameterDeclarationsFrom($this$createBridgeDeclaration_u24lambda_u2d5, source);
        IrSimpleFunction irSimpleFunction2 = $this$createBridgeDeclaration_u24lambda_u2d5;
        irSimpleFunction2.setAnnotations(CollectionsKt.plus((Collection)irSimpleFunction2.getAnnotations(), (Iterable)source.getAnnotations()));
        $this$createBridgeDeclaration_u24lambda_u2d5.setParent(source.getParent());
        IrAttributeContainerKt.copyAttributes((IrAttributeContainer)$this$createBridgeDeclaration_u24lambda_u2d5, source);
        return irSimpleFunction;
    }

    /*
     * WARNING - void declaration
     */
    private final void createBridgeBody(IrSimpleFunction source, IrSimpleFunction target) {
        void $this$createBridgeBody_u24lambda_u2d7_u24lambda_u2d6;
        void $this$createBridgeBody_u24lambda_u2d7;
        DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder(this.context, source.getSymbol(), source.getStartOffset(), source.getEndOffset());
        boolean bl = false;
        boolean bl2 = false;
        DeclarationIrBuilder declarationIrBuilder2 = declarationIrBuilder;
        IrSimpleFunction irSimpleFunction = source;
        boolean bl3 = false;
        IrFunctionAccessExpression irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$createBridgeBody_u24lambda_u2d7, target);
        boolean bl4 = false;
        boolean bl5 = false;
        IrFunctionAccessExpression irFunctionAccessExpression2 = irFunctionAccessExpression;
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$createBridgeBody_u24lambda_u2d7;
        boolean bl6 = false;
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.passTypeArgumentsFrom$default((IrFunctionAccessExpression)$this$createBridgeBody_u24lambda_u2d7_u24lambda_u2d6, source, 0, 2, null);
        for (Pair pair : CollectionsKt.zip((Iterable)IrUtilsKt.getExplicitParameters(source), (Iterable)IrUtilsKt.getExplicitParameters(target))) {
            IrValueParameter parameter = (IrValueParameter)pair.component1();
            IrValueParameter newParameter = (IrValueParameter)pair.component2();
            IrFunctionAccessExpressionKt.putArgument((IrFunctionAccessExpression)$this$createBridgeBody_u24lambda_u2d7_u24lambda_u2d6, newParameter, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$createBridgeBody_u24lambda_u2d7, parameter));
        }
        Unit unit = Unit.INSTANCE;
        IrExpressionBody irExpressionBody = ExpressionHelpersKt.irExprBody(irBuilderWithScope, irFunctionAccessExpression);
        irSimpleFunction.setBody(irExpressionBody);
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrDeclaration> transformConstructorFlat(IrConstructor constructor2, IrSimpleFunction replacement) {
        void $this$transformConstructorFlat_u24lambda_u2d10;
        void this_$iv$iv$iv;
        void startOffset$iv$iv;
        void $this$irBlockBody$iv$iv;
        Iterable $this$forEach$iv = replacement.getValueParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrValueParameter it = (IrValueParameter)element$iv;
            boolean bl = false;
            this.transformChildrenVoid(it);
        }
        IrGeneratorWithScope $this$irBlockBody$iv = LowerUtilsKt.createIrBuilder(this.context, replacement.getSymbol(), replacement.getStartOffset(), replacement.getEndOffset());
        boolean $i$f$irBlockBody = false;
        IrGeneratorWithScope irGeneratorWithScope = $this$irBlockBody$iv;
        int element$iv = ((IrElement)replacement).getStartOffset();
        int endOffset$iv$iv = ((IrElement)replacement).getEndOffset();
        boolean $i$f$irBlockBody2 = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody$iv$iv.getContext(), $this$irBlockBody$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv);
        boolean $i$f$blockBody = false;
        void var11_13 = this_$iv$iv$iv;
        IrSimpleFunction irSimpleFunction = replacement;
        boolean bl = false;
        Object object = replacement.getReturnType();
        IrVariable thisVar = ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$transformConstructorFlat_u24lambda_u2d10, null, "$this", (IrType)object, false, 9, null);
        object = this.valueMap;
        List<IrStatement> list2 = AdditionalIrUtilsKt.getConstructedClass(constructor2).getThisReceiver();
        Intrinsics.checkNotNull(list2);
        list2 = (IrValueParameterSymbol)((IrValueDeclaration)((Object)list2)).getSymbol();
        boolean bl2 = false;
        object.put(list2, thisVar);
        object = constructor2.getBody();
        if (object != null && (list2 = IrUtilsKt.getStatements((IrBody)object)) != null) {
            Iterable $this$forEach$iv2 = list2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                IrStatement statement2 = (IrStatement)element$iv2;
                boolean bl3 = false;
                $this$transformConstructorFlat_u24lambda_u2d10.unaryPlus((IrStatement)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)IrElementKt.transformStatement(IrElementKt.transformStatement(statement2, new IrElementTransformerVoid((IrBlockBodyBuilder)$this$transformConstructorFlat_u24lambda_u2d10, thisVar, constructor2){
                    final /* synthetic */ IrBlockBodyBuilder $this_anonymous;
                    final /* synthetic */ IrVariable $thisVar;
                    final /* synthetic */ IrConstructor $constructor;
                    {
                        this.$this_anonymous = $receiver;
                        this.$thisVar = $thisVar;
                        this.$constructor = $constructor;
                    }

                    @NotNull
                    public IrStatement visitClass(@NotNull IrClass declaration2) {
                        Intrinsics.checkNotNullParameter(declaration2, "declaration");
                        return declaration2;
                    }

                    @NotNull
                    public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                        Intrinsics.checkNotNullParameter(expression2, "expression");
                        this.transformChildrenVoid(expression2);
                        return ExpressionHelpersKt.irSet$default(this.$this_anonymous, this.$thisVar.getSymbol(), expression2, null, 4, null);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public IrExpression visitReturn(@NotNull IrReturn expression2) {
                        void $this$visitReturn_u24lambda_u2d0;
                        void this_$iv$iv;
                        void endOffset$iv;
                        void startOffset$iv;
                        void $this$irBlock_u24default$iv;
                        Intrinsics.checkNotNullParameter(expression2, "expression");
                        this.transformChildrenVoid(expression2);
                        if (!Intrinsics.areEqual(expression2.getReturnTargetSymbol(), this.$constructor.getSymbol())) {
                            return expression2;
                        }
                        IrBuilderWithScope irBuilderWithScope = this.$this_anonymous;
                        int n = expression2.getStartOffset();
                        int n2 = expression2.getEndOffset();
                        IrVariable irVariable2 = this.$thisVar;
                        IrStatementOrigin origin$iv = null;
                        IrType resultType$iv = null;
                        boolean $i$f$irBlock = false;
                        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), (int)startOffset$iv, (int)endOffset$iv, origin$iv, resultType$iv, false, 64, null);
                        boolean $i$f$block = false;
                        void var11_11 = this_$iv$iv;
                        IrBuilderWithScope irBuilderWithScope2 = this.$this_anonymous;
                        boolean bl = false;
                        $this$visitReturn_u24lambda_u2d0.unaryPlus(expression2.getValue());
                        $this$visitReturn_u24lambda_u2d0.unaryPlus(ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$visitReturn_u24lambda_u2d0, irVariable2));
                        Unit unit = Unit.INSTANCE;
                        return ExpressionHelpersKt.irReturn(irBuilderWithScope2, this_$iv$iv.doBuild());
                    }
                }), this), replacement));
            }
        }
        $this$transformConstructorFlat_u24lambda_u2d10.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$transformConstructorFlat_u24lambda_u2d10, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$transformConstructorFlat_u24lambda_u2d10, thisVar)));
        Unit unit = Unit.INSTANCE;
        irSimpleFunction.setBody(this_$iv$iv$iv.doBuild());
        return CollectionsKt.listOf(replacement);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<IrValueParameter, IrExpression>> typedArgumentList(IrFunction function2, IrMemberAccessExpression<?> expression2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair<Object, IrExpression> pair;
        Pair<Object, IrExpression> pair2;
        IrValueParameter it;
        Object object;
        int n;
        boolean bl;
        boolean bl2;
        IrValueParameter irValueParameter;
        Pair<void, IrExpression> pair3;
        Object object2;
        Pair[] pairArray = object2 = new Pair[2];
        int n2 = 0;
        IrValueParameter irValueParameter2 = function2.getDispatchReceiverParameter();
        if (irValueParameter2 == null) {
            pair3 = null;
        } else {
            irValueParameter = irValueParameter2;
            bl2 = false;
            bl = false;
            IrValueParameter irValueParameter3 = irValueParameter;
            n = n2;
            object = pairArray;
            boolean bl3 = false;
            pair2 = TuplesKt.to(it, expression2.getDispatchReceiver());
            pairArray = object;
            n2 = n;
            pair3 = pair2;
        }
        pairArray[n2] = pair3;
        Pair[] pairArray2 = object2;
        int n3 = 1;
        irValueParameter2 = function2.getExtensionReceiverParameter();
        if (irValueParameter2 == null) {
            pair = null;
        } else {
            irValueParameter = irValueParameter2;
            bl2 = false;
            bl = false;
            it = irValueParameter;
            n = n3;
            object = pairArray2;
            boolean bl4 = false;
            pair2 = TuplesKt.to(it, expression2.getExtensionReceiver());
            pairArray2 = object;
            n3 = n;
            pair = pair2;
        }
        pairArray2[n3] = pair;
        Collection collection = CollectionsKt.listOfNotNull(object2);
        object2 = function2.getValueParameters();
        object = collection;
        boolean $i$f$map = false;
        irValueParameter = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            IrValueParameter irValueParameter4 = (IrValueParameter)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl5 = false;
            pair2 = TuplesKt.to(it2, expression2.getValueArgument(it2.getIndex()));
            collection2.add(pair2);
        }
        List list2 = (List)destination$iv$iv;
        return CollectionsKt.plus(object, (Iterable)list2);
    }

    private final void buildReplacement(IrMemberAccessExpression<?> $this$buildReplacement, IrFunction originalFunction, IrMemberAccessExpression<?> original, IrSimpleFunction replacement) {
        IrMemberAccessExpressionKt.copyTypeArgumentsFrom$default($this$buildReplacement, original, 0, 2, null);
        Map valueParameterMap = MapsKt.toMap(CollectionsKt.zip((Iterable)IrUtilsKt.getExplicitParameters(originalFunction), (Iterable)IrUtilsKt.getExplicitParameters(replacement)));
        for (Pair<IrValueParameter, IrExpression> pair : this.typedArgumentList(originalFunction, original)) {
            IrValueParameter parameter = pair.component1();
            IrExpression argument = pair.component2();
            if (argument == null) continue;
            IrValueParameter newParameter = (IrValueParameter)MapsKt.getValue(valueParameterMap, parameter);
            IrMemberAccessExpressionKt.putArgument($this$buildReplacement, replacement, newParameter, (IrExpression)argument.transform((IrElementTransformer)this, (Object)null));
        }
    }

    @Override
    @NotNull
    public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (Intrinsics.areEqual(expression2.getOrigin(), InlineClassAbi.UNMANGLED_FUNCTION_REFERENCE.INSTANCE)) {
            return super.visitFunctionReference(expression2);
        }
        IrFunction function2 = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
        IrElementBase irElementBase = this.context.getInlineClassReplacements().getGetReplacementFunction().invoke(function2);
        if (irElementBase == null) {
            return super.visitFunctionReference(expression2);
        }
        IrSimpleFunction replacement = irElementBase;
        irElementBase = new IrFunctionReferenceImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), replacement.getSymbol(), replacement.getTypeParameters().size(), replacement.getValueParameters().size(), expression2.getReflectionTarget(), expression2.getOrigin());
        boolean bl = false;
        boolean bl2 = false;
        IrElementBase $this$visitFunctionReference_u24lambda_u2d14 = irElementBase;
        boolean bl3 = false;
        this.buildReplacement((IrMemberAccessExpression)$this$visitFunctionReference_u24lambda_u2d14, function2, expression2, replacement);
        return (IrExpression)IrAttributeContainerKt.copyAttributes((IrAttributeContainer)((Object)irElementBase), expression2);
    }

    @Override
    @NotNull
    public IrExpression visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrFunction function2 = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
        IrElementBase irElementBase = this.context.getInlineClassReplacements().getGetReplacementFunction().invoke(function2);
        if (irElementBase == null) {
            return super.visitFunctionAccess(expression2);
        }
        IrSimpleFunction replacement = irElementBase;
        irElementBase = expression2 instanceof IrCall ? (IrCall)expression2 : null;
        irElementBase = new IrCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), IrTypeUtilsKt.substitute(function2.getReturnType(), IrUtilsKt.getTypeSubstitutionMap(expression2)), (IrSimpleFunctionSymbol)replacement.getSymbol(), replacement.getTypeParameters().size(), replacement.getValueParameters().size(), expression2.getOrigin(), irElementBase == null ? null : ((IrCall)irElementBase).getSuperQualifierSymbol());
        boolean bl = false;
        boolean bl2 = false;
        IrElementBase $this$visitFunctionAccess_u24lambda_u2d15 = irElementBase;
        boolean bl3 = false;
        this.buildReplacement((IrMemberAccessExpression)$this$visitFunctionAccess_u24lambda_u2d15, function2, expression2, replacement);
        return (IrExpression)irElementBase;
    }

    private final IrCallImpl coerceInlineClasses(IrExpression argument, IrType from, IrType to) {
        IrCallImpl irCallImpl = IrCallImpl.Companion.fromSymbolOwner$default(IrCallImpl.Companion, -1, -1, to, this.context.getIr().getSymbols().getUnsafeCoerceIntrinsic(), 0, 0, null, null, 240, null);
        boolean bl = false;
        boolean bl2 = false;
        IrCallImpl $this$coerceInlineClasses_u24lambda_u2d16 = irCallImpl;
        boolean bl3 = false;
        $this$coerceInlineClasses_u24lambda_u2d16.putTypeArgument(0, from);
        $this$coerceInlineClasses_u24lambda_u2d16.putTypeArgument(1, to);
        $this$coerceInlineClasses_u24lambda_u2d16.putValueArgument(0, argument);
        return irCallImpl;
    }

    private final IrCallImpl coerceToUnboxed(IrExpression $this$coerceToUnboxed) {
        return this.coerceInlineClasses($this$coerceToUnboxed, $this$coerceToUnboxed.getType(), InlineClassAbiKt.unboxInlineClass($this$coerceToUnboxed.getType()));
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression specializeEqualsCall(IrBuilderWithScope $this$specializeEqualsCall, IrExpression left, IrExpression right) {
        IrExpression irExpression;
        boolean rightNullCheck;
        boolean rightIsUnboxed;
        if (IrUtilsKt.isNullConst(left) || IrUtilsKt.isNullConst(right)) {
            return null;
        }
        boolean leftIsUnboxed = !Intrinsics.areEqual(InlineClassAbiKt.unboxInlineClass(left.getType()), left.getType());
        boolean bl = rightIsUnboxed = !Intrinsics.areEqual(InlineClassAbiKt.unboxInlineClass(right.getType()), right.getType());
        if (!leftIsUnboxed && !rightIsUnboxed) {
            return null;
        }
        boolean leftNullCheck = org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(left.getType());
        boolean bl2 = rightNullCheck = rightIsUnboxed && org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(right.getType());
        if (leftNullCheck || rightNullCheck) {
            IrExpression equalsRight;
            void this_$iv$iv;
            IrBuilderWithScope $this$irBlock_u24default$iv = $this$specializeEqualsCall;
            int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = null;
            boolean $i$f$irBlock = false;
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
            boolean $i$f$block = false;
            void $this$specializeEqualsCall_u24lambda_u2d19 = this_$iv$iv;
            boolean bl3 = false;
            IrValueDeclaration leftVal = left instanceof IrGetValue ? ((IrGetValue)left).getSymbol().getOwner() : (IrValueDeclaration)ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$specializeEqualsCall_u24lambda_u2d19, left, null, null, false, 14, null);
            IrValueDeclaration rightVal = right instanceof IrGetValue ? ((IrGetValue)right).getSymbol().getOwner() : (IrValueDeclaration)ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$specializeEqualsCall_u24lambda_u2d19, right, null, null, false, 14, null);
            IrExpression equalsCall = JvmInlineClassLowering.specializeEqualsCall$equals(rightIsUnboxed, $this$specializeEqualsCall, this, leftNullCheck ? (IrExpression)ExpressionHelpersKt.irImplicitCast((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2d19, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2d19, leftVal), IrTypesKt.makeNotNull(left.getType())) : (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2d19, leftVal), rightNullCheck ? (IrExpression)ExpressionHelpersKt.irImplicitCast((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2d19, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2d19, rightVal), IrTypesKt.makeNotNull(right.getType())) : (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2d19, rightVal));
            IrExpression irExpression2 = equalsRight = rightNullCheck ? (IrExpression)ExpressionHelpersKt.irIfNull((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2d19, $this$specializeEqualsCall_u24lambda_u2d19.getContext().getIrBuiltIns().getBooleanType(), ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2d19, rightVal), ExpressionHelpersKt.irFalse((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2d19), equalsCall) : equalsCall;
            if (leftNullCheck) {
                $this$specializeEqualsCall_u24lambda_u2d19.unaryPlus(ExpressionHelpersKt.irIfNull((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2d19, $this$specializeEqualsCall_u24lambda_u2d19.getContext().getIrBuiltIns().getBooleanType(), ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2d19, leftVal), ExpressionHelpersKt.irEqualsNull((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2d19, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2d19, rightVal)), equalsRight));
            } else {
                $this$specializeEqualsCall_u24lambda_u2d19.unaryPlus(equalsRight);
            }
            irExpression = this_$iv$iv.doBuild();
        } else {
            irExpression = JvmInlineClassLowering.specializeEqualsCall$equals(rightIsUnboxed, $this$specializeEqualsCall, this, left, right);
        }
        return irExpression;
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (InlineClassAbiKt.isInlineClassFieldGetter(expression2.getSymbol().getOwner())) {
            InitBlockOrConstructorImpl ctor = this.findInitBlockOrConstructorImpl();
            if (Intrinsics.areEqual(ctor, InitBlockOrConstructorImpl.InitBlock.INSTANCE)) {
                irExpression = super.visitCall(expression2);
            } else if (ctor instanceof InitBlockOrConstructorImpl.ConstructorImpl) {
                irExpression = this.getConstructorImplArgumentValue((InitBlockOrConstructorImpl.ConstructorImpl)ctor, expression2.getType());
            } else {
                IrElementBase irElementBase = expression2.getDispatchReceiver();
                Intrinsics.checkNotNull(irElementBase);
                IrElement arg = ((IrExpression)irElementBase).transform((IrElementTransformer)this, (Object)null);
                irElementBase = ((IrSimpleFunction)expression2.getSymbol().getOwner()).getDispatchReceiverParameter();
                Intrinsics.checkNotNull(irElementBase);
                irExpression = this.coerceInlineClasses((IrExpression)arg, ((IrValueDeclaration)irElementBase).getType(), expression2.getType());
            }
        } else if (this.isSpecializedInlineClassEqEq(expression2)) {
            this.transformChildrenVoid(expression2);
            BackendContext backendContext = this.context;
            Object object = this.getCurrentScope();
            Intrinsics.checkNotNull(object);
            IrBuilderWithScope irBuilderWithScope = LowerUtilsKt.createIrBuilder(backendContext, ((ScopeWithIr)object).getScope().getScopeOwnerSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
            object = expression2.getValueArgument(0);
            Intrinsics.checkNotNull(object);
            Object object2 = object;
            object = expression2.getValueArgument(1);
            Intrinsics.checkNotNull(object);
            IrExpression irExpression2 = this.specializeEqualsCall(irBuilderWithScope, (IrExpression)object2, (IrExpression)object);
            irExpression = irExpression2 == null ? (IrExpression)expression2 : irExpression2;
        } else {
            irExpression = super.visitCall(expression2);
        }
        return irExpression;
    }

    private final IrExpression getConstructorImplArgumentValue(InitBlockOrConstructorImpl.ConstructorImpl ctor, IrType expectedType2) {
        IrValueParameter arg = CollectionsKt.single(ctor.getIrElement().getValueParameters());
        return this.coerceInlineClasses(new IrGetValueImpl(-1, -1, arg.getSymbol(), null, 8, null), arg.getType(), expectedType2);
    }

    private final InitBlockOrConstructorImpl findInitBlockOrConstructorImpl() {
        for (ScopeWithIr scope2 : CollectionsKt.reversed((Iterable)this.getAllScopes())) {
            IrElement irElement = scope2.getIrElement();
            if (irElement instanceof IrAnonymousInitializer) {
                return InitBlockOrConstructorImpl.InitBlock.INSTANCE;
            }
            if (!(irElement instanceof IrFunction) || !Intrinsics.areEqual(((IrFunction)irElement).getOrigin(), JvmLoweredDeclarationOrigin.STATIC_INLINE_CLASS_CONSTRUCTOR.INSTANCE)) continue;
            return new InitBlockOrConstructorImpl.ConstructorImpl((IrFunction)irElement);
        }
        return null;
    }

    private final boolean isSpecializedInlineClassEqEq(IrCall $this$isSpecializedInlineClassEqEq) {
        Object object;
        Object object2;
        Object object3;
        IrBindableSymbol irBindableSymbol;
        if (!Intrinsics.areEqual($this$isSpecializedInlineClassEqEq.getSymbol(), this.context.getIrBuiltIns().getEqeqSymbol())) {
            return false;
        }
        IrElementBase irElementBase = $this$isSpecializedInlineClassEqEq.getValueArgument(0);
        IrBindableSymbol irBindableSymbol2 = irElementBase == null ? null : (irBindableSymbol = (object3 = irElementBase.getType()) == null ? null : IrTypesKt.getClassOrNull((IrType)object3));
        if (irBindableSymbol == null) {
            object2 = null;
        } else {
            irElementBase = (IrClass)irBindableSymbol.getOwner();
            if (irElementBase == null) {
                object2 = null;
            } else {
                object3 = irElementBase;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object3;
                boolean bl3 = false;
                object2 = object = ((IrClass)it).isInline() ? object3 : null;
            }
        }
        if (object == null) {
            return false;
        }
        Object leftClass = object;
        return !Intrinsics.areEqual(IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)leftClass), StandardNames.RESULT_FQ_NAME) || this.context.getState().getLanguageVersionSettings().getApiVersion().compareTo(ApiVersion.KOTLIN_1_4) >= 0;
    }

    @Override
    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrField field = (IrField)expression2.getSymbol().getOwner();
        IrDeclarationParent parent2 = field.getParent();
        if (parent2 instanceof IrClass && ((IrClass)parent2).isInline() && Intrinsics.areEqual(field.getName(), InlineClassAbiKt.getInlineClassFieldName((IrClass)parent2))) {
            IrExpression irExpression = expression2.getReceiver();
            Intrinsics.checkNotNull(irExpression);
            IrElement receiver = irExpression.transform((IrElementTransformer)this, (Object)null);
            return this.coerceInlineClasses((IrExpression)receiver, ((IrExpression)receiver).getType(), field.getType());
        }
        return super.visitGetField(expression2);
    }

    @Override
    @NotNull
    public IrExpression visitReturn(@NotNull IrReturn expression2) {
        IrFunction irFunction2;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrReturnTarget $this$safeAs$iv = expression2.getReturnTargetSymbol().getOwner();
        boolean $i$f$safeAs = false;
        IrReturnTarget irReturnTarget = $this$safeAs$iv;
        if (!(irReturnTarget instanceof IrFunction)) {
            irReturnTarget = null;
        }
        if ((irFunction2 = (IrFunction)irReturnTarget) != null) {
            IrFunction irFunction3 = irFunction2;
            boolean bl = false;
            boolean bl2 = false;
            IrFunction target = irFunction3;
            boolean bl3 = false;
            IrSimpleFunction irSimpleFunction = this.context.getInlineClassReplacements().getGetReplacementFunction().invoke(target);
            if (irSimpleFunction != null) {
                IrSimpleFunction irSimpleFunction2 = irSimpleFunction;
                boolean bl4 = false;
                boolean bl5 = false;
                IrSimpleFunction it = irSimpleFunction2;
                boolean bl6 = false;
                return ExpressionHelpersKt.irReturn(LowerUtilsKt.createIrBuilder(this.context, it.getSymbol(), expression2.getStartOffset(), expression2.getEndOffset()), (IrExpression)expression2.getValue().transform((IrElementTransformer)this, (Object)null));
            }
        }
        return super.visitReturn(expression2);
    }

    /*
     * WARNING - void declaration
     */
    private final void visitStatementContainer(IrStatementContainer container2) {
        List<IrStatement> $this$transformFlat$iv = container2.getStatements();
        boolean $i$f$transformFlat = false;
        int i$iv = 0;
        while (i$iv < $this$transformFlat$iv.size()) {
            void statement2;
            IrStatement item$iv;
            IrStatement irStatement = item$iv = $this$transformFlat$iv.get(i$iv);
            List<IrStatement> list2 = $this$transformFlat$iv;
            boolean bl = false;
            List<IrStatement> list3 = statement2 instanceof IrFunction ? this.transformFunctionFlat((IrFunction)statement2) : CollectionsKt.listOf(IrElementKt.transformStatement((IrStatement)statement2, this));
            i$iv = TransformKt.replaceInPlace(list2, list3, i$iv);
        }
    }

    @Override
    @NotNull
    public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.visitStatementContainer(expression2);
        return expression2;
    }

    @Override
    @NotNull
    public IrBody visitBlockBody(@NotNull IrBlockBody body2) {
        Intrinsics.checkNotNullParameter(body2, "body");
        this.visitStatementContainer(body2);
        return body2;
    }

    @Override
    @NotNull
    public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
        InitBlockOrConstructorImpl ctor;
        IrDeclarationParent irDeclarationParent;
        IrClass irClass2;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrValueDeclaration irValueDeclaration = this.valueMap.get(expression2.getSymbol());
        if (irValueDeclaration != null) {
            IrValueDeclaration irValueDeclaration2 = irValueDeclaration;
            boolean bl = false;
            boolean bl2 = false;
            IrValueDeclaration it = irValueDeclaration2;
            boolean bl3 = false;
            return new IrGetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), it.getType(), it.getSymbol(), expression2.getOrigin());
        }
        IrValueDeclaration owner = expression2.getSymbol().getOwner();
        if (owner instanceof IrValueParameter && Intrinsics.areEqual((irClass2 = (irDeclarationParent = owner.getParent()) instanceof IrClass ? (IrClass)irDeclarationParent : null) == null ? null : Boolean.valueOf(irClass2.isInline()), true) && Intrinsics.areEqual(owner.getOrigin(), IrDeclarationOrigin.INSTANCE_RECEIVER.INSTANCE) && (ctor = this.findInitBlockOrConstructorImpl()) instanceof InitBlockOrConstructorImpl.ConstructorImpl) {
            return this.getConstructorImplArgumentValue((InitBlockOrConstructorImpl.ConstructorImpl)ctor, expression2.getType());
        }
        return super.visitGetValue(expression2);
    }

    @Override
    @NotNull
    public IrExpression visitSetValue(@NotNull IrSetValue expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrValueDeclaration irValueDeclaration = this.valueMap.get(expression2.getSymbol());
        if (irValueDeclaration != null) {
            IrValueDeclaration irValueDeclaration2 = irValueDeclaration;
            boolean bl = false;
            boolean bl2 = false;
            IrValueDeclaration it = irValueDeclaration2;
            boolean bl3 = false;
            return new IrSetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), it.getType(), it.getSymbol(), (IrExpression)expression2.getValue().transform((IrElementTransformer)this, (Object)null), expression2.getOrigin());
        }
        return super.visitSetValue(expression2);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildPrimaryInlineClassConstructor(IrClass irClass2, IrConstructor irConstructor2) {
        void $this$buildPrimaryInlineClassConstructor_u24lambda_u2d32_u24lambda_u2d31;
        void this_$iv$iv;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$buildPrimaryInlineClassConstructor_u24lambda_u2d29_u24lambda_u2d28;
        void this_$iv$iv$iv;
        void startOffset$iv$iv;
        Iterator $this$irBlockBody$iv$iv;
        Object $this$addConstructor$iv = irClass2;
        boolean $i$f$addConstructor22 = false;
        Object $this$buildConstructor$iv$iv22 = $this$addConstructor$iv.getFactory();
        boolean $i$f$buildConstructor = false;
        IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
        boolean bl = false;
        boolean bl2 = false;
        Object $this$buildConstructor_u24lambda_u2d22$iv$iv = irFunctionBuilder;
        boolean bl3 = false;
        IrFunctionBuilder $this$addConstructor_u24lambda_u2d23$iv = $this$buildConstructor_u24lambda_u2d22$iv$iv;
        boolean bl4 = false;
        Object $this$buildPrimaryInlineClassConstructor_u24lambda_u2d26 = $this$addConstructor_u24lambda_u2d23$iv;
        boolean bl5 = false;
        ((IrFunctionBuilder)$this$buildPrimaryInlineClassConstructor_u24lambda_u2d26).updateFrom(irConstructor2);
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
        Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "PRIVATE");
        ((IrDeclarationBuilder)$this$buildPrimaryInlineClassConstructor_u24lambda_u2d26).setVisibility(descriptorVisibility);
        ((IrDeclarationBuilder)$this$buildPrimaryInlineClassConstructor_u24lambda_u2d26).setOrigin(JvmLoweredDeclarationOrigin.SYNTHETIC_INLINE_CLASS_MEMBER.INSTANCE);
        ((IrFunctionBuilder)$this$buildPrimaryInlineClassConstructor_u24lambda_u2d26).setReturnType(irConstructor2.getReturnType());
        $this$addConstructor_u24lambda_u2d23$iv.setReturnType(IrUtilsKt.getDefaultType((IrClass)$this$addConstructor$iv));
        $this$buildConstructor$iv$iv22 = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv$iv22, (IrFunctionBuilder)$this$buildConstructor_u24lambda_u2d22$iv$iv);
        $i$f$buildConstructor = false;
        boolean bl6 = false;
        Object constructor$iv = $this$buildConstructor$iv$iv22;
        boolean bl7 = false;
        $this$addConstructor$iv.getDeclarations().add((IrDeclaration)constructor$iv);
        constructor$iv.setParent((IrDeclarationParent)$this$addConstructor$iv);
        $this$addConstructor$iv = $this$buildConstructor$iv$iv22;
        $i$f$addConstructor22 = false;
        boolean $this$buildConstructor$iv$iv22 = false;
        Object $this$buildPrimaryInlineClassConstructor_u24lambda_u2d29 = $this$addConstructor$iv;
        boolean $i$a$-apply-JvmInlineClassLowering$buildPrimaryInlineClassConstructor$32 = false;
        Object $this$forEach$iv = irConstructor2.getValueParameters();
        boolean $i$f$forEach = false;
        $this$buildConstructor_u24lambda_u2d22$iv$iv = $this$forEach$iv.iterator();
        while ($this$buildConstructor_u24lambda_u2d22$iv$iv.hasNext()) {
            Object element$iv = $this$buildConstructor_u24lambda_u2d22$iv$iv.next();
            IrValueParameter it = (IrValueParameter)element$iv;
            boolean bl8 = false;
            it.setDefaultValue(null);
        }
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyParameterDeclarationsFrom((IrFunction)$this$buildPrimaryInlineClassConstructor_u24lambda_u2d29, irConstructor2);
        $this$forEach$iv = $this$buildPrimaryInlineClassConstructor_u24lambda_u2d29;
        $this$forEach$iv.setAnnotations(CollectionsKt.plus((Collection)$this$forEach$iv.getAnnotations(), (Iterable)irConstructor2.getAnnotations()));
        IrGeneratorWithScope $this$irBlockBody$iv = LowerUtilsKt.createIrBuilder$default(this.context, ((IrFunction)$this$buildPrimaryInlineClassConstructor_u24lambda_u2d29).getSymbol(), 0, 0, 6, null);
        boolean $i$f$irBlockBody = false;
        $this$buildConstructor_u24lambda_u2d22$iv$iv = $this$irBlockBody$iv;
        int element$iv = ((IrElement)$this$buildPrimaryInlineClassConstructor_u24lambda_u2d29).getStartOffset();
        int endOffset$iv$iv = ((IrElement)$this$buildPrimaryInlineClassConstructor_u24lambda_u2d29).getEndOffset();
        boolean $i$f$irBlockBody2 = false;
        $this$buildPrimaryInlineClassConstructor_u24lambda_u2d26 = new IrBlockBodyBuilder($this$irBlockBody$iv$iv.getContext(), $this$irBlockBody$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv);
        boolean $i$f$blockBody22 = false;
        descriptorVisibility = this_$iv$iv$iv;
        Object object = $this$buildPrimaryInlineClassConstructor_u24lambda_u2d29;
        boolean bl9 = false;
        $this$buildPrimaryInlineClassConstructor_u24lambda_u2d29_u24lambda_u2d28.unaryPlus(ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$buildPrimaryInlineClassConstructor_u24lambda_u2d29_u24lambda_u2d28, SequencesKt.single(IrUtilsKt.getConstructors((IrClass)$this$buildPrimaryInlineClassConstructor_u24lambda_u2d29_u24lambda_u2d28.getContext().getIrBuiltIns().getAnyClass().getOwner()))));
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$buildPrimaryInlineClassConstructor_u24lambda_u2d29_u24lambda_u2d28;
        IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$buildPrimaryInlineClassConstructor_u24lambda_u2d29_u24lambda_u2d28;
        IrValueParameter irValueParameter = irClass2.getThisReceiver();
        Intrinsics.checkNotNull(irValueParameter);
        $this$buildPrimaryInlineClassConstructor_u24lambda_u2d29_u24lambda_u2d28.unaryPlus(ExpressionHelpersKt.irSetField(irBuilderWithScope, ExpressionHelpersKt.irGet(irBuilderWithScope2, irValueParameter), InlineClassesKt.getInlineClassBackingField(irClass2), ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildPrimaryInlineClassConstructor_u24lambda_u2d29_u24lambda_u2d28, ((IrFunction)$this$buildPrimaryInlineClassConstructor_u24lambda_u2d29).getValueParameters().get(0))));
        Unit unit = Unit.INSTANCE;
        ((IrFunction)object).setBody(this_$iv$iv$iv.doBuild());
        IrSimpleFunction $i$f$addConstructor22 = this.context.getInlineClassReplacements().getGetReplacementFunction().invoke(irConstructor2);
        Intrinsics.checkNotNull($i$f$addConstructor22);
        IrSimpleFunction function2 = $i$f$addConstructor22;
        Iterable $this$filterIsInstance$iv = irClass2.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable $i$a$-apply-JvmInlineClassLowering$buildPrimaryInlineClassConstructor$32 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrAnonymousInitializer)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List initBlocks = (List)destination$iv$iv;
        Iterable $this$forEach$iv2 = function2.getValueParameters();
        boolean $i$f$forEach2 = false;
        for (Object element$iv2 : $this$forEach$iv2) {
            IrValueParameter it = (IrValueParameter)element$iv2;
            boolean bl10 = false;
            this.transformChildrenVoid(it);
        }
        Object object2 = LowerUtilsKt.createIrBuilder$default(this.context, function2.getSymbol(), 0, 0, 6, null);
        boolean bl11 = false;
        boolean bl12 = false;
        DeclarationIrBuilder $this$buildPrimaryInlineClassConstructor_u24lambda_u2d32 = object2;
        boolean bl13 = false;
        IrValueParameter argument = function2.getValueParameters().get(0);
        IrBuilderWithScope $this$irBlockBody_u24default$iv = $this$buildPrimaryInlineClassConstructor_u24lambda_u2d32;
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody3 = false;
        IrBlockBodyBuilder $i$f$blockBody22 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        object = this_$iv$iv;
        IrSimpleFunction irSimpleFunction = function2;
        boolean bl14 = false;
        for (IrAnonymousInitializer initBlock : initBlocks) {
            for (IrStatement stmt : initBlock.getBody().getStatements()) {
                $this$buildPrimaryInlineClassConstructor_u24lambda_u2d32_u24lambda_u2d31.unaryPlus(stmt);
            }
        }
        $this$buildPrimaryInlineClassConstructor_u24lambda_u2d32_u24lambda_u2d31.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$buildPrimaryInlineClassConstructor_u24lambda_u2d32_u24lambda_u2d31, this.coerceInlineClasses(ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildPrimaryInlineClassConstructor_u24lambda_u2d32_u24lambda_u2d31, argument), argument.getType(), function2.getReturnType())));
        Unit unit2 = Unit.INSTANCE;
        irSimpleFunction.setBody(this_$iv$iv.doBuild());
        function2.accept(this, null);
        irClass2.getDeclarations().removeAll(initBlocks);
        object2 = irClass2;
        Collection collection = object2.getDeclarations();
        bl12 = false;
        collection.add(function2);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildBoxFunction(IrClass irClass2) {
        void $this$buildBoxFunction_u24lambda_u2d34_u24lambda_u2d33;
        IrSimpleFunction function2 = this.context.getInlineClassReplacements().getGetBoxFunction().invoke(irClass2);
        Object object = LowerUtilsKt.createIrBuilder$default(this.context, function2.getSymbol(), 0, 0, 6, null);
        boolean bl = false;
        boolean bl2 = false;
        DeclarationIrBuilder $this$buildBoxFunction_u24lambda_u2d34 = object;
        boolean bl3 = false;
        IrBuilderWithScope irBuilderWithScope = $this$buildBoxFunction_u24lambda_u2d34;
        IrBuilderWithScope irBuilderWithScope2 = $this$buildBoxFunction_u24lambda_u2d34;
        IrElementBase irElementBase = IrUtilsKt.getPrimaryConstructor(irClass2);
        Intrinsics.checkNotNull(irElementBase);
        irElementBase = ExpressionHelpersKt.irCall(irBuilderWithScope2, (IrConstructorSymbol)irElementBase.getSymbol());
        boolean bl4 = false;
        boolean bl5 = false;
        IrElementBase irElementBase2 = irElementBase;
        IrBuilderWithScope irBuilderWithScope3 = irBuilderWithScope;
        IrSimpleFunction irSimpleFunction = function2;
        boolean bl6 = false;
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.passTypeArgumentsFrom$default((IrFunctionAccessExpression)$this$buildBoxFunction_u24lambda_u2d34_u24lambda_u2d33, function2, 0, 2, null);
        $this$buildBoxFunction_u24lambda_u2d34_u24lambda_u2d33.putValueArgument(0, ExpressionHelpersKt.irGet($this$buildBoxFunction_u24lambda_u2d34, function2.getValueParameters().get(0)));
        Unit unit = Unit.INSTANCE;
        irSimpleFunction.setBody(ExpressionHelpersKt.irExprBody(irBuilderWithScope3, (IrExpression)irElementBase));
        object = irClass2;
        Collection collection = object.getDeclarations();
        bl2 = false;
        collection.add(function2);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildUnboxFunction(IrClass irClass2) {
        void $this$buildUnboxFunction_u24lambda_u2d35;
        void this_$iv$iv;
        IrSimpleFunction function2 = this.context.getInlineClassReplacements().getGetUnboxFunction().invoke(irClass2);
        IrField field = InlineClassesKt.getInlineClassBackingField(irClass2);
        IrBuilderWithScope $this$irBlockBody_u24default$iv = LowerUtilsKt.createIrBuilder$default(this.context, function2.getSymbol(), 0, 0, 6, null);
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        void var10_11 = this_$iv$iv;
        IrSimpleFunction irSimpleFunction = function2;
        boolean bl = false;
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$buildUnboxFunction_u24lambda_u2d35;
        IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
        Intrinsics.checkNotNull(irValueParameter);
        IrGetValueImpl thisVal = ExpressionHelpersKt.irGet(irBuilderWithScope, irValueParameter);
        $this$buildUnboxFunction_u24lambda_u2d35.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$buildUnboxFunction_u24lambda_u2d35, ExpressionHelpersKt.irGetField((IrBuilderWithScope)$this$buildUnboxFunction_u24lambda_u2d35, thisVal, field)));
        Unit unit = Unit.INSTANCE;
        irSimpleFunction.setBody(this_$iv$iv.doBuild());
        IrClass irClass3 = irClass2;
        Collection collection = irClass3.getDeclarations();
        boolean bl2 = false;
        collection.add(function2);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildSpecializedEqualsMethod(IrClass irClass2) {
        void $this$buildSpecializedEqualsMethod_u24lambda_u2d36;
        IrSimpleFunction function2 = this.context.getInlineClassReplacements().getSpecializedEqualsMethod(irClass2, this.context.getIrBuiltIns());
        IrValueParameter left = function2.getValueParameters().get(0);
        IrValueParameter right = function2.getValueParameters().get(1);
        IrType type2 = InlineClassAbiKt.unboxInlineClass(left.getType());
        Object object = LowerUtilsKt.createIrBuilder$default(this.context, irClass2.getSymbol(), 0, 0, 6, null);
        boolean bl = false;
        boolean bl2 = false;
        DeclarationIrBuilder declarationIrBuilder = object;
        IrSimpleFunction irSimpleFunction = function2;
        boolean bl3 = false;
        IrExpressionBody irExpressionBody = ExpressionHelpersKt.irExprBody((IrBuilderWithScope)$this$buildSpecializedEqualsMethod_u24lambda_u2d36, ExpressionHelpersKt.irEquals$default((IrBuilderWithScope)$this$buildSpecializedEqualsMethod_u24lambda_u2d36, this.coerceInlineClasses(ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildSpecializedEqualsMethod_u24lambda_u2d36, left), left.getType(), type2), this.coerceInlineClasses(ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildSpecializedEqualsMethod_u24lambda_u2d36, right), right.getType(), type2), null, 4, null));
        irSimpleFunction.setBody(irExpressionBody);
        object = irClass2;
        Collection collection = object.getDeclarations();
        bl2 = false;
        collection.add(function2);
    }

    /*
     * Unable to fully structure code
     */
    private static final IrExpression specializeEqualsCall$equals(boolean $rightIsUnboxed, IrBuilderWithScope $this_specializeEqualsCall, JvmInlineClassLowering this$0, IrExpression left, IrExpression right) {
        block7: {
            block6: {
                if (IrTypeUtilsKt.isUnsigned(left.getType()) && IrTypeUtilsKt.isUnsigned(right.getType()) && $rightIsUnboxed) {
                    return ExpressionHelpersKt.irEquals$default($this_specializeEqualsCall, this$0.coerceToUnboxed(left), this$0.coerceToUnboxed(right), null, 4, null);
                }
                var6_5 = IrTypesKt.getClassOrNull(left.getType());
                Intrinsics.checkNotNull(var6_5);
                klass = (IrClass)var6_5.getOwner();
                if (!$rightIsUnboxed) break block6;
                v0 = this$0.context.getInlineClassReplacements().getSpecializedEqualsMethod(klass, $this_specializeEqualsCall.getContext().getIrBuiltIns());
                break block7;
            }
            $this$single$iv = IrUtilsKt.getFunctions(klass);
            $i$f$single = false;
            single$iv = null;
            found$iv = false;
            var12_12 = $this$single$iv.iterator();
            while (var12_12.hasNext()) {
                it = element$iv = var12_12.next();
                $i$a$-single-JvmInlineClassLowering$specializeEqualsCall$equals$equalsMethod$equals$1 = false;
                if (!Intrinsics.areEqual(it.getName().asString(), "equals")) ** GOTO lbl-1000
                var16_16 = it.getOverriddenSymbols();
                var17_17 = false;
                if (var16_16.isEmpty() == false) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (!v1) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            equals = single$iv;
            var8_7 = this$0.context.getInlineClassReplacements().getGetReplacementFunction().invoke(equals);
            Intrinsics.checkNotNull(var8_7);
            v0 = var8_7;
        }
        equalsMethod = v0;
        var7_18 = ExpressionHelpersKt.irCall($this_specializeEqualsCall, equalsMethod);
        var8_8 = false;
        var9_9 = false;
        $this$specializeEqualsCall_u24equals_u24lambda_u2d18 = var7_18;
        $i$a$-apply-JvmInlineClassLowering$specializeEqualsCall$equals$1 = false;
        $this$specializeEqualsCall_u24equals_u24lambda_u2d18.putValueArgument(0, left);
        $this$specializeEqualsCall_u24equals_u24lambda_u2d18.putValueArgument(1, right);
        return var7_18;
    }

    public static final /* synthetic */ List access$transformFunctionFlat(JvmInlineClassLowering $this, IrFunction function2) {
        return $this.transformFunctionFlat(function2);
    }
}

