/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.JvmArgumentsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmModulePathRoot;
import org.jetbrains.kotlin.cli.jvm.modules.CoreJrtFileSystem;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;
import org.jetbrains.kotlin.config.JVMAssertionsMode;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JVMConstructorCallNormalizationMode;
import org.jetbrains.kotlin.config.JvmAbiStability;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.config.JvmStringConcat;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.utils.KotlinPaths;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u001a\u0012\u0010\r\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0012\u0010\u0010\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0012\u0010\u0011\u001a\u00020\b*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0012\u0010\u0012\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u001c\u0010\u0013\u001a\u00020\u0006*\u00020\u00022\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000e\u001a\u00020\u000f\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0002\u001a\u0012\u0010\u0016\u001a\u00020\b*\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0012\u0010\u0018\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0019"}, d2={"messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "getMessageCollector", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;)Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "addModularRootIfNotNull", "", "isModularJava", "", "moduleName", "", "file", "Ljava/io/File;", "configureAdvancedJvmOptions", "arguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "configureExplicitContentRoots", "configureJdkHome", "configureKlibPaths", "configureStandardLibs", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "registerJavacIfNeeded", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "setupJvmSpecificArguments", "cli"})
public final class JvmArgumentsKt {
    public static final void setupJvmSpecificArguments(@NotNull CompilerConfiguration $this$setupJvmSpecificArguments, @NotNull K2JVMCompilerArguments arguments2) {
        Object object;
        Object jvmTarget;
        Object object2;
        Intrinsics.checkParameterIsNotNull($this$setupJvmSpecificArguments, "<this>");
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        $this$setupJvmSpecificArguments.put(JVMConfigurationKeys.INCLUDE_RUNTIME, arguments2.getIncludeRuntime());
        String[] stringArray = arguments2.getFriendPaths();
        $this$setupJvmSpecificArguments.putIfNotNull(JVMConfigurationKeys.FRIEND_PATHS, stringArray == null ? null : ArraysKt.asList(stringArray));
        if (arguments2.getJvmTarget() != null) {
            object2 = arguments2.getJvmTarget();
            if (object2 == null) {
                Intrinsics.throwNpe();
            }
            if ((jvmTarget = JvmTarget.Companion.fromString((String)object2)) != null) {
                $this$setupJvmSpecificArguments.put(JVMConfigurationKeys.JVM_TARGET, jvmTarget);
            } else {
                MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$setupJvmSpecificArguments), CompilerMessageSeverity.ERROR, "Unknown JVM target version: " + arguments2.getJvmTarget() + "\nSupported versions: " + ArraysKt.joinToString$default(JvmTarget.values(), null, null, null, 0, null, (Function1)setupJvmSpecificArguments.1.INSTANCE, 31, null), null, 4, null);
            }
        }
        object2 = (object = $this$setupJvmSpecificArguments.get(JVMConfigurationKeys.JVM_TARGET)) == null ? JvmTarget.DEFAULT : object;
        Intrinsics.checkExpressionValueIsNotNull(object2, "get(JVMConfigurationKeys.JVM_TARGET) ?: JvmTarget.DEFAULT");
        jvmTarget = object2;
        if (((JvmTarget)jvmTarget).getMajorVersion() < JvmTarget.JVM_1_8.getMajorVersion()) {
            JvmDefaultMode jvmDefaultMode = CommonConfigurationKeysKt.getLanguageVersionSettings($this$setupJvmSpecificArguments).getFlag(JvmAnalysisFlags.INSTANCE.getJvmDefaultMode());
            if (jvmDefaultMode.getForAllMethodsWithBody()) {
                MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$setupJvmSpecificArguments), CompilerMessageSeverity.ERROR, "'-Xjvm-default=" + jvmDefaultMode.getDescription() + "' is only supported since JVM target 1.8. Recompile with '-jvm-target 1.8'", null, 4, null);
            }
        }
        if (arguments2.getStringConcat() != null) {
            JvmStringConcat runtimeStringConcat;
            object = arguments2.getStringConcat();
            if (object == null) {
                Intrinsics.throwNpe();
            }
            if ((runtimeStringConcat = JvmStringConcat.Companion.fromString((String)object)) != null) {
                $this$setupJvmSpecificArguments.put(JVMConfigurationKeys.STRING_CONCAT, runtimeStringConcat);
                if (((JvmTarget)jvmTarget).getMajorVersion() < JvmTarget.JVM_9.getMajorVersion() && runtimeStringConcat != JvmStringConcat.INLINE) {
                    MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$setupJvmSpecificArguments), CompilerMessageSeverity.WARNING, "`-Xstring-concat=" + arguments2.getStringConcat() + "` does nothing with JVM target `" + ((JvmTarget)jvmTarget).getDescription() + "`.", null, 4, null);
                }
            } else {
                MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$setupJvmSpecificArguments), CompilerMessageSeverity.ERROR, "Unknown -Xstring-concat mode: " + arguments2.getJvmTarget() + "\nSupported versions: " + ArraysKt.joinToString$default((Object[])JvmStringConcat.values(), null, null, null, 0, null, (Function1)setupJvmSpecificArguments.2.INSTANCE, 31, null), null, 4, null);
            }
        }
        $this$setupJvmSpecificArguments.addAll(JVMConfigurationKeys.ADDITIONAL_JAVA_MODULES, (Collection)((object2 = arguments2.getAdditionalJavaModules()) == null ? null : ArraysKt.asList(object2)));
    }

    public static final boolean configureJdkHome(@NotNull CompilerConfiguration $this$configureJdkHome, @NotNull K2JVMCompilerArguments arguments2) {
        Intrinsics.checkParameterIsNotNull($this$configureJdkHome, "<this>");
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        if (arguments2.getNoJdk()) {
            $this$configureJdkHome.put(JVMConfigurationKeys.NO_JDK, true);
            if (arguments2.getJdkHome() != null) {
                MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$configureJdkHome), CompilerMessageSeverity.STRONG_WARNING, "The '-jdk-home' option is ignored because '-no-jdk' is specified", null, 4, null);
            }
            return true;
        }
        if (arguments2.getJdkHome() != null) {
            File jdkHome2;
            String string2 = arguments2.getJdkHome();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            if (!(jdkHome2 = new File(string2)).exists()) {
                MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$configureJdkHome), CompilerMessageSeverity.ERROR, Intrinsics.stringPlus("JDK home directory does not exist: ", jdkHome2), null, 4, null);
                return false;
            }
            MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$configureJdkHome), CompilerMessageSeverity.LOGGING, Intrinsics.stringPlus("Using JDK home directory ", jdkHome2), null, 4, null);
            $this$configureJdkHome.put(JVMConfigurationKeys.JDK_HOME, jdkHome2);
        }
        return true;
    }

    public static final void configureExplicitContentRoots(@NotNull CompilerConfiguration $this$configureExplicitContentRoots, @NotNull K2JVMCompilerArguments arguments2) {
        List list2;
        String modularRoot;
        List list3;
        Intrinsics.checkParameterIsNotNull($this$configureExplicitContentRoots, "<this>");
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        String string2 = arguments2.getJavaModulePath();
        if (string2 == null) {
            list3 = null;
        } else {
            char[] cArray = new char[]{File.pathSeparatorChar};
            list3 = StringsKt.split$default((CharSequence)string2, cArray, false, 0, 6, null);
        }
        string2 = list3;
        boolean bl = false;
        Object object = string2;
        if (object == null) {
            object = CollectionsKt.emptyList();
        }
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            modularRoot = (String)iterator2.next();
            $this$configureExplicitContentRoots.add(CLIConfigurationKeys.CONTENT_ROOTS, new JvmModulePathRoot(new File(modularRoot)));
        }
        if (arguments2.getBuildFile() != null) {
            return;
        }
        modularRoot = arguments2.getClasspath();
        if (modularRoot == null) {
            list2 = null;
        } else {
            char[] cArray = new char[]{File.pathSeparatorChar};
            list2 = StringsKt.split$default((CharSequence)modularRoot, cArray, false, 0, 6, null);
        }
        modularRoot = list2;
        boolean bl2 = false;
        Object object2 = modularRoot;
        if (object2 == null) {
            object2 = CollectionsKt.emptyList();
        }
        iterator2 = object2.iterator();
        while (iterator2.hasNext()) {
            String path2 = (String)iterator2.next();
            $this$configureExplicitContentRoots.add(CLIConfigurationKeys.CONTENT_ROOTS, new JvmClasspathRoot(new File(path2)));
        }
    }

    public static final void configureStandardLibs(@NotNull CompilerConfiguration $this$configureStandardLibs, @Nullable KotlinPaths paths, @NotNull K2JVMCompilerArguments arguments2) {
        Intrinsics.checkParameterIsNotNull($this$configureStandardLibs, "<this>");
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        boolean isModularJava = JvmArgumentsKt.isModularJava($this$configureStandardLibs);
        if (!arguments2.getNoStdlib()) {
            JvmArgumentsKt.configureStandardLibs$addRoot($this$configureStandardLibs, isModularJava, paths, "kotlin.stdlib", "kotlin-stdlib.jar", configureStandardLibs.1.INSTANCE, "'-no-stdlib'");
            JvmArgumentsKt.configureStandardLibs$addRoot($this$configureStandardLibs, isModularJava, paths, "kotlin.script.runtime", "kotlin-script-runtime.jar", configureStandardLibs.2.INSTANCE, "'-no-stdlib'");
        }
        if (!arguments2.getNoReflect() && !arguments2.getNoStdlib()) {
            JvmArgumentsKt.configureStandardLibs$addRoot($this$configureStandardLibs, isModularJava, paths, "kotlin.reflect", "kotlin-reflect.jar", configureStandardLibs.3.INSTANCE, "'-no-reflect' or '-no-stdlib'");
        }
    }

    public static final boolean isModularJava(@NotNull CompilerConfiguration $this$isModularJava) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull($this$isModularJava, "<this>");
        File file2 = $this$isModularJava.get(JVMConfigurationKeys.JDK_HOME);
        if (file2 == null) {
            bl = false;
        } else {
            boolean bl2;
            File file3 = file2;
            boolean bl3 = false;
            boolean bl4 = false;
            File it = file3;
            boolean bl5 = false;
            bl = bl2 = CoreJrtFileSystem.Companion.isModularJdk(it);
        }
        return bl;
    }

    public static final void addModularRootIfNotNull(@NotNull CompilerConfiguration $this$addModularRootIfNotNull, boolean isModularJava, @NotNull String moduleName, @Nullable File file2) {
        Intrinsics.checkParameterIsNotNull($this$addModularRootIfNotNull, "<this>");
        Intrinsics.checkParameterIsNotNull(moduleName, "moduleName");
        if (file2 != null) {
            if (isModularJava) {
                $this$addModularRootIfNotNull.add(CLIConfigurationKeys.CONTENT_ROOTS, new JvmModulePathRoot(file2));
                $this$addModularRootIfNotNull.add(JVMConfigurationKeys.ADDITIONAL_JAVA_MODULES, moduleName);
            } else {
                $this$addModularRootIfNotNull.add(CLIConfigurationKeys.CONTENT_ROOTS, new JvmClasspathRoot(file2));
            }
        }
    }

    public static final boolean registerJavacIfNeeded(@NotNull KotlinCoreEnvironment $this$registerJavacIfNeeded, @NotNull K2JVMCompilerArguments arguments2) {
        Intrinsics.checkParameterIsNotNull($this$registerJavacIfNeeded, "<this>");
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        if (arguments2.getUseJavac()) {
            $this$registerJavacIfNeeded.getConfiguration().put(JVMConfigurationKeys.USE_JAVAC, true);
            if (arguments2.getCompileJava()) {
                $this$registerJavacIfNeeded.getConfiguration().put(JVMConfigurationKeys.COMPILE_JAVA, true);
            }
            return KotlinCoreEnvironment.registerJavac$default($this$registerJavacIfNeeded, null, null, arguments2.getJavacArguments(), null, null, 27, null);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final void configureAdvancedJvmOptions(@NotNull CompilerConfiguration $this$configureAdvancedJvmOptions, @NotNull K2JVMCompilerArguments arguments) {
        Intrinsics.checkParameterIsNotNull($this$configureAdvancedJvmOptions, "<this>");
        Intrinsics.checkParameterIsNotNull(arguments, "arguments");
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.PARAMETERS_METADATA, arguments.getJavaParameters());
        if (arguments.getUseFir()) ** GOTO lbl-1000
        v0 = CommonConfigurationKeysKt.getLanguageVersionSettings($this$configureAdvancedJvmOptions).supportsFeature(LanguageFeature.JvmIrEnabledByDefault) ? !arguments.getUseOldBackend() : arguments.getUseIR() != false && arguments.getUseOldBackend() == false;
        if (v0) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = useIR = false;
        }
        if (arguments.getUseIR() && arguments.getUseOldBackend()) {
            MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions), CompilerMessageSeverity.STRONG_WARNING, "Both -Xuse-ir and -Xuse-old-backend are passed. This is an inconsistent configuration. The compiler will use the " + (useIR != false ? "JVM IR" : "old JVM") + " backend", null, 4, null);
        }
        MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions), CompilerMessageSeverity.LOGGING, "Using " + (useIR != false ? "JVM IR" : "old JVM") + " backend", null, 4, null);
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.IR, useIR);
        abiStability = JvmAbiStability.Companion.fromStringOrNull(arguments.getAbiStability());
        if (arguments.getAbiStability() != null) {
            if (abiStability == null) {
                var4_4 = JvmAbiStability.values();
                var19_5 = new StringBuilder().append("Unknown ABI stability mode: ").append((Object)arguments.getAbiStability()).append(", supported modes: ");
                var18_6 = CompilerMessageSeverity.ERROR;
                var17_7 = JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions);
                $i$f$map = false;
                var6_10 /* !! */  = $this$map$iv;
                destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                $i$f$mapTo = false;
                for (Enum item$iv$iv : $this$mapTo$iv$iv) {
                    var13_26 = item$iv$iv;
                    var20_30 = destination$iv$iv;
                    $i$a$-map-JvmArgumentsKt$configureAdvancedJvmOptions$1 = false;
                    var21_31 = it.getDescription();
                    var20_30.add(var21_31);
                }
                var20_30 = (List)destination$iv$iv;
                MessageCollector.DefaultImpls.report$default(var17_7, var18_6, var19_5.append(var20_30).toString(), null, 4, null);
            } else if (!useIR && abiStability == JvmAbiStability.UNSTABLE) {
                MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions), CompilerMessageSeverity.ERROR, "-Xabi-stability=unstable is not supported in the old JVM backend", null, 4, null);
            } else {
                $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.ABI_STABILITY, abiStability);
            }
        }
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.DO_NOT_CLEAR_BINDING_CONTEXT, arguments.getDoNotClearBindingContext());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.DISABLE_CALL_ASSERTIONS, arguments.getNoCallAssertions());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.DISABLE_RECEIVER_ASSERTIONS, arguments.getNoReceiverAssertions());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.DISABLE_PARAM_ASSERTIONS, arguments.getNoParamAssertions());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.NO_EXCEPTION_ON_EXPLICIT_EQUALS_FOR_BOXED_NULL, arguments.getNoExceptionOnExplicitEqualsForBoxedNull());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.DISABLE_OPTIMIZATION, arguments.getNoOptimize());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.EMIT_JVM_TYPE_ANNOTATIONS, arguments.getEmitJvmTypeAnnotations());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.NO_OPTIMIZED_CALLABLE_REFERENCES, arguments.getNoOptimizedCallableReferences());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.NO_KOTLIN_NOTHING_VALUE_EXCEPTION, arguments.getNoKotlinNothingValueException());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.NO_RESET_JAR_TIMESTAMPS, arguments.getNoResetJarTimestamps());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.NO_UNIFIED_NULL_CHECKS, arguments.getNoUnifiedNullChecks());
        if (!JVMConstructorCallNormalizationMode.Companion.isSupportedValue(arguments.getConstructorCallNormalizationMode())) {
            $this$map$iv = JVMConstructorCallNormalizationMode.values();
            var19_5 = new StringBuilder().append("Unknown constructor call normalization mode: ").append((Object)arguments.getConstructorCallNormalizationMode()).append(", supported modes: ");
            var18_6 = CompilerMessageSeverity.ERROR;
            var17_7 = JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions);
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>($this$map$iv.length);
            $i$f$mapTo = false;
            var9_17 = $this$mapTo$iv$iv;
            var10_19 = var9_17.length;
            for (var11_21 = 0; var11_21 < var10_19; ++var11_21) {
                it = item$iv$iv = var9_17[var11_21];
                var20_30 = destination$iv$iv;
                $i$a$-map-JvmArgumentsKt$configureAdvancedJvmOptions$2 = false;
                var21_31 = it.getDescription();
                var20_30.add(var21_31);
            }
            var20_30 = (List)destination$iv$iv;
            MessageCollector.DefaultImpls.report$default(var17_7, var18_6, var19_5.append(var20_30).toString(), null, 4, null);
        }
        if ((constructorCallNormalizationMode = JVMConstructorCallNormalizationMode.Companion.fromStringOrNull(arguments.getConstructorCallNormalizationMode())) != null) {
            $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.CONSTRUCTOR_CALL_NORMALIZATION_MODE, constructorCallNormalizationMode);
        }
        if ((assertionsMode = JVMAssertionsMode.Companion.fromStringOrNull(arguments.getAssertionsMode())) == null) {
            $this$mapTo$iv$iv = JVMAssertionsMode.values();
            var19_5 = new StringBuilder().append("Unknown assertions mode: ").append((Object)arguments.getAssertionsMode()).append(", supported modes: ");
            var18_6 = CompilerMessageSeverity.ERROR;
            var17_7 = JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions);
            $i$f$map = false;
            $i$f$mapTo = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
            $i$f$mapTo = false;
            var11_22 = $this$mapTo$iv$iv;
            var12_25 = ((void)var11_22).length;
            for (var13_27 = 0; var13_27 < var12_25; ++var13_27) {
                var15_32 = item$iv$iv = var11_22[var13_27];
                var20_30 = destination$iv$iv;
                $i$a$-map-JvmArgumentsKt$configureAdvancedJvmOptions$3 = false;
                var21_31 = it.getDescription();
                var20_30.add(var21_31);
            }
            var20_30 = (List)destination$iv$iv;
            MessageCollector.DefaultImpls.report$default(var17_7, var18_6, var19_5.append(var20_30).toString(), null, 4, null);
        }
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.ASSERTIONS_MODE, (var6_10 /* !! */  = assertionsMode) == null ? JVMAssertionsMode.DEFAULT : var6_10 /* !! */ );
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.USE_TYPE_TABLE, arguments.getUseTypeTable());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.SKIP_RUNTIME_VERSION_CHECK, arguments.getSkipRuntimeVersionCheck());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.USE_PSI_CLASS_FILES_READING, arguments.getUseOldClassFilesReading());
        if (arguments.getUseOldClassFilesReading()) {
            MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions), CompilerMessageSeverity.INFO, "Using the old java class files reading implementation", null, 4, null);
        }
        $this$configureAdvancedJvmOptions.put(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, arguments.getAllowKotlinPackage());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.USE_SINGLE_MODULE, arguments.getSingleModule());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.USE_OLD_SPILLED_VAR_TYPE_ANALYSIS, arguments.getUseOldSpilledVarTypeAnalysis());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.USE_OLD_INLINE_CLASSES_MANGLING_SCHEME, arguments.getUseOldInlineClassesManglingScheme());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.ENABLE_JVM_PREVIEW, arguments.getEnableJvmPreview());
        if (arguments.getEnableJvmPreview()) {
            MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions), CompilerMessageSeverity.INFO, "Using preview Java language features", null, 4, null);
        }
        if ((var6_10 /* !! */  = arguments.getDeclarationsOutputPath()) != null) {
            var7_13 /* !! */  = var6_10 /* !! */ ;
            var8_16 = false;
            var9_18 = false;
            it /* !! */  = var7_13 /* !! */ ;
            $i$a$-let-JvmArgumentsKt$configureAdvancedJvmOptions$4 = false;
            $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.DECLARATIONS_JSON_PATH, it /* !! */ );
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void configureKlibPaths(@NotNull CompilerConfiguration $this$configureKlibPaths, @NotNull K2JVMCompilerArguments arguments2) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Intrinsics.checkParameterIsNotNull($this$configureKlibPaths, "<this>");
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        String string2 = arguments2.getKlibLibraries();
        if (string2 == null) {
            return;
        }
        String libraries = string2;
        boolean bl = arguments2.getUseIR() && !arguments2.getUseOldBackend();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-JvmArgumentsKt$configureKlibPaths$322 = false;
            String $i$a$-assert-JvmArgumentsKt$configureKlibPaths$322 = "Klib libraries can only be used with IR backend";
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-JvmArgumentsKt$configureKlibPaths$322));
        }
        Object object = libraries;
        Object object2 = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull(object2, "pathSeparator");
        int $i$a$-assert-JvmArgumentsKt$configureKlibPaths$322 = 0;
        object2 = new Regex((String)object2);
        $i$a$-assert-JvmArgumentsKt$configureKlibPaths$322 = 0;
        boolean bl3 = false;
        object = ((Regex)object2).split((CharSequence)object, $i$a$-assert-JvmArgumentsKt$configureKlibPaths$322);
        CompilerConfigurationKey<List<String>> compilerConfigurationKey = JVMConfigurationKeys.KLIB_PATHS;
        CompilerConfiguration compilerConfiguration = $this$configureKlibPaths;
        boolean $i$f$filterNot = false;
        void $i$a$-assert-JvmArgumentsKt$configureKlibPaths$322 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            CharSequence p0 = (CharSequence)element$iv$iv;
            boolean bl4 = false;
            CharSequence charSequence = p0;
            boolean bl5 = false;
            if (charSequence.length() == 0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        compilerConfiguration.put(compilerConfigurationKey, list2);
    }

    private static final MessageCollector getMessageCollector(CompilerConfiguration $this$messageCollector) {
        MessageCollector messageCollector2 = $this$messageCollector.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkExpressionValueIsNotNull(messageCollector2, "getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY)");
        return messageCollector2;
    }

    private static final void configureStandardLibs$addRoot(CompilerConfiguration $this_configureStandardLibs, boolean $isModularJava, KotlinPaths $paths, String moduleName, String libraryName2, Function1<? super KotlinPaths, ? extends File> getLibrary, String noLibraryArgument) {
        JvmArgumentsKt.addModularRootIfNotNull($this_configureStandardLibs, $isModularJava, moduleName, UtilsKt.getLibraryFromHome($paths, getLibrary, libraryName2, JvmArgumentsKt.getMessageCollector($this_configureStandardLibs), noLibraryArgument));
    }
}

