/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang.jvm.types;

import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JvmPrimitiveTypeKind {
    public static final JvmPrimitiveTypeKind BOOLEAN = new JvmPrimitiveTypeKind("boolean", "java.lang.Boolean", "Z");
    public static final JvmPrimitiveTypeKind BYTE = new JvmPrimitiveTypeKind("byte", "java.lang.Byte", "B");
    public static final JvmPrimitiveTypeKind CHAR = new JvmPrimitiveTypeKind("char", "java.lang.Character", "C");
    public static final JvmPrimitiveTypeKind DOUBLE = new JvmPrimitiveTypeKind("double", "java.lang.Double", "D");
    public static final JvmPrimitiveTypeKind FLOAT = new JvmPrimitiveTypeKind("float", "java.lang.Float", "F");
    public static final JvmPrimitiveTypeKind INT = new JvmPrimitiveTypeKind("int", "java.lang.Integer", "I");
    public static final JvmPrimitiveTypeKind LONG = new JvmPrimitiveTypeKind("long", "java.lang.Long", "J");
    public static final JvmPrimitiveTypeKind SHORT = new JvmPrimitiveTypeKind("short", "java.lang.Short", "S");
    public static final JvmPrimitiveTypeKind VOID = new JvmPrimitiveTypeKind("void", "java.lang.Void", "V");
    private final String myName;
    private final String myBoxedFqn;
    private final String myBinaryName;
    private static final Map<String, JvmPrimitiveTypeKind> ourNameToKind;
    private static final Map<String, JvmPrimitiveTypeKind> ourFqnToKind;

    private JvmPrimitiveTypeKind(@NotNull String name2, @NotNull String boxedFqn, @NotNull String binaryName) {
        if (name2 == null) {
            JvmPrimitiveTypeKind.$$$reportNull$$$0(0);
        }
        if (boxedFqn == null) {
            JvmPrimitiveTypeKind.$$$reportNull$$$0(1);
        }
        if (binaryName == null) {
            JvmPrimitiveTypeKind.$$$reportNull$$$0(2);
        }
        this.myName = name2;
        this.myBoxedFqn = boxedFqn;
        this.myBinaryName = binaryName;
    }

    @Contract(pure=true)
    @NotNull
    public String getName() {
        String string2 = this.myName;
        if (string2 == null) {
            JvmPrimitiveTypeKind.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public String getBoxedFqn() {
        String string2 = this.myBoxedFqn;
        if (string2 == null) {
            JvmPrimitiveTypeKind.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public String getBinaryName() {
        String string2 = this.myBinaryName;
        if (string2 == null) {
            JvmPrimitiveTypeKind.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static JvmPrimitiveTypeKind getKindByName(@Nullable String name2) {
        return ourNameToKind.get(name2);
    }

    @Contract(pure=true)
    @NotNull
    public static Collection<String> getBoxedFqns() {
        Collection<String> collection = Collections.unmodifiableCollection(ourFqnToKind.keySet());
        if (collection == null) {
            JvmPrimitiveTypeKind.$$$reportNull$$$0(6);
        }
        return collection;
    }

    static {
        JvmPrimitiveTypeKind[] values2 = new JvmPrimitiveTypeKind[]{BOOLEAN, BYTE, CHAR, DOUBLE, FLOAT, INT, LONG, SHORT, VOID};
        THashMap<String, JvmPrimitiveTypeKind> nameToKind = new THashMap<String, JvmPrimitiveTypeKind>();
        THashMap<String, JvmPrimitiveTypeKind> fqnToKind = new THashMap<String, JvmPrimitiveTypeKind>();
        for (JvmPrimitiveTypeKind kind : values2) {
            nameToKind.put(kind.getName(), kind);
            fqnToKind.put(kind.getBoxedFqn(), kind);
        }
        nameToKind.compact();
        fqnToKind.compact();
        ourNameToKind = nameToKind;
        ourFqnToKind = fqnToKind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boxedFqn";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/lang/jvm/types/JvmPrimitiveTypeKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/jvm/types/JvmPrimitiveTypeKind";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBoxedFqn";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBoxedFqns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

