/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.core.JavaPsiBundle;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportStaticReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportStaticStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaParserFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiNamedElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.ResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.filters.ClassFilter;
import org.jetbrains.kotlin.com.intellij.psi.filters.ElementFilter;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.ResolveCache;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.StaticImportResolveProcessor;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.Factory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.processor.FilterScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.util.PsiScopesUtil;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class PsiImportStaticReferenceElementImpl
extends CompositePsiElement
implements PsiImportStaticReferenceElement {
    private static final Logger LOG = Logger.getInstance(PsiImportStaticReferenceElementImpl.class);
    private volatile String myCanonicalText;

    public PsiImportStaticReferenceElementImpl() {
        super(JavaElementType.IMPORT_STATIC_REFERENCE);
    }

    @Override
    public int getTextOffset() {
        ASTNode refName = this.findChildByRole(53);
        if (refName != null) {
            return refName.getStartOffset();
        }
        return super.getTextOffset();
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myCanonicalText = null;
    }

    @Override
    public final ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 53: {
                return this.findChildByType(JavaTokenType.IDENTIFIER);
            }
            case 54: {
                TreeElement node = this.getFirstChildNode();
                return node.getElementType() == JavaElementType.JAVA_CODE_REFERENCE ? node : null;
            }
            case 55: 
        }
        return this.findChildByType(JavaTokenType.DOT);
    }

    @Override
    public final int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiImportStaticReferenceElementImpl.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaElementType.JAVA_CODE_REFERENCE) {
            return 54;
        }
        if (i == JavaTokenType.DOT) {
            return 55;
        }
        if (i == JavaTokenType.IDENTIFIER) {
            return 53;
        }
        return 0;
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return this.findChildByRoleAsPsiElement(53);
    }

    @Override
    public PsiReferenceParameterList getParameterList() {
        return null;
    }

    @Override
    public PsiType @NotNull [] getTypeParameters() {
        if (PsiType.EMPTY_ARRAY == null) {
            PsiImportStaticReferenceElementImpl.$$$reportNull$$$0(1);
        }
        return PsiType.EMPTY_ARRAY;
    }

    @Override
    public PsiElement getQualifier() {
        return this.findChildByRoleAsPsiElement(54);
    }

    @Override
    public PsiJavaCodeReferenceElement getClassReference() {
        return (PsiJavaCodeReferenceElement)this.findChildByRoleAsPsiElement(54);
    }

    @Override
    public PsiImportStaticStatement bindToTargetClass(PsiClass aClass2) throws IncorrectOperationException {
        String qualifiedName2 = aClass2.getQualifiedName();
        if (qualifiedName2 == null) {
            throw new IncorrectOperationException();
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.getProject()).getParserFacade();
        CompositeElement newRef = (CompositeElement)parserFacade.createReferenceFromText(qualifiedName2, null).getNode();
        if (this.getQualifier() != null) {
            this.replaceChildInternal(this.findChildByRole(54), newRef);
            return (PsiImportStaticStatement)this.getParent();
        }
        LeafElement dot = Factory.createSingleLeafElement(JavaTokenType.DOT, ".", 0, 1, SharedImplUtil.findCharTableByTree(newRef), this.getManager());
        newRef.rawInsertAfterMe(dot);
        CompositeElement errorElement = Factory.createErrorElement(JavaPsiBundle.message("import.statement.identifier.or.asterisk.expected.", new Object[0]));
        dot.rawInsertAfterMe(errorElement);
        CompositeElement parentComposite = (CompositeElement)SourceTreeToPsiMap.psiElementToTree(this.getParent());
        parentComposite.addInternal(newRef, errorElement, this, Boolean.TRUE);
        parentComposite.deleteChildInternal(this);
        return (PsiImportStaticStatement)SourceTreeToPsiMap.treeElementToPsi(parentComposite);
    }

    @Override
    public boolean isQualified() {
        return this.findChildByRole(54) != null;
    }

    @Override
    public String getQualifiedName() {
        return this.getCanonicalText();
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    public String getReferenceName() {
        ASTNode childByRole = this.findChildByRole(53);
        if (childByRole == null) {
            return "";
        }
        return childByRole.getText();
    }

    @Override
    @NotNull
    public PsiElement getElement() {
        PsiImportStaticReferenceElementImpl psiImportStaticReferenceElementImpl = this;
        if (psiImportStaticReferenceElementImpl == null) {
            PsiImportStaticReferenceElementImpl.$$$reportNull$$$0(2);
        }
        return psiImportStaticReferenceElementImpl;
    }

    @Override
    @NotNull
    public TextRange getRangeInElement() {
        TreeElement nameChild = (TreeElement)this.findChildByRole(53);
        if (nameChild == null) {
            return new TextRange(0, this.getTextLength());
        }
        int startOffset = nameChild.getStartOffsetInParent();
        return new TextRange(startOffset, startOffset + nameChild.getTextLength());
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String canonicalText = this.myCanonicalText;
        if (canonicalText == null) {
            this.myCanonicalText = canonicalText = this.calcCanonicalText();
        }
        String string2 = canonicalText;
        if (string2 == null) {
            PsiImportStaticReferenceElementImpl.$$$reportNull$$$0(3);
        }
        return string2;
    }

    private String calcCanonicalText() {
        PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)this.getQualifier();
        if (referenceElement == null) {
            return this.getReferenceName();
        }
        return referenceElement.getCanonicalText() + "." + this.getReferenceName();
    }

    @Override
    public String toString() {
        return "PsiImportStaticReferenceElement:" + this.getText();
    }

    @Override
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult[] results = this.multiResolve(incompleteCode);
        if (results.length == 1) {
            JavaResolveResult javaResolveResult = results[0];
            if (javaResolveResult == null) {
                PsiImportStaticReferenceElementImpl.$$$reportNull$$$0(4);
            }
            return javaResolveResult;
        }
        JavaResolveResult javaResolveResult = JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            PsiImportStaticReferenceElementImpl.$$$reportNull$$$0(5);
        }
        return javaResolveResult;
    }

    @Override
    public JavaResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        PsiFile file2 = this.getContainingFile();
        ResolveCache resolveCache = ResolveCache.getInstance(file2.getProject());
        ResolveResult[] results = resolveCache.resolveWithCaching(this, OurGenericsResolver.INSTANCE, false, incompleteCode, file2);
        JavaResolveResult[] javaResolveResultArray = results instanceof JavaResolveResult[] ? (JavaResolveResult[])results : JavaResolveResult.EMPTY_ARRAY;
        if (javaResolveResultArray == null) {
            PsiImportStaticReferenceElementImpl.$$$reportNull$$$0(6);
        }
        return javaResolveResultArray;
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    @Override
    public PsiElement resolve() {
        return this.advancedResolve(false).getElement();
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        String name2;
        if (element == null) {
            PsiImportStaticReferenceElementImpl.$$$reportNull$$$0(7);
        }
        if ((name2 = this.getReferenceName()) == null || !(element instanceof PsiNamedElement) || !name2.equals(((PsiNamedElement)element).getName())) {
            return false;
        }
        for (JavaResolveResult result2 : this.multiResolve(false)) {
            if (!this.getManager().areElementsEquivalent(result2.getElement(), element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        PsiElement oldIdentifier;
        if (newElementName == null) {
            PsiImportStaticReferenceElementImpl.$$$reportNull$$$0(8);
        }
        if ((oldIdentifier = this.findChildByRoleAsPsiElement(53)) == null) {
            throw new IncorrectOperationException();
        }
        PsiIdentifier identifier = JavaPsiFacade.getElementFactory(this.getProject()).createIdentifier(newElementName);
        oldIdentifier.replace(identifier);
        return this;
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PsiImportStaticReferenceElementImpl.$$$reportNull$$$0(9);
        }
        if (!(element instanceof PsiMember) || !(element instanceof PsiNamedElement) || ((PsiNamedElement)element).getName() == null) {
            throw new IncorrectOperationException();
        }
        if (!((PsiModifierListOwner)element).hasModifierProperty("static")) {
            if (element instanceof PsiClass && ((PsiClass)element).getContainingClass() == null) {
                return this.replaceWithRegularImport((PsiClass)element);
            }
            throw new IncorrectOperationException();
        }
        PsiClass containingClass = ((PsiMember)element).getContainingClass();
        if (containingClass == null) {
            throw new IncorrectOperationException();
        }
        PsiElement qualifier = this.getQualifier();
        if (qualifier == null) {
            throw new IncorrectOperationException();
        }
        ((PsiReference)((Object)qualifier)).bindToElement(containingClass);
        PsiElement oldIdentifier = this.findChildByRoleAsPsiElement(53);
        if (oldIdentifier == null) {
            throw new IncorrectOperationException();
        }
        PsiIdentifier identifier = JavaPsiFacade.getElementFactory(this.getProject()).createIdentifier(((PsiNamedElement)element).getName());
        oldIdentifier.replace(identifier);
        return this;
    }

    private PsiElement replaceWithRegularImport(PsiClass psiClass) throws IncorrectOperationException {
        PsiImportStaticStatement baseStatement = PsiTreeUtil.getParentOfType(this.getElement(), PsiImportStaticStatement.class);
        PsiImportStatement statement2 = JavaPsiFacade.getElementFactory(this.getProject()).createImportStatement(psiClass);
        statement2 = (PsiImportStatement)baseStatement.replace(statement2);
        PsiJavaCodeReferenceElement reference = statement2.getImportReference();
        assert (reference != null);
        return reference;
    }

    @Override
    public void processVariants(@NotNull PsiScopeProcessor processor2) {
        if (processor2 == null) {
            PsiImportStaticReferenceElementImpl.$$$reportNull$$$0(10);
        }
        FilterScopeProcessor proc = new FilterScopeProcessor((ElementFilter)new ClassFilter(PsiModifierListOwner.class), processor2);
        PsiScopesUtil.resolveAndWalk(proc, this, null, true);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiImportStaticReferenceElementImpl.$$$reportNull$$$0(11);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitImportStaticReferenceElement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImportStaticReferenceElementImpl";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImportStaticReferenceElementImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "advancedResolve";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processVariants";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class OurGenericsResolver
    implements ResolveCache.PolyVariantResolver<PsiImportStaticReferenceElementImpl> {
        private static final OurGenericsResolver INSTANCE = new OurGenericsResolver();

        private OurGenericsResolver() {
        }

        @Override
        public JavaResolveResult @NotNull [] resolve(@NotNull PsiImportStaticReferenceElementImpl referenceElement, boolean incompleteCode) {
            PsiElement qualifier;
            if (referenceElement == null) {
                OurGenericsResolver.$$$reportNull$$$0(0);
            }
            if (!((qualifier = referenceElement.getQualifier()) instanceof PsiJavaCodeReferenceElement)) {
                if (JavaResolveResult.EMPTY_ARRAY == null) {
                    OurGenericsResolver.$$$reportNull$$$0(1);
                }
                return JavaResolveResult.EMPTY_ARRAY;
            }
            PsiElement target = ((PsiJavaCodeReferenceElement)qualifier).resolve();
            if (!(target instanceof PsiClass)) {
                if (JavaResolveResult.EMPTY_ARRAY == null) {
                    OurGenericsResolver.$$$reportNull$$$0(2);
                }
                return JavaResolveResult.EMPTY_ARRAY;
            }
            StaticImportResolveProcessor processor2 = new StaticImportResolveProcessor(referenceElement);
            target.processDeclarations(processor2, ResolveState.initial(), referenceElement, referenceElement);
            JavaResolveResult[] javaResolveResultArray = processor2.getResults();
            if (javaResolveResultArray == null) {
                OurGenericsResolver.$$$reportNull$$$0(3);
            }
            return javaResolveResultArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceElement";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImportStaticReferenceElementImpl$OurGenericsResolver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImportStaticReferenceElementImpl$OurGenericsResolver";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

