/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.AnnotationTargetUtil;
import org.jetbrains.kotlin.com.intellij.lang.ASTFactory;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiDisjunctionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiEllipsisType;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.TypeAnnotationProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.GeneratedMarkerVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.Factory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.CharTable;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.JBIterable;
import org.jetbrains.kotlin.com.intellij.util.containers.Stack;

public class JavaSharedImplUtil {
    private static final Logger LOG = Logger.getInstance(JavaSharedImplUtil.class);
    private static final TokenSet BRACKETS = TokenSet.create(JavaTokenType.LBRACKET, JavaTokenType.RBRACKET);

    private JavaSharedImplUtil() {
    }

    public static PsiType getType(@NotNull PsiTypeElement typeElement, @NotNull PsiElement anchor2) {
        if (typeElement == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(0);
        }
        if (anchor2 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(1);
        }
        return JavaSharedImplUtil.getType(typeElement, anchor2, null);
    }

    public static PsiType getType(@NotNull PsiTypeElement typeElement, @NotNull PsiElement anchor2, @Nullable PsiAnnotation stopAt) {
        if (typeElement == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(2);
        }
        if (anchor2 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(3);
        }
        PsiType type2 = typeElement.getType();
        List<PsiAnnotation[]> allAnnotations = JavaSharedImplUtil.collectAnnotations(anchor2, stopAt);
        if (allAnnotations == null) {
            return null;
        }
        for (PsiAnnotation[] annotations2 : allAnnotations) {
            type2 = type2.createArrayType().annotate(TypeAnnotationProvider.Static.create(annotations2));
        }
        return type2;
    }

    @Nullable
    private static List<PsiAnnotation[]> collectAnnotations(@NotNull PsiElement anchor2, @Nullable PsiAnnotation stopAt) {
        if (anchor2 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(4);
        }
        SmartList<PsiAnnotation[]> annotations2 = new SmartList<PsiAnnotation[]>();
        SmartList<PsiAnnotation> current2 = null;
        boolean found = stopAt == null;
        boolean stop = false;
        for (PsiElement child = anchor2.getNextSibling(); child != null; child = child.getNextSibling()) {
            if (child instanceof PsiComment || child instanceof PsiWhiteSpace) continue;
            if (child instanceof PsiAnnotation) {
                if (current2 == null) {
                    current2 = new SmartList<PsiAnnotation>();
                }
                current2.add((PsiAnnotation)child);
                if (child != stopAt) continue;
                stop = true;
                found = true;
                continue;
            }
            if (PsiUtil.isJavaToken(child, JavaTokenType.LBRACKET)) {
                annotations2.add(current2 == null ? PsiAnnotation.EMPTY_ARRAY : ContainerUtil.toArray(current2, PsiAnnotation.ARRAY_FACTORY));
                current2 = null;
                if (!stop) continue;
                return annotations2;
            }
            if (!PsiUtil.isJavaToken(child, JavaTokenType.RBRACKET)) break;
        }
        return !found || stop ? null : annotations2;
    }

    @NotNull
    public static PsiType applyAnnotations(@NotNull PsiType type2, @Nullable PsiModifierList modifierList2) {
        PsiAnnotation[] annotations2;
        if (type2 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(5);
        }
        if (modifierList2 != null && (annotations2 = modifierList2.getAnnotations()).length > 0) {
            if (type2 instanceof PsiArrayType) {
                Stack<PsiArrayType> types2 = new Stack<PsiArrayType>();
                do {
                    types2.push((PsiArrayType)type2);
                } while ((type2 = ((PsiArrayType)type2).getComponentType()) instanceof PsiArrayType);
                type2 = JavaSharedImplUtil.annotate(type2, modifierList2, annotations2);
                while (!types2.isEmpty()) {
                    PsiArrayType t = (PsiArrayType)types2.pop();
                    type2 = t instanceof PsiEllipsisType ? new PsiEllipsisType(type2, t.getAnnotations()) : new PsiArrayType(type2, t.getAnnotations());
                }
                PsiType psiType2 = type2;
                if (psiType2 == null) {
                    JavaSharedImplUtil.$$$reportNull$$$0(6);
                }
                return psiType2;
            }
            if (type2 instanceof PsiDisjunctionType) {
                ArrayList<PsiType> components2 = new ArrayList<PsiType>(((PsiDisjunctionType)type2).getDisjunctions());
                components2.set(0, JavaSharedImplUtil.annotate((PsiType)components2.get(0), modifierList2, annotations2));
                PsiDisjunctionType psiDisjunctionType = ((PsiDisjunctionType)type2).newDisjunctionType(components2);
                if (psiDisjunctionType == null) {
                    JavaSharedImplUtil.$$$reportNull$$$0(7);
                }
                return psiDisjunctionType;
            }
            return JavaSharedImplUtil.annotate(type2, modifierList2, annotations2);
        }
        PsiType psiType3 = type2;
        if (psiType3 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(8);
        }
        return psiType3;
    }

    @NotNull
    private static PsiType annotate(@NotNull PsiType type2, @NotNull PsiModifierList modifierList2, PsiAnnotation @NotNull [] annotations2) {
        if (type2 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(9);
        }
        if (modifierList2 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(10);
        }
        if (annotations2 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(11);
        }
        TypeAnnotationProvider original = modifierList2.getParent() instanceof PsiMethod ? type2.getAnnotationProvider() : TypeAnnotationProvider.EMPTY;
        FilteringTypeAnnotationProvider provider = new FilteringTypeAnnotationProvider(annotations2, original);
        PsiType psiType2 = type2.annotate(provider);
        if (psiType2 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(12);
        }
        return psiType2;
    }

    public static void normalizeBrackets(@NotNull PsiVariable variable2) {
        if (variable2 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(13);
        }
        CompositeElement variableElement = (CompositeElement)variable2.getNode();
        PsiTypeElement typeElement = variable2.getTypeElement();
        PsiIdentifier nameElement = variable2.getNameIdentifier();
        LOG.assertTrue(typeElement != null && nameElement != null);
        ASTNode type2 = typeElement.getNode();
        ASTNode name2 = nameElement.getNode();
        ASTNode firstBracket = null;
        ASTNode lastBracket = null;
        int arrayCount = 0;
        ASTNode element = name2;
        while (element != null && (element = PsiImplUtil.skipWhitespaceAndComments(element.getTreeNext())) != null && element.getElementType() == JavaTokenType.LBRACKET) {
            if (firstBracket == null) {
                firstBracket = element;
            }
            lastBracket = element;
            ++arrayCount;
            if ((element = PsiImplUtil.skipWhitespaceAndComments(element.getTreeNext())) == null || element.getElementType() != JavaTokenType.RBRACKET) break;
            lastBracket = element;
        }
        if (firstBracket != null) {
            element = firstBracket;
            while (true) {
                ASTNode next = element.getTreeNext();
                CodeEditUtil.removeChild(variableElement, element);
                if (element == lastBracket) break;
                element = next;
            }
            CompositeElement newType = (CompositeElement)type2.clone();
            for (int i = 0; i < arrayCount; ++i) {
                CompositeElement newType1 = ASTFactory.composite(JavaElementType.TYPE);
                newType1.rawAddChildren(newType);
                newType1.rawAddChildren(ASTFactory.leaf(JavaTokenType.LBRACKET, "["));
                newType1.rawAddChildren(ASTFactory.leaf(JavaTokenType.RBRACKET, "]"));
                newType = newType1;
                newType.acceptTree(new GeneratedMarkerVisitor());
            }
            newType.putUserData(CharTable.CHAR_TABLE_KEY, SharedImplUtil.findCharTableByTree(type2));
            CodeEditUtil.replaceChild(variableElement, type2, newType);
        }
    }

    public static void setInitializer(@NotNull PsiVariable variable2, PsiExpression initializer2) throws IncorrectOperationException {
        PsiExpression oldInitializer;
        if (variable2 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(14);
        }
        if ((oldInitializer = variable2.getInitializer()) != null) {
            oldInitializer.delete();
        }
        if (initializer2 == null) {
            return;
        }
        CompositeElement variableElement = (CompositeElement)variable2.getNode();
        ASTNode eq = variableElement.findChildByRole(20);
        if (eq == null) {
            CharTable charTable = SharedImplUtil.findCharTableByTree(variableElement);
            eq = Factory.createSingleLeafElement(JavaTokenType.EQ, "=", 0, 1, charTable, variable2.getManager());
            PsiIdentifier identifier = variable2.getNameIdentifier();
            assert (identifier != null) : variable2;
            ASTNode node = PsiImplUtil.skipWhitespaceCommentsAndTokens(identifier.getNode().getTreeNext(), BRACKETS);
            variableElement.addInternal((TreeElement)eq, eq, node, Boolean.TRUE);
            eq = variableElement.findChildByRole(20);
            assert (eq != null) : variable2;
        }
        variable2.addAfter(initializer2, eq.getPsi());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/JavaSharedImplUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/JavaSharedImplUtil";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "applyAnnotations";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "annotate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectAnnotations";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyAnnotations";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "normalizeBrackets";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setInitializer";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FilteringTypeAnnotationProvider
    implements TypeAnnotationProvider {
        private final PsiAnnotation[] myCandidates;
        private final TypeAnnotationProvider myOriginalProvider;
        private volatile PsiAnnotation[] myCache;

        private FilteringTypeAnnotationProvider(PsiAnnotation @NotNull [] candidates2, @NotNull TypeAnnotationProvider originalProvider) {
            if (originalProvider == null) {
                FilteringTypeAnnotationProvider.$$$reportNull$$$0(0);
            }
            if (candidates2 == null) {
                FilteringTypeAnnotationProvider.$$$reportNull$$$0(1);
            }
            this.myCandidates = candidates2;
            this.myOriginalProvider = originalProvider;
        }

        @Override
        public PsiAnnotation @NotNull [] getAnnotations() {
            PsiAnnotation[] result2 = this.myCache;
            if (result2 == null) {
                List<PsiAnnotation> filtered = JBIterable.of(this.myCandidates).filter(annotation2 -> AnnotationTargetUtil.isTypeAnnotation(annotation2)).append((PsiAnnotation)this.myOriginalProvider.getAnnotations()).toList();
                result2 = filtered.isEmpty() ? PsiAnnotation.EMPTY_ARRAY : filtered.toArray(PsiAnnotation.EMPTY_ARRAY);
                this.myCache = result2;
            }
            if (result2 == null) {
                FilteringTypeAnnotationProvider.$$$reportNull$$$0(2);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalProvider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "candidates";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/JavaSharedImplUtil$FilteringTypeAnnotationProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/JavaSharedImplUtil$FilteringTypeAnnotationProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnnotations";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

