/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.builder;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirFunctionTarget;
import org.jetbrains.kotlin.fir.FirLabel;
import org.jetbrains.kotlin.fir.FirLoopTarget;
import org.jetbrains.kotlin.fir.FirSourceElementKind;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.kotlinx.collections.immutable.ExtensionsKt;
import org.jetbrains.kotlin.kotlinx.collections.immutable.PersistentList;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\rR\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\rR\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\rR\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\rR\u001c\u0010+\u001a\u0004\u0018\u00010,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u0017\u00101\u001a\b\u0012\u0004\u0012\u0002020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\rR\u001a\u00104\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u0018\"\u0004\b6\u0010\u001a\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/fir/builder/Context;", "T", "", "()V", "arraySetArgument", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getArraySetArgument", "()Ljava/util/Map;", "calleeNamesForLambda", "", "Lorg/jetbrains/kotlin/name/Name;", "getCalleeNamesForLambda", "()Ljava/util/List;", "capturedTypeParameters", "Lorg/jetbrains/kotlin/kotlinx/collections/immutable/PersistentList;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "getCapturedTypeParameters", "()Lkotlinx/collections/immutable/PersistentList;", "setCapturedTypeParameters", "(Lkotlinx/collections/immutable/PersistentList;)V", "className", "Lorg/jetbrains/kotlin/name/FqName;", "getClassName", "()Lorg/jetbrains/kotlin/name/FqName;", "setClassName", "(Lorg/jetbrains/kotlin/name/FqName;)V", "currentClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "getCurrentClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "dispatchReceiverTypesStack", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "getDispatchReceiverTypesStack", "firFunctionTargets", "Lorg/jetbrains/kotlin/fir/FirFunctionTarget;", "getFirFunctionTargets", "firLabels", "Lorg/jetbrains/kotlin/fir/FirLabel;", "getFirLabels", "firLoopTargets", "Lorg/jetbrains/kotlin/fir/FirLoopTarget;", "getFirLoopTargets", "forcedElementSourceKind", "Lorg/jetbrains/kotlin/fir/FirSourceElementKind;", "getForcedElementSourceKind", "()Lorg/jetbrains/kotlin/fir/FirSourceElementKind;", "setForcedElementSourceKind", "(Lorg/jetbrains/kotlin/fir/FirSourceElementKind;)V", "localBits", "", "getLocalBits", "packageFqName", "getPackageFqName", "setPackageFqName", "raw-fir.common"})
public final class Context<T> {
    public FqName packageFqName;
    @NotNull
    private FqName className;
    @NotNull
    private final List<Boolean> localBits;
    @NotNull
    private final List<FirFunctionTarget> firFunctionTargets;
    @NotNull
    private final List<Name> calleeNamesForLambda;
    @NotNull
    private final List<FirLabel> firLabels;
    @NotNull
    private final List<FirLoopTarget> firLoopTargets;
    @NotNull
    private PersistentList<FirTypeParameterSymbol> capturedTypeParameters;
    @NotNull
    private final Map<T, FirExpression> arraySetArgument;
    @Nullable
    private FirSourceElementKind forcedElementSourceKind;
    @NotNull
    private final List<ConeClassLikeType> dispatchReceiverTypesStack;

    public Context() {
        FqName fqName2 = FqName.ROOT;
        Intrinsics.checkNotNullExpressionValue(fqName2, "ROOT");
        this.className = fqName2;
        boolean bl = false;
        this.localBits = new ArrayList();
        bl = false;
        this.firFunctionTargets = new ArrayList();
        bl = false;
        this.calleeNamesForLambda = new ArrayList();
        bl = false;
        this.firLabels = new ArrayList();
        bl = false;
        this.firLoopTargets = new ArrayList();
        this.capturedTypeParameters = ExtensionsKt.persistentListOf();
        bl = false;
        this.arraySetArgument = new LinkedHashMap();
        bl = false;
        this.dispatchReceiverTypesStack = new ArrayList();
    }

    @NotNull
    public final FqName getPackageFqName() {
        FqName fqName2 = this.packageFqName;
        if (fqName2 != null) {
            return fqName2;
        }
        Intrinsics.throwUninitializedPropertyAccessException("packageFqName");
        throw null;
    }

    public final void setPackageFqName(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "<set-?>");
        this.packageFqName = fqName2;
    }

    @NotNull
    public final FqName getClassName() {
        return this.className;
    }

    public final void setClassName(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "<set-?>");
        this.className = fqName2;
    }

    @NotNull
    public final List<Boolean> getLocalBits() {
        return this.localBits;
    }

    @NotNull
    public final ClassId getCurrentClassId() {
        Boolean bl;
        return new ClassId(this.getPackageFqName(), this.className, (bl = CollectionsKt.lastOrNull(this.localBits)) == null ? false : bl);
    }

    @NotNull
    public final List<FirFunctionTarget> getFirFunctionTargets() {
        return this.firFunctionTargets;
    }

    @NotNull
    public final List<Name> getCalleeNamesForLambda() {
        return this.calleeNamesForLambda;
    }

    @NotNull
    public final List<FirLabel> getFirLabels() {
        return this.firLabels;
    }

    @NotNull
    public final List<FirLoopTarget> getFirLoopTargets() {
        return this.firLoopTargets;
    }

    @NotNull
    public final PersistentList<FirTypeParameterSymbol> getCapturedTypeParameters() {
        return this.capturedTypeParameters;
    }

    public final void setCapturedTypeParameters(@NotNull PersistentList<FirTypeParameterSymbol> persistentList) {
        Intrinsics.checkNotNullParameter(persistentList, "<set-?>");
        this.capturedTypeParameters = persistentList;
    }

    @NotNull
    public final Map<T, FirExpression> getArraySetArgument() {
        return this.arraySetArgument;
    }

    @Nullable
    public final FirSourceElementKind getForcedElementSourceKind() {
        return this.forcedElementSourceKind;
    }

    public final void setForcedElementSourceKind(@Nullable FirSourceElementKind firSourceElementKind) {
        this.forcedElementSourceKind = firSourceElementKind;
    }

    @NotNull
    public final List<ConeClassLikeType> getDispatchReceiverTypesStack() {
        return this.dispatchReceiverTypesStack;
    }
}

